/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.array;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import org.geotools.resources.XArray;

public final class ArrayData {
    private float[] array;
    private int arrayLength;
    private int[] curves;
    private boolean[] cubics;
    private int curveLength;
    private int nextCurve;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArrayData(int capacity) {
        this.array = new float[capacity << 1];
    }

    final float[] getArray() {
        return this.array;
    }

    public final int length() {
        return this.arrayLength >> 1;
    }

    public final void extract(int offset, GeneralPath path) {
        int i = offset <<= 1;
        while (i < this.arrayLength) {
            if (i == offset) {
                path.moveTo(this.array[i++], this.array[i++]);
                continue;
            }
            path.lineTo(this.array[i++], this.array[i++]);
        }
        this.arrayLength = offset;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(Shape shape) throws IllegalPathStateException {
        int start = this.arrayLength;
        float[] coords = new float[6];
        PathIterator it = shape.getPathIterator(null);
        while (!it.isDone()) {
            void var5_5;
            switch (it.currentSegment(coords)) {
                case 0: {
                    if (this.arrayLength != start) {
                        throw new IllegalPathStateException();
                    }
                }
                case 1: {
                    int n = 2;
                    break;
                }
                case 2: {
                    int n = 4;
                    this.addCurve(this.arrayLength, false);
                    break;
                }
                case 3: {
                    int n = 6;
                    this.addCurve(this.arrayLength, true);
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            if (this.arrayLength + var5_5 >= this.array.length) {
                this.array = XArray.resize(this.array, this.arrayLength + var5_5 + 256);
            }
            System.arraycopy(coords, 0, this.array, this.arrayLength, (int)var5_5);
            this.arrayLength += var5_5;
            it.next();
        }
        if (!$assertionsDisabled && (this.arrayLength & 1) != 0) {
            throw new AssertionError(this.arrayLength);
        }
    }

    private final void addCurve(int index, boolean isCubic) {
        if (this.curves == null) {
            this.curves = new int[6];
            if (!$assertionsDisabled && this.curveLength != 0) {
                throw new AssertionError(this.curveLength);
            }
            if (!$assertionsDisabled && this.nextCurve != 0) {
                throw new AssertionError(this.nextCurve);
            }
        } else if (this.curveLength >= this.curves.length) {
            this.curves = XArray.resize(this.curves, this.curveLength * 2);
            if (this.cubics != null) {
                this.cubics = XArray.resize(this.cubics, this.curves.length);
            }
        }
        if (this.cubics != null) {
            this.cubics[this.curveLength] = isCubic;
        } else if (isCubic) {
            this.cubics = new boolean[this.curves.length];
            this.cubics[this.curveLength] = isCubic;
        }
        this.curves[this.curveLength++] = index;
    }

    final int getCurveType(int index) {
        if (this.nextCurve != this.curveLength) {
            if (!$assertionsDisabled && this.nextCurve >= this.curveLength) {
                throw new AssertionError(this.nextCurve);
            }
            if (!$assertionsDisabled && this.curves[this.nextCurve] < index) {
                throw new AssertionError(index);
            }
            if (!$assertionsDisabled && this.nextCurve != 0 && this.curves[this.nextCurve - 1] >= index) {
                throw new AssertionError(index);
            }
            if (this.curves[this.nextCurve] == index) {
                return this.cubics != null && this.cubics[this.nextCurve++] ? 3 : 2;
            }
        }
        return index == 0 ? 0 : 1;
    }

    static {
        $assertionsDisabled = !ArrayData.class.desiredAssertionStatus();
    }
}

