/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.array;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.RandomAccess;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.array.ArrayData;
import org.geotools.geometry.array.CompressionLevel;
import org.geotools.geometry.array.ListAdapter;
import org.geotools.geometry.array.PointIterator;
import org.geotools.geometry.array.SequentialListAdapter;
import org.geotools.geometry.array.ShapeAdapter;
import org.geotools.referencing.CRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.geometry.PointArray;

public abstract class PointArray2D
implements PointArray,
Serializable {
    private static final long serialVersionUID = -4959895593401691530L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PointArray2D() {
    }

    public final int getDimension() {
        return 2;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    private boolean isCompatible(CoordinateReferenceSystem crs) {
        CoordinateReferenceSystem expected;
        if (crs != null && (expected = this.getCoordinateReferenceSystem()) != null) {
            return CRS.equalsIgnoreMetadata(crs, expected);
        }
        return true;
    }

    int lower() {
        return 0;
    }

    int upper() {
        return 2 * this.length();
    }

    public abstract int length();

    public abstract long getMemoryUsage();

    public DirectPosition get(int index, DirectPosition dest) throws IndexOutOfBoundsException {
        PointIterator it = this.iterator(index);
        if (dest != null) {
            if (!$assertionsDisabled && !this.isCompatible(dest.getCoordinateReferenceSystem())) {
                throw new AssertionError(dest);
            }
            dest.setOrdinate(0, (double)it.nextX());
            dest.setOrdinate(1, (double)it.nextY());
        } else {
            dest = new DirectPosition2D(this.getCoordinateReferenceSystem(), it.nextX(), it.nextY());
        }
        return dest;
    }

    public void set(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(137));
    }

    public List positions() {
        if (this instanceof RandomAccess) {
            return new ListAdapter(this);
        }
        return new SequentialListAdapter(this);
    }

    public abstract PointIterator iterator(int var1) throws IndexOutOfBoundsException;

    PathIterator getPathIterator(AffineTransform at) {
        return new ShapeAdapter.Iterator(this.iterator(0), at);
    }

    public Rectangle2D getBounds2D() {
        float xmin = Float.POSITIVE_INFINITY;
        float xmax = Float.NEGATIVE_INFINITY;
        float ymin = Float.POSITIVE_INFINITY;
        float ymax = Float.NEGATIVE_INFINITY;
        PointIterator it = this.iterator(0);
        while (it.hasNext()) {
            float x = it.nextX();
            float y = it.nextY();
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        if (xmin <= xmax && ymin <= ymax) {
            return new Rectangle2D.Float(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return null;
    }

    public abstract PointArray2D subarray(int var1, int var2);

    public final PointArray2D insertAt(int index, PointArray2D toMerge, boolean reverse) {
        return toMerge.insertInto(this, index, reverse);
    }

    PointArray2D insertInto(PointArray2D dest, int index, boolean reverse) {
        float[] array = this.toFloatArray();
        return dest.insertAt(index, array, 0, array.length, reverse);
    }

    public abstract PointArray2D insertAt(int var1, float[] var2, int var3, int var4, boolean var5);

    public abstract PointArray2D reverse();

    public PointArray2D getFinal(CompressionLevel level) {
        return this.length() > 0 ? this : null;
    }

    public abstract void toFloatArray(ArrayData var1, float var2);

    public final float[] toFloatArray() {
        ArrayData data = new ArrayData(2 * this.length());
        this.toFloatArray(data, 0.0f);
        float[] array = data.getArray();
        if (!$assertionsDisabled && array.length != data.length() * 2) {
            throw new AssertionError();
        }
        return array;
    }

    final int capacity(int src, int dst, int offset) {
        int guess;
        int lower = this.lower();
        int length = this.upper() - lower;
        dst -= offset;
        if (!$assertionsDisabled && ((src -= lower) & 1) != 0) {
            throw new AssertionError(src);
        }
        if (!$assertionsDisabled && (dst & 1) != 0) {
            throw new AssertionError(dst);
        }
        if (src == 0) {
            guess = length / 8;
        } else {
            guess = (int)((long)dst * (long)length / (long)src);
            guess -= dst;
            guess += guess / 8;
        }
        return offset + Math.min(length, dst + Math.max(guess &= 0xFFFFFFFE, 32));
    }

    public final Shape toShape(AffineTransform transform) {
        return new ShapeAdapter(this, transform);
    }

    public final String toString() {
        DirectPosition2D point = new DirectPosition2D();
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        int length = this.length();
        buffer.append('[');
        buffer.append(length);
        buffer.append(" points");
        if (length != 0) {
            this.get(0, point);
            buffer.append(" (");
            buffer.append(point.x);
            buffer.append(", ");
            buffer.append(point.y);
            buffer.append(")-(");
            this.get(this.length() - 1, point);
            buffer.append(point.x);
            buffer.append(", ");
            buffer.append(point.y);
            buffer.append(')');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public final boolean equals(PointArray2D that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.length() != that.length()) {
            return false;
        }
        PointIterator it1 = this.iterator(0);
        PointIterator it2 = that.iterator(0);
        while (it1.hasNext()) {
            if (it2.hasNext() && Float.floatToIntBits(it1.nextX()) == Float.floatToIntBits(it2.nextX()) && Float.floatToIntBits(it1.nextY()) == Float.floatToIntBits(it2.nextY())) continue;
            return false;
        }
        return !it2.hasNext();
    }

    public final boolean equals(Object that) {
        return that instanceof PointArray2D && this.equals((PointArray2D)that);
    }

    public final int hashCode() {
        DirectPosition point = this.get(0, null);
        return this.length() ^ Float.floatToIntBits((float)point.getOrdinate(0)) ^ Float.floatToIntBits((float)point.getOrdinate(1));
    }

    static void checkRange(float[] array, int lower, int upper) throws IllegalArgumentException {
        if (!$assertionsDisabled && (array.length & 1) != 0) {
            throw new AssertionError(array.length);
        }
        if (!$assertionsDisabled && (lower & 1) != 0) {
            throw new AssertionError(lower);
        }
        if (!$assertionsDisabled && (upper & 1) != 0) {
            throw new AssertionError(upper);
        }
        if (upper < lower) {
            throw new IllegalArgumentException(Errors.format(13, new Integer(lower), new Integer(upper)));
        }
        if ((upper - lower & 1) != 0) {
            throw new IllegalArgumentException(Errors.format(109, new Integer(upper - lower)));
        }
        if (lower < 0) {
            throw new ArrayIndexOutOfBoundsException(lower);
        }
        if (upper > array.length) {
            throw new ArrayIndexOutOfBoundsException(upper);
        }
    }

    static {
        $assertionsDisabled = !PointArray2D.class.desiredAssertionStatus();
    }
}

