/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.array;

import java.io.Serializable;
import java.util.AbstractList;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.array.PointArray2D;
import org.geotools.geometry.array.PointIterator;

final class SequentialListAdapter
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = 3292825548291763699L;
    private final PointArray2D array;
    private transient PointIterator iterator;
    private transient int nextIndex;

    public SequentialListAdapter(PointArray2D array) {
        this.array = array;
    }

    public int size() {
        return this.array.length();
    }

    public Object get(int index) {
        if (this.iterator == null || index != this.nextIndex) {
            this.iterator = this.array.iterator(index);
            this.nextIndex = index;
        }
        float x = this.iterator.nextX();
        float y = this.iterator.nextY();
        ++this.nextIndex;
        return new DirectPosition2D(this.array.getCoordinateReferenceSystem(), x, y);
    }
}

