/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.array;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.geotools.geometry.array.PointArray2D;
import org.geotools.geometry.array.PointIterator;
import org.geotools.referencing.operation.matrix.XAffineTransform;

final class ShapeAdapter
implements Shape,
Serializable {
    private static final long serialVersionUID = -2865985425309822004L;
    private final AffineTransform transform;
    private Rectangle2D bounds;
    private final PointArray2D array;

    public ShapeAdapter(PointArray2D array, AffineTransform transform) {
        if (transform != null && transform.isIdentity()) {
            transform = null;
        }
        this.transform = transform;
        this.array = array;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.getInternalBounds2D().intersects(r);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.getInternalBounds2D().intersects(x, y, w, h);
    }

    public Rectangle getBounds() {
        return this.getInternalBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.getInternalBounds2D().clone();
    }

    private Rectangle2D getInternalBounds2D() {
        if (this.bounds == null) {
            this.bounds = this.array.getBounds2D();
            if (this.bounds == null) {
                this.bounds = new Rectangle2D.Float();
            } else if (this.transform != null) {
                this.bounds = XAffineTransform.transform(this.transform, this.bounds, this.bounds);
            }
        }
        return this.bounds;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        if (at == null || at.isIdentity()) {
            at = this.transform;
        } else if (this.transform != null) {
            at = new AffineTransform(at);
            at.concatenate(this.transform);
        }
        return this.array.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    static final class Iterator
    extends Point2D.Double
    implements PathIterator {
        private final PointIterator it;
        private final AffineTransform at;
        private int move;

        public Iterator(PointIterator it, AffineTransform at) {
            this.it = it;
            this.at = at;
            this.next();
            if (this.move == 1) {
                this.move = 0;
            }
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.move == 4;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.x;
            coords[1] = this.y;
            return this.move;
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            return this.move;
        }

        public void next() {
            this.move = 1;
            while (this.it.hasNext()) {
                this.x = this.it.nextX();
                this.y = this.it.nextY();
                if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
                    if (this.at != null) {
                        this.at.transform(this, this);
                    }
                    return;
                }
                this.move = 0;
            }
            this.move = 4;
        }
    }
}

