/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import org.jdom.Document;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

class CatalogBuilderHelper {
    CatalogBuilderHelper() {
    }

    static CrawlableDataset verifyDescendantDataset(CrawlableDataset ancestorCrDs, String path, CrawlableDatasetFilter filter) {
        CrawlableDataset targetCrDs;
        if (!ancestorCrDs.isCollection()) {
            throw new IllegalArgumentException("Ancestor dataset <" + ancestorCrDs.getPath() + "> not a collection.");
        }
        if (!path.startsWith(ancestorCrDs.getPath())) {
            throw new IllegalArgumentException("Dataset path <" + path + "> not descendant of given dataset <" + ancestorCrDs.getPath() + ">.");
        }
        if (path.length() == ancestorCrDs.getPath().length()) {
            return ancestorCrDs;
        }
        String remainingPath = path.substring(ancestorCrDs.getPath().length());
        if (remainingPath.startsWith("/")) {
            remainingPath = remainingPath.substring(1);
        }
        if (!(targetCrDs = ancestorCrDs.getDescendant(remainingPath)).exists()) {
            return null;
        }
        if (filter == null) {
            return targetCrDs;
        }
        CrawlableDataset curCrDs = targetCrDs;
        while (ancestorCrDs.getPath().length() < curCrDs.getPath().length()) {
            if (!filter.accept(curCrDs)) {
                return null;
            }
            curCrDs = curCrDs.getParentDataset();
        }
        return targetCrDs;
    }

    static Document convertCatalogToDocument(InvCatalog catalog) {
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory(false);
        InvCatalogConvertIF converter = fac.getCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        InvCatalogFactory10 fac10 = (InvCatalogFactory10)converter;
        return fac10.writeCatalog((InvCatalogImpl)catalog);
    }

    static String convertCatalogToString(InvCatalog catalog) {
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory(false);
        try {
            return fac.writeXML((InvCatalogImpl)catalog);
        }
        catch (IOException e) {
            return null;
        }
    }
}

