/*
 * GWT-Ext Widget Library
 * Copyright 2007 - 2008, GWT-Ext LLC., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
 
package com.gwtext.client.widgets.layout;

import com.gwtext.client.util.JavaScriptObjectHelper;

/**
 * Supporting class for {@link com.gwtext.client.widgets.layout.RowLayout}.
 *
 * @author Sanjiv Jivan
 * @see com.gwtext.client.widgets.layout.RowLayout
 */
public class RowLayoutData extends LayoutData {

    public RowLayoutData() {
        JavaScriptObjectHelper.setAttribute(jsObj, "height", 0);
    }

    public RowLayoutData(String height) {
        setHeight(height);
    }

    public RowLayoutData(int height) {
        setHeight(height);
    }

    public void setHeight(int height) {
        JavaScriptObjectHelper.setAttribute(jsObj, "height", height);
    }

    public void setHeight(String height) {
        JavaScriptObjectHelper.setAttribute(jsObj, "height", height);
    }
}
