/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.CachedHttpChunks;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCachedHttpChunks
implements CachedHttpChunks {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CacheManager cacheManager;
    private volatile int chunkCount = 0;
    private final String uri;
    private volatile boolean complete = false;
    private final ChannelFutureListener writeListener;

    public DefaultCachedHttpChunks(CacheManager cacheManager, HttpRequest httpRequest, ChannelFutureListener writeListener) {
        this.cacheManager = cacheManager;
        this.writeListener = writeListener;
        this.uri = ProxyUtils.cacheUri(httpRequest);
    }

    @Override
    public void cache(HttpChunk chunk, ChannelBuffer encoded) {
        Cache cache = this.cacheManager.getCache("CHUNK_CACHE");
        String chunkUri = this.uri + this.chunkCount;
        this.log.info("Caching chunk {}", (Object)chunkUri);
        Element elem = new Element((Object)chunkUri, (Object)encoded);
        cache.put(elem);
        if (chunk.isLast()) {
            this.complete = true;
        }
        ++this.chunkCount;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean writeAllChunks(Channel channel) {
        if (!this.complete) {
            throw new IllegalStateException("Trying to write incomplete cached chunks!!");
        }
        Cache cache = this.cacheManager.getCache("CHUNK_CACHE");
        ChannelFuture cf = null;
        for (int i = 0; i < this.chunkCount; ++i) {
            String chunkUri = this.uri + i;
            Element elem = cache.get((Serializable)((Object)chunkUri));
            if (elem == null) {
                this.log.error("Could not find chunk!!! {}", (Object)chunkUri);
                throw new IllegalStateException("Missing chunk for: " + chunkUri);
            }
            ChannelBuffer encoded = (ChannelBuffer)elem.getObjectValue();
            cf = channel.write((Object)encoded);
        }
        if (cf == null) {
            this.log.error("Channel future is null?");
            throw new IllegalStateException("No future? Chunks: " + this.chunkCount);
        }
        cf.addListener(this.writeListener);
        return true;
    }
}

