/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.ConnectionData;
import org.littleshoot.proxy.HttpConnectRelayingHandler;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler
implements RelayListener,
ConnectionData {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandler.class);
    private volatile boolean readingChunks;
    private static final AtomicInteger totalBrowserToProxyConnections = new AtomicInteger(0);
    private final AtomicInteger browserToProxyConnections = new AtomicInteger(0);
    private final Map<String, Queue<ChannelFuture>> externalHostsToChannelFutures = new ConcurrentHashMap<String, Queue<ChannelFuture>>();
    private final AtomicInteger messagesReceived = new AtomicInteger(0);
    private final AtomicInteger unansweredRequestCount = new AtomicInteger(0);
    private final AtomicInteger requestsSent = new AtomicInteger(0);
    private final AtomicInteger responsesReceived = new AtomicInteger(0);
    private final ProxyAuthorizationManager authorizationManager;
    private final Set<String> answeredRequests = new HashSet<String>();
    private final Set<String> unansweredRequests = new HashSet<String>();
    private ChannelFuture currentChannelFuture;
    private final ChainProxyManager chainProxyManager;
    private final ChannelGroup channelGroup;
    private final ClientSocketChannelFactory clientChannelFactory;
    private final ProxyCacheManager cacheManager;
    private final AtomicBoolean browserChannelClosed = new AtomicBoolean(false);
    private volatile boolean receivedChannelClosed = false;
    private final boolean useJmx;
    private final RelayPipelineFactoryFactory relayPipelineFactoryFactory;

    public HttpRequestHandler(ClientSocketChannelFactory clientChannelFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory) {
        this(null, null, null, clientChannelFactory, null, relayPipelineFactoryFactory, false);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ClientSocketChannelFactory clientChannelFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory) {
        this(cacheManager, authorizationManager, channelGroup, clientChannelFactory, null, relayPipelineFactoryFactory, false);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ClientSocketChannelFactory clientChannelFactory, ChainProxyManager chainProxyManager, RelayPipelineFactoryFactory relayPipelineFactoryFactory, boolean useJmx) {
        this.cacheManager = cacheManager;
        this.authorizationManager = authorizationManager;
        this.channelGroup = channelGroup;
        this.clientChannelFactory = clientChannelFactory;
        this.chainProxyManager = chainProxyManager;
        this.relayPipelineFactoryFactory = relayPipelineFactoryFactory;
        this.useJmx = useJmx;
        if (useJmx) {
            this.setupJmx();
        }
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<?> clazz = this.getClass();
            String pack = clazz.getPackage().getName();
            String oName = pack + ":type=" + clazz.getSimpleName() + "-" + clazz.getSimpleName() + "-" + this.hashCode();
            log.info("Registering MBean with name: {}", (Object)oName);
            ObjectName mxBeanName = new ObjectName(oName);
            if (!mbs.isRegistered(mxBeanName)) {
                mbs.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent me) {
        if (this.browserChannelClosed.get()) {
            log.info("Ignoring message since the connection to the browser is about to close");
            return;
        }
        this.messagesReceived.incrementAndGet();
        log.info("Received " + this.messagesReceived + " total messages");
        if (!this.readingChunks) {
            this.processRequest(ctx, me);
        } else {
            this.processChunk(ctx, me);
        }
    }

    private void processChunk(ChannelHandlerContext ctx, MessageEvent me) {
        log.info("Processing chunk...");
        final HttpChunk chunk = (HttpChunk)me.getMessage();
        if (chunk.isLast()) {
            this.readingChunks = false;
        }
        if (this.currentChannelFuture.getChannel().isConnected()) {
            this.currentChannelFuture.getChannel().write((Object)chunk);
        } else {
            this.currentChannelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    HttpRequestHandler.this.currentChannelFuture.getChannel().write((Object)chunk);
                }
            });
        }
    }

    private void processRequest(final ChannelHandlerContext ctx, final MessageEvent me) {
        final HttpRequest request = (HttpRequest)me.getMessage();
        final Channel inboundChannel = me.getChannel();
        if (this.cacheManager != null && this.cacheManager.returnCacheHit((HttpRequest)me.getMessage(), inboundChannel)) {
            log.info("Found cache hit! Cache wrote the response.");
            return;
        }
        this.unansweredRequestCount.incrementAndGet();
        log.info("Got request: {} on channel: " + inboundChannel, (Object)request);
        if (this.authorizationManager != null && !this.authorizationManager.handleProxyAuthorization(request, ctx)) {
            log.info("Not authorized!!");
            return;
        }
        String hostAndPort = null;
        if (this.chainProxyManager != null) {
            hostAndPort = this.chainProxyManager.getChainProxy(request);
        }
        if (hostAndPort == null) {
            hostAndPort = ProxyUtils.parseHostAndPort(request);
        }
        final class OnConnect {
            OnConnect() {
            }

            public ChannelFuture onConnect(ChannelFuture cf) {
                if (request.getMethod() != HttpMethod.CONNECT) {
                    ChannelFuture writeFuture = cf.getChannel().write((Object)request);
                    writeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (HttpRequestHandler.this.useJmx) {
                                HttpRequestHandler.this.unansweredRequests.add(request.toString());
                            }
                            HttpRequestHandler.this.requestsSent.incrementAndGet();
                        }
                    });
                    return writeFuture;
                }
                HttpRequestHandler.this.writeConnectResponse(ctx, request, cf.getChannel());
                return cf;
            }
        }
        final OnConnect onConnect = new OnConnect();
        final ChannelFuture curFuture = this.getChannelFuture(hostAndPort);
        if (curFuture != null) {
            log.info("Using existing connection...");
            this.currentChannelFuture = curFuture;
            if (curFuture.getChannel().isConnected()) {
                onConnect.onConnect(curFuture);
            } else {
                ChannelFutureListener cfl = new ChannelFutureListener(){
                    {
                    }

                    public void operationComplete(ChannelFuture future) throws Exception {
                        onConnect.onConnect(curFuture);
                    }
                };
                curFuture.addListener(cfl);
            }
        } else {
            log.info("Establishing new connection");
            final ChannelFuture cf = this.newChannelFuture(request, inboundChannel, hostAndPort);
            final class LocalChannelFutureListener
            implements ChannelFutureListener {
                private final String hostAndPort;

                LocalChannelFutureListener(String hostAndPort) {
                    this.hostAndPort = hostAndPort;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel channel = future.getChannel();
                    if (HttpRequestHandler.this.channelGroup != null) {
                        HttpRequestHandler.this.channelGroup.add((Object)channel);
                    }
                    if (future.isSuccess()) {
                        log.info("Connected successfully to: {}", (Object)channel);
                        log.info("Writing message on channel...");
                        ChannelFuture wf = onConnect.onConnect(cf);
                        wf.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture wcf) throws Exception {
                                log.info("Finished write: " + wcf + " to: " + request.getMethod() + " " + request.getUri());
                            }
                        });
                    } else {
                        String nextHostAndPort;
                        log.info("Could not connect to " + this.hostAndPort, future.getCause());
                        if (HttpRequestHandler.this.chainProxyManager == null) {
                            nextHostAndPort = this.hostAndPort;
                        } else {
                            HttpRequestHandler.this.chainProxyManager.onCommunicationError(this.hostAndPort);
                            nextHostAndPort = HttpRequestHandler.this.chainProxyManager.getChainProxy(request);
                        }
                        if (this.hostAndPort.equals(nextHostAndPort)) {
                            HttpRequestHandler.this.onRelayChannelClose(inboundChannel, this.hostAndPort, 1, true);
                        } else {
                            HttpRequestHandler.this.removeProxyToWebConnection(this.hostAndPort);
                            HttpRequestHandler.this.processRequest(ctx, me);
                        }
                    }
                }
            }
            cf.addListener((ChannelFutureListener)new LocalChannelFutureListener(hostAndPort));
        }
        if (request.isChunked()) {
            this.readingChunks = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChannelAvailable(String hostAndPortKey, ChannelFuture cf) {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> toUse;
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(hostAndPortKey);
            if (futures == null) {
                toUse = new LinkedList<ChannelFuture>();
                this.externalHostsToChannelFutures.put(hostAndPortKey, toUse);
            } else {
                toUse = futures;
            }
            toUse.add(cf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture getChannelFuture(String hostAndPort) {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(hostAndPort);
            if (futures == null) {
                return null;
            }
            if (futures.isEmpty()) {
                return null;
            }
            ChannelFuture cf = futures.remove();
            if (cf != null && cf.isSuccess() && !cf.getChannel().isConnected()) {
                this.removeProxyToWebConnection(hostAndPort);
                return null;
            }
            return cf;
        }
    }

    private void writeConnectResponse(ChannelHandlerContext ctx, HttpRequest httpRequest, final Channel outgoingChannel) {
        int port = ProxyUtils.parsePort(httpRequest);
        Channel browserToProxyChannel = ctx.getChannel();
        if (port < 0) {
            log.warn("Connecting on port other than 443!!");
            String statusLine = "HTTP/1.1 502 Proxy Error\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 502 Proxy Error\r\n", ProxyUtils.PROXY_ERROR_HEADERS);
            ProxyUtils.closeOnFlush(browserToProxyChannel);
        } else {
            browserToProxyChannel.setReadable(false);
            ctx.getPipeline().remove("encoder");
            ctx.getPipeline().remove("decoder");
            ctx.getPipeline().remove("handler");
            ctx.getPipeline().addLast("handler", (ChannelHandler)new HttpConnectRelayingHandler(outgoingChannel, this.channelGroup));
        }
        String chainProxy = null;
        if (this.chainProxyManager != null && (chainProxy = this.chainProxyManager.getChainProxy(httpRequest)) != null) {
            outgoingChannel.getPipeline().addBefore("handler", "encoder", (ChannelHandler)new HttpRequestEncoder());
            outgoingChannel.write((Object)httpRequest).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    outgoingChannel.getPipeline().remove("encoder");
                }
            });
        }
        if (chainProxy == null) {
            String statusLine = "HTTP/1.1 200 Connection established\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 200 Connection established\r\n", ProxyUtils.CONNECT_OK_HEADERS);
        }
        browserToProxyChannel.setReadable(true);
    }

    private ChannelFuture newChannelFuture(HttpRequest httpRequest, final Channel browserToProxyChannel, String hostAndPort) {
        int port;
        String host;
        if (hostAndPort.contains(":")) {
            host = StringUtils.substringBefore((String)hostAndPort, (String)":");
            String portString = StringUtils.substringAfter((String)hostAndPort, (String)":");
            port = Integer.parseInt(portString);
        } else {
            host = hostAndPort;
            port = 80;
        }
        ClientBootstrap cb = new ClientBootstrap((ChannelFactory)this.clientChannelFactory);
        ChannelPipelineFactory cpf = httpRequest.getMethod() == HttpMethod.CONNECT ? new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("handler", (ChannelHandler)new HttpConnectRelayingHandler(browserToProxyChannel, HttpRequestHandler.this.channelGroup));
                return pipeline;
            }
        } : this.relayPipelineFactoryFactory.getRelayPipelineFactory(httpRequest, browserToProxyChannel, this);
        cb.setPipelineFactory(cpf);
        cb.setOption("connectTimeoutMillis", (Object)40000);
        log.info("Starting new connection to: {}", (Object)hostAndPort);
        ChannelFuture future = cb.connect((SocketAddress)new InetSocketAddress(host, port));
        return future;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        Channel inboundChannel = cse.getChannel();
        log.info("New channel opened: {}", (Object)inboundChannel);
        totalBrowserToProxyConnections.incrementAndGet();
        this.browserToProxyConnections.incrementAndGet();
        log.info("Now " + totalBrowserToProxyConnections + " browser to proxy channels...");
        log.info("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.channelGroup != null) {
            this.channelGroup.add((Object)inboundChannel);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent cse) {
        log.info("Channel closed: {}", (Object)cse.getChannel());
        totalBrowserToProxyConnections.decrementAndGet();
        this.browserToProxyConnections.decrementAndGet();
        log.info("Now " + totalBrowserToProxyConnections + " total browser to proxy channels...");
        log.info("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.browserToProxyConnections.get() == 0) {
            log.info("Closing all proxy to web channels for this browser to proxy connection!!!");
            Collection<Queue<ChannelFuture>> allFutures = this.externalHostsToChannelFutures.values();
            for (Queue<ChannelFuture> futures : allFutures) {
                for (ChannelFuture future : futures) {
                    Channel ch = future.getChannel();
                    if (!ch.isOpen()) continue;
                    future.getChannel().close();
                }
            }
        }
    }

    @Override
    public void onRelayChannelClose(Channel browserToProxyChannel, String key, int unansweredRequestsOnChannel, boolean closedEndsResponseBody) {
        if (closedEndsResponseBody) {
            log.info("Close ends response body");
            this.receivedChannelClosed = true;
        }
        log.info("this.receivedChannelClosed: " + this.receivedChannelClosed);
        this.removeProxyToWebConnection(key);
        this.unansweredRequestCount.set(this.unansweredRequestCount.get() - unansweredRequestsOnChannel);
        if (this.receivedChannelClosed && (this.externalHostsToChannelFutures.isEmpty() || this.unansweredRequestCount.get() == 0)) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.info("Closing browser to proxy channel");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.info("Not closing browser to proxy channel. Still " + this.externalHostsToChannelFutures.size() + " connections and awaiting " + this.unansweredRequestCount + " responses");
        }
    }

    private void removeProxyToWebConnection(String key) {
        this.externalHostsToChannelFutures.remove(key);
    }

    @Override
    public void onRelayHttpResponse(Channel browserToProxyChannel, String key, HttpRequest httpRequest) {
        if (this.useJmx) {
            this.answeredRequests.add(httpRequest.toString());
            this.unansweredRequests.remove(httpRequest.toString());
        }
        this.unansweredRequestCount.decrementAndGet();
        this.responsesReceived.incrementAndGet();
        if (this.unansweredRequestCount.get() == 0 && this.receivedChannelClosed) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.info("Closing browser to proxy channel on HTTP response");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.info("Not closing browser to proxy channel. Still awaiting " + this.unansweredRequestCount + " responses..." + "receivedChannelClosed=" + this.receivedChannelClosed);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof ClosedChannelException) {
            log.warn("Caught an exception on browser to proxy channel: " + channel, cause);
        } else {
            log.info("Caught an exception on browser to proxy channel: " + channel, cause);
        }
        ProxyUtils.closeOnFlush(channel);
    }

    @Override
    public int getClientConnections() {
        return this.browserToProxyConnections.get();
    }

    @Override
    public int getTotalClientConnections() {
        return totalBrowserToProxyConnections.get();
    }

    @Override
    public int getOutgoingConnections() {
        return this.externalHostsToChannelFutures.size();
    }

    @Override
    public int getRequestsSent() {
        return this.requestsSent.get();
    }

    @Override
    public int getResponsesReceived() {
        return this.responsesReceived.get();
    }

    @Override
    public String getUnansweredRequests() {
        return this.unansweredRequests.toString();
    }

    @Override
    public String getAnsweredReqeusts() {
        return this.answeredRequests.toString();
    }
}

