/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.littleshoot.proxy.HttpRelayingHandler;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpRequestEncoder
extends HttpRequestEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHttpRequestEncoder.class);
    private final HttpRelayingHandler relayingHandler;
    private final HttpRequestFilter requestFilter;
    private final boolean keepProxyFormat;
    private final boolean transparent;

    public ProxyHttpRequestEncoder(HttpRelayingHandler handler) {
        this(handler, null, false, false);
    }

    public ProxyHttpRequestEncoder(HttpRelayingHandler handler, HttpRequestFilter requestFilter, boolean keepProxyFormat) {
        this(handler, requestFilter, keepProxyFormat, false);
    }

    public ProxyHttpRequestEncoder(HttpRelayingHandler handler, HttpRequestFilter requestFilter, boolean keepProxyFormat, boolean transparent) {
        this.relayingHandler = handler;
        this.requestFilter = requestFilter;
        this.keepProxyFormat = keepProxyFormat;
        this.transparent = transparent;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            this.relayingHandler.requestEncoded(request);
            HttpRequest toSend = this.transparent ? request : ProxyUtils.copyHttpRequest(request, this.keepProxyFormat);
            if (this.requestFilter != null) {
                this.requestFilter.filter(toSend);
            }
            return super.encode(ctx, channel, (Object)toSend);
        }
        return super.encode(ctx, channel, msg);
    }
}

