/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.HttpRequestFilter;

public class RegexHttpRequestFilter
implements HttpRequestFilter {
    private final HttpRequestFilter filter;
    private final boolean filterPaths;
    private final Pattern hostPattern;
    private final Pattern pathPattern;
    private final boolean filterHosts;

    public static RegexHttpRequestFilter newHostFilter(String hostRegex, HttpRequestFilter filter) {
        return new RegexHttpRequestFilter(hostRegex, "", filter);
    }

    public static RegexHttpRequestFilter newPathFilter(String pathRegex, HttpRequestFilter filter) {
        return new RegexHttpRequestFilter("", pathRegex, filter);
    }

    public static RegexHttpRequestFilter newHostAndPathFilter(String hostRegex, String pathRegex, HttpRequestFilter filter) {
        return new RegexHttpRequestFilter(hostRegex, pathRegex, filter);
    }

    private RegexHttpRequestFilter(String hostRegex, String pathRegex, HttpRequestFilter filter) {
        this.hostPattern = Pattern.compile(hostRegex);
        this.pathPattern = Pattern.compile(pathRegex);
        this.filterHosts = !StringUtils.isBlank((String)hostRegex);
        this.filterPaths = !StringUtils.isBlank((String)pathRegex);
        this.filter = filter;
    }

    @Override
    public void filter(HttpRequest httpRequest) {
        if (this.filterHosts) {
            String host;
            Matcher hostMatch;
            List hosts = httpRequest.getHeaders("Host");
            if (hosts != null && !hosts.isEmpty() && (hostMatch = this.hostPattern.matcher(host = (String)hosts.get(0))).find()) {
                if (this.filterPaths) {
                    this.filterPath(httpRequest);
                } else {
                    this.filter.filter(httpRequest);
                }
            }
        } else if (this.filterPaths) {
            this.filterPath(httpRequest);
        }
    }

    private void filterPath(HttpRequest httpRequest) {
        String path = httpRequest.getUri();
        Matcher pathMatch = this.pathPattern.matcher(path);
        if (pathMatch.matches()) {
            this.filter.filter(httpRequest);
        }
    }
}

