/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.KeyStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedKeyStoreManager
implements KeyStoreManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File KEYSTORE_FILE = new File("littleproxy_keystore.jks");
    private final String AL = "littleproxy";
    private static final String PASS = "Be Your Own Lantern";

    public SelfSignedKeyStoreManager() {
        this(true);
    }

    public SelfSignedKeyStoreManager(boolean regenerate) {
        this.resetStores();
    }

    private void resetStores() {
        if (this.KEYSTORE_FILE.isFile()) {
            this.log.info("Not deleting keystore");
            return;
        }
        this.nativeCall("keytool", "-genkey", "-alias", "littleproxy", "-keysize", "4096", "-validity", "36500", "-keyalg", "RSA", "-dname", "CN=littleproxy", "-keypass", PASS, "-storepass", PASS, "-keystore", this.KEYSTORE_FILE.getName());
        this.nativeCall("keytool", "-exportcert", "-alias", "littleproxy", "-keystore", this.KEYSTORE_FILE.getName(), "-storepass", PASS, "-file", "littleproxy_cert");
    }

    public String getBase64Cert() {
        return "";
    }

    @Override
    public InputStream keyStoreAsInputStream() {
        try {
            return new FileInputStream(this.KEYSTORE_FILE);
        }
        catch (FileNotFoundException e) {
            throw new Error("Could not find keystore file!!");
        }
    }

    @Override
    public InputStream trustStoreAsInputStream() {
        return null;
    }

    @Override
    public char[] getCertificatePassword() {
        return PASS.toCharArray();
    }

    @Override
    public char[] getKeyStorePassword() {
        return PASS.toCharArray();
    }

    @Override
    public void addBase64Cert(String alias, String base64Cert) {
    }

    private String nativeCall(String ... commands) {
        this.log.info("Running '{}'", Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            Process process = pb.start();
            InputStream is = process.getInputStream();
            String data = IOUtils.toString((InputStream)is);
            this.log.info("Completed native call: '{}'\nResponse: '" + data + "'", Arrays.asList(commands));
            return data;
        }
        catch (IOException e) {
            this.log.error("Error running commands: " + Arrays.asList(commands), (Throwable)e);
            return "";
        }
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return null;
    }
}

