/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.StructureException;

public enum SDMX_STRUCTURE_TYPE {
    ANY("Any"),
    ANNOTATION("Annotation"),
    CATEGORY_ID("Category ID"),
    DATASOURCE("DataSource"),
    TEXT_FORMAT("Text Format"),
    TEXT_TYPE("Text Type"),
    RELATED_STRUCTURES("Related Structures"),
    CODE_LIST_REF("CodelistRef"),
    COMPONENT("Component"),
    DATASET("DataSet"),
    ITEM_MAP("Item Map"),
    LOCAL_REPRESENTATION("Local Representation"),
    COMPUTATION("Computation"),
    INPUT_OUTPUT("Input/Output"),
    CONSTRAINED_DATA_KEY("Constrained Data Key"),
    CONSTRAINED_DATA_KEY_SET("Data Key Set"),
    ATTACHMENT_CONSTRAINT_ATTACHMENT("Attachment Constraint Attachment"),
    CONTENT_CONSTRAINT_ATTACHMENT("Content Constraint Attachment"),
    REFERENCE_PERIOD("Reference Period"),
    RELEASE_CALENDAR("Release Calendar"),
    TIME_RANGE("Time Range"),
    KEY_VALUES("Key Values"),
    CUBE_REGION("Cube Region"),
    ORGANISATION_SCHEME("Organisation Scheme"),
    METADATA_DOCUMENT("Metadata Document"),
    METADATA_SET("Metadata Set"),
    METADATA_REPORT("Metadata Report"),
    METADATA_REPORT_TARGET("Metadata Report Target"),
    METADATA_REFERENCE_VALUE("Metadata Reference Value"),
    METADATA_REPORT_ATTRIBUTE("Metadata Reported Attribute"),
    AGENCY_SCHEME("base", "AgencyScheme", "Agency Scheme"),
    AGENCY("base", "Agency", "Agency", AGENCY_SCHEME),
    DATA_PROVIDER_SCHEME("base", "DataProviderScheme", "Data Provider Scheme"),
    DATA_PROVIDER("base", "DataProvider", "Data Provider", DATA_PROVIDER_SCHEME),
    DATA_CONSUMER_SCHEME("base", "DataConsumerScheme", "Data Consumer Scheme"),
    DATA_CONSUMER("base", "DataConsumer", "Data Consumer", DATA_CONSUMER_SCHEME),
    ORGANISATION_UNIT_SCHEME("base", "OrganisationUnitScheme", "Organisation Unit Scheme"),
    ORGANISATION_UNIT("base", "OrganisationUnit", "Organisation Unit", ORGANISATION_UNIT_SCHEME),
    CODE_LIST("codelist", "CodeList", "codelist", "Codelist", "Codelist"),
    CODE("codelist", "Code", "Code", CODE_LIST),
    HIERARCHICAL_CODELIST("codelist", "HierarchicCodeList", "codelist", "HierarchicalCodelist", "Hierarchical Code List"),
    HIERARCHY("codelist", "Hierarchy", "Hierarchy", HIERARCHICAL_CODELIST),
    HIERARCHICAL_CODE("codelist", "HierarchicalCode", "Hierarchical Code", HIERARCHY),
    LEVEL("codelist", "Level", "Level", HIERARCHY),
    CATEGORISATION("categoryscheme", "Categorisation", "Categorisation"),
    CATEGORY_SCHEME("categoryscheme", "CategoryScheme", "Category Scheme"),
    CATEGORY("categoryscheme", "Category", "Category", CATEGORY_SCHEME),
    REPORTING_TAXONOMY("categoryscheme", "ReportingTaxonomy", "Reporting Taxonomy"),
    REPORTING_CATEGORY("categoryscheme", "ReportingCategory", "Reporting Category", REPORTING_TAXONOMY),
    CONCEPT_SCHEME("conceptscheme", "ConceptScheme", "Concept Scheme"),
    CONCEPT("conceptscheme", "Concept", "Concept", CONCEPT_SCHEME),
    DSD("keyfamily", "KeyFamily", "datastructure", "DataStructure", "Data Structure Definition"),
    DATA_ATTRIBUTE("datastructure", "DataAttribute", "Data Attribute", DSD),
    ATTRIBUTE_DESCRIPTOR("datastructure", "AttributeDescriptor", "Attribute Descriptor", DSD),
    DATAFLOW("keyfamily", "Dataflow", "datastructure", "Dataflow", "Dataflow"),
    DIMENSION("datastructure", "Dimension", "Dimension", DSD),
    GROUP("datastructure", "GroupDimensionDescriptor", "Group Dimension Descriptor", DSD),
    CROSS_SECTIONAL_MEASURE("datastructure", "CrossSectionalMeasure", "Cross Sectional Measure", DSD),
    DIMENSION_DESCRIPTOR("datastructure", "DimensionDescriptor", "Dimension Descriptor", DSD),
    MEASURE_DIMENSION("datastructure", "MeasureDimension", "Measure Dimension", DSD),
    MEASURE_DESCRIPTOR("datastructure", "MeasureDescriptor", "Measure Descriptor", DSD),
    PRIMARY_MEASURE("datastructure", "PrimaryMeasure", "Primary Measure", DSD),
    TIME_DIMENSION("datastructure", "TimeDimension", "Time Dimension", DSD),
    MSD("metadatastructure", "MetadataStructure", "Metadata Structure"),
    REPORT_STRUCTURE("metadatastructure", "ReportStructure", "Report Structure", MSD),
    METADATA_ATTRIBUTE("metadatastructure", "MetadataAttribute", "Metadata Attribute", REPORT_STRUCTURE),
    METADATA_TARGET("metadatastructure", "MetadataTarget", "Metadata Target", MSD),
    METADATA_FLOW("metadatastructure", "Metadataflow", "Metadataflow"),
    IDENTIFIABLE_OBJECT_TARGET("metadatastructure", "IdentifiableObjectTarget", "Identifiable Object Target", METADATA_TARGET),
    DATASET_TARGET("metadatastructure", "DataSetTarget", "Data Set Target", METADATA_TARGET),
    CONSTRAINT_CONTENT_TARGET("metadatastructure", "ConstraintContentTarget", "Constraint Content Set Target", METADATA_TARGET),
    DIMENSION_DESCRIPTOR_VALUES_TARGET("metadatastructure", "DimensionDescriptorValuesTarget", "Dimension Descriptor Values Target", METADATA_TARGET),
    REPORT_PERIOD_TARGET("metadatastructure", "ReportPeriodTarget", "Report Period Target", METADATA_TARGET),
    PROCESS("process", "Process", "Process"),
    PROCESS_STEP("process", "ProcessStep", "Process Step", PROCESS),
    TRANSITION("process", "Transition", "Transition", PROCESS_STEP),
    PROVISION_AGREEMENT("registry", "ProvisionAgreement", "Provision Agreement"),
    REGISTRATION("registry", "Registration", "Registration"),
    SUBSCRIPTION("registry", "Subscription", "Subscription"),
    ATTACHMENT_CONSTRAINT("registry", "AttachmentConstraint", "Attachment Constraint"),
    CONTENT_CONSTRAINT("registry", "ContentConstraint", "Content Constraint"),
    STRUCTURE_SET("mapping", "StructureSet", "Structure Set"),
    STRUCTURE_MAP("mapping", "StructureMap", "Structure Map", STRUCTURE_SET),
    REPORTING_TAXONOMY_MAP("mapping", "ReportingTaxonomyMap", "Reporting Taxonomy Map", STRUCTURE_SET),
    REPRESENTATION_MAP("mapping", "RepresentationMap", "Representation Map", STRUCTURE_SET, false),
    CATEGORY_MAP("mapping", "CategoryMap", "Category Map", STRUCTURE_SET, false),
    CATEGORY_SCHEME_MAP("mapping", "CategorySchemeMap", "Category Scheme Map", STRUCTURE_SET),
    CONCEPT_SCHEME_MAP("mapping", "ConceptSchemeMap", "Concept Scheme Map", STRUCTURE_SET),
    CODE_MAP("mapping", "CodeMap", "Code Map", STRUCTURE_SET),
    CODE_LIST_MAP("mapping", "CodelistMap", "CodelistMap", STRUCTURE_SET),
    COMPONENT_MAP("mapping", "ComponentMap", "Component Map", STRUCTURE_SET, false),
    CONCEPT_MAP("mapping", "ConceptMap", "Concept Map", STRUCTURE_SET),
    ORGANISATION_MAP("mapping", "OrganisationMap", "Organisation Map", STRUCTURE_SET),
    ORGANISATION_SCHEME_MAP("mapping", "OrganisationSchemeMap", "Organisation Scheme Map", STRUCTURE_SET),
    HYBRID_CODELIST_MAP("mapping", "HybridCodeListMap", "Hybrid Code List Map", STRUCTURE_SET),
    HYBRID_CODE("mapping", "HybridCodeMap", "Hybrid Code Map", STRUCTURE_SET);

    private String v2package;
    private String v2Class;
    private String v2UrnPrefix;
    private String urnPackage;
    private String urnClass;
    private String urnPrefix;
    private String type;
    private boolean isMaintainable;
    private boolean isIdentifiable;
    private SDMX_STRUCTURE_TYPE parentStructureType;
    private static List<SDMX_STRUCTURE_TYPE> maintainableTypes;

    private SDMX_STRUCTURE_TYPE(String type) {
        this.type = type;
    }

    public static List<SDMX_STRUCTURE_TYPE> getMaintainableStructureTypes() {
        return new ArrayList<SDMX_STRUCTURE_TYPE>(maintainableTypes);
    }

    private SDMX_STRUCTURE_TYPE(String v2package, String v2Class, String urnPackage, String urnClass, String type) {
        this(urnPackage, urnClass, type, null);
        this.v2Class = v2Class;
        this.v2package = v2package;
        this.v2UrnPrefix = "urn:sdmx:org.sdmx.infomodel." + v2package + "." + v2Class + "=";
    }

    private SDMX_STRUCTURE_TYPE(String urnPackage, String urnClass, String type) {
        this(urnPackage, urnClass, type, null);
    }

    private SDMX_STRUCTURE_TYPE(String urnPackage, String urnClass, String type, SDMX_STRUCTURE_TYPE parentStructureType, boolean isIdentifiable) {
        this.urnPackage = urnPackage;
        this.urnClass = urnClass;
        this.type = type;
        this.isMaintainable = parentStructureType == null;
        this.parentStructureType = parentStructureType;
        this.isIdentifiable = isIdentifiable;
        this.urnPrefix = "urn:sdmx:org.sdmx.infomodel." + urnPackage + "." + urnClass + "=";
    }

    private SDMX_STRUCTURE_TYPE(String urnPackage, String urnClass, String type, SDMX_STRUCTURE_TYPE parentStructureType) {
        this.urnPackage = urnPackage;
        this.urnClass = urnClass;
        this.type = type;
        this.isMaintainable = parentStructureType == null;
        this.parentStructureType = parentStructureType;
        this.isIdentifiable = true;
        this.urnPrefix = "urn:sdmx:org.sdmx.infomodel." + urnPackage + "." + urnClass + "=";
    }

    public String getUrnPrefix() {
        return this.urnPrefix;
    }

    public String generateUrn(String agencyId, String maintId, String version, String ... identifiableIds) {
        if (agencyId == null || agencyId.length() == 0) {
            throw new IllegalArgumentException("Generate URN missing agencyId");
        }
        if (maintId == null || maintId.length() == 0) {
            throw new IllegalArgumentException("Generate URN missing maintId");
        }
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        if (identifiableIds != null && identifiableIds.length > 0 && this.isMaintainable) {
            throw new IllegalArgumentException("Generate maintainable URN given too many args (given identifiable ids) ");
        }
        if (!(this.isMaintainable || identifiableIds != null && identifiableIds.length != 0)) {
            throw new IllegalArgumentException("Generate identifiable URN missing required identifiable id");
        }
        String returnString = this.getUrnPrefix() + agencyId + ":" + maintId + "(" + version + ")";
        if (identifiableIds != null) {
            for (String currentIdentId : identifiableIds) {
                returnString = returnString + "." + currentIdentId;
            }
        }
        return returnString;
    }

    public SDMX_STRUCTURE_TYPE getParentStructureType() {
        return this.parentStructureType;
    }

    public int getNestedDepth() {
        SDMX_STRUCTURE_TYPE currentParent = this.getParentStructureType();
        int i = 0;
        if (currentParent != null) {
            while (!currentParent.isMaintainable()) {
                ++i;
                currentParent = currentParent.getParentStructureType();
            }
        }
        return i;
    }

    public String getUrnClass() {
        return this.urnClass;
    }

    public String getUrnPackage() {
        return this.urnPackage;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMaintainable() {
        return this.isMaintainable;
    }

    public boolean isIdentifiable() {
        return this.isIdentifiable;
    }

    public String toString() {
        return this.type;
    }

    public static SDMX_STRUCTURE_TYPE parsePrefix(String prefix) {
        if (!prefix.endsWith("=")) {
            prefix = prefix + "=";
        }
        for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.values()) {
            if (currentType.getUrnPrefix() == null || !currentType.getUrnPrefix().equalsIgnoreCase(prefix)) continue;
            return currentType;
        }
        for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.values()) {
            if (currentType.v2UrnPrefix == null || !currentType.v2UrnPrefix.equalsIgnoreCase(prefix)) continue;
            return currentType;
        }
        throw new StructureException(ExceptionCode.STRUCTURE_URN_MALFORMED_UNKOWN_PREFIX, prefix);
    }

    public static SDMX_STRUCTURE_TYPE parseClass(String structureClass) {
        for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.values()) {
            if (!currentType.isIdentifiable) continue;
            if (currentType.getUrnClass().equalsIgnoreCase(structureClass)) {
                return currentType;
            }
            if (currentType.v2Class == null || !currentType.v2Class.equalsIgnoreCase(structureClass)) continue;
            return currentType;
        }
        throw new IllegalArgumentException("Could not find structure type with class '" + structureClass + "'");
    }

    public static SDMX_STRUCTURE_TYPE parsePackageAndClass(String structurePackage, String structureClass) {
        for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.values()) {
            if (!currentType.isIdentifiable) continue;
            if (currentType.getUrnClass().equals(structureClass) && currentType.getUrnPackage().equals(structurePackage)) {
                return currentType;
            }
            if (currentType.v2Class == null || currentType.v2package == null || !currentType.v2Class.equals(structureClass) || !currentType.v2package.equals(structurePackage)) continue;
            return currentType;
        }
        throw new IllegalArgumentException("Could not find structure type with package '" + structurePackage + "' and class '" + structureClass + "'");
    }

    static {
        maintainableTypes = new ArrayList<SDMX_STRUCTURE_TYPE>();
        for (SDMX_STRUCTURE_TYPE currentStructureType : SDMX_STRUCTURE_TYPE.values()) {
            if (!currentStructureType.isMaintainable) continue;
            maintainableTypes.add(currentStructureType);
        }
    }
}

