/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.exception;

import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BaseUncheckedException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;

public class MaintainableBeanException
extends BaseUncheckedException {
    private static final long serialVersionUID = -8099955589762191856L;
    private String agencyId;
    private String id;
    private String version;
    private SDMX_STRUCTURE_TYPE structureType;

    public MaintainableBeanException(Throwable th, SDMX_STRUCTURE_TYPE structureType, String agencyId, String id, String version) {
        super(th, "Error with maintainable artefact of type '" + structureType.getType() + "' and identifiers '" + MaintainableBeanException.getAgencyId(agencyId) + ":" + MaintainableBeanException.getId(id) + "(" + MaintainableBeanException.getVersion(version) + ")'");
        this.agencyId = agencyId;
        this.id = id;
        this.version = version;
        this.structureType = structureType;
    }

    private static String getAgencyId(String agencyId) {
        if (agencyId == null || agencyId.length() == 0) {
            return "agency missing";
        }
        return agencyId;
    }

    private static String getId(String id) {
        if (id == null || id.length() == 0) {
            return "id missing";
        }
        return id;
    }

    private static String getVersion(String version) {
        if (version == null || version.length() == 0) {
            return "1.0";
        }
        return version;
    }

    @Override
    public SDMX_ERROR_CODE getSdmxErrorCode() {
        return SDMX_ERROR_CODE.INTERNAL_SERVER_ERRROR;
    }

    public MaintainableBeanException(Throwable th, MaintainableBean maintainableBean) {
        this(th, maintainableBean.getStructureType(), maintainableBean.getAgencyId(), maintainableBean.getId(), maintainableBean.getVersion());
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public SDMX_STRUCTURE_TYPE getStructureType() {
        return this.structureType;
    }

    @Override
    public String getErrorType() {
        return "Maintainable Bean Exception";
    }
}

