/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.DataValidationEngine;
import org.sdmxsource.util.ObjectUtil;

public abstract class AbstractDataValidationEngine
implements DataValidationEngine {
    private DataReaderEngine dataReaderEngine;
    private DataStructureBean dsd;
    protected Map<String, AttributeBean> seriesAttributes = new HashMap<String, AttributeBean>();
    protected Map<String, AttributeBean> obsAttributes = new HashMap<String, AttributeBean>();
    protected Map<String, DimensionBean> dimensionMap = new HashMap<String, DimensionBean>();
    int dimSize = 0;
    protected boolean isTimeSeries;
    protected String dimensionAtObservation;

    public AbstractDataValidationEngine(DataReaderEngine dataReaderEngine) {
        if (dataReaderEngine == null) {
            throw new IllegalArgumentException("AbstractDataValidationEngine can not be constructucted: DataReaderEngine can not be null");
        }
        this.dataReaderEngine = dataReaderEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateData() {
        this.dataReaderEngine.reset();
        try {
            while (this.dataReaderEngine.moveNextDataset()) {
                this.processDataset(this.dataReaderEngine);
                while (this.dataReaderEngine.moveNextKeyable()) {
                    Keyable key = this.dataReaderEngine.getCurrentKey();
                    if (key.isSeries()) {
                        this.validateSeriesKey(key);
                    } else {
                        GroupBean group = this.dsd.getGroup(key.getGroupName());
                        if (group == null) {
                            throw new ValidationException("Data Structure Definition does not contain group: " + key.getGroupName());
                        }
                        for (KeyValue kv : key.getKey()) {
                            if (group.getDimensionRefs().contains(kv.getConcept())) continue;
                            throw new ValidationException("DSD group key component not found : " + kv.getConcept());
                        }
                    }
                    while (this.dataReaderEngine.moveNextObservation()) {
                        Observation obs = this.dataReaderEngine.getCurrentObservation();
                        try {
                            this.validateObservation(obs);
                        }
                        catch (ValidationException e) {
                            throw new ValidationException(e, "Validation error while processing series : " + key);
                        }
                    }
                }
                continue;
                return;
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(e, "Error while validating dataset");
        }
    }

    protected void processDataset(DataReaderEngine dre) {
        this.setDsd(dre.getDataStructure());
        this.dimSize = 0;
        for (DimensionBean dimension : this.dsd.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
            this.dimensionMap.put(dimension.getId(), dimension);
            ++this.dimSize;
        }
        this.isTimeSeries = this.dataReaderEngine.getCurrentDatasetHeaderBean().isTimeSeries();
        this.dimensionAtObservation = "TIME_PERIOD";
        if (this.dataReaderEngine.getCurrentDatasetHeaderBean().getDataStructureReference() != null) {
            this.dimensionAtObservation = this.dataReaderEngine.getCurrentDatasetHeaderBean().getDataStructureReference().getDimensionAtObservation();
        }
        for (AttributeBean att : this.dsd.getDimensionGroupAttributes()) {
            if (!this.isTimeSeries && att.getDimensionReferences().contains(this.dimensionAtObservation)) {
                this.obsAttributes.put(att.getId(), att);
                continue;
            }
            this.seriesAttributes.put(att.getId(), att);
        }
        for (AttributeBean att : this.dsd.getObservationAttributes()) {
            this.obsAttributes.put(att.getId(), att);
        }
        if (!this.isTimeSeries) {
            --this.dimSize;
        }
    }

    protected void setDsd(DataStructureBean dsd) {
        this.dsd = dsd;
    }

    protected abstract void validateSeriesKey(Keyable var1);

    protected void validateObservation(Observation obs) {
        if (this.isTimeSeries && !ObjectUtil.validString(obs.getObsTime())) {
            throw new ValidationException("Observation missing time dimension for time series data");
        }
    }
}

