/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.dataparser.engine.impl.AbstractDataValidationEngine;
import org.sdmxsource.util.ObjectUtil;

public class DeepDataValidationEngine
extends AbstractDataValidationEngine {
    private SdmxSuperBeanRetrievalManager superBeanRetrievalManager;
    private DataStructureSuperBean dsdSuperBean;
    private Map<String, AttributeSuperBean> seriesAttributes = new HashMap<String, AttributeSuperBean>();
    private Map<String, AttributeSuperBean> obsAttributes = new HashMap<String, AttributeSuperBean>();
    private Map<String, DimensionSuperBean> dimensionMap = new HashMap<String, DimensionSuperBean>();

    public DeepDataValidationEngine(DataReaderEngine dataReaderEngine, SdmxSuperBeanRetrievalManager superBeanRetrievalManager) {
        super(dataReaderEngine);
        this.superBeanRetrievalManager = superBeanRetrievalManager;
    }

    @Override
    protected void setDsd(DataStructureBean dsd) {
        super.setDsd(dsd);
        this.dsdSuperBean = this.superBeanRetrievalManager.getDataStructureSuperBean(dsd.asReference().getMaintainableReference());
        for (DimensionSuperBean dimension : this.dsdSuperBean.getDimensions()) {
            if (dimension.isMeasureDimension() || dimension.isTimeDimension()) continue;
            this.dimensionMap.put(dimension.getId(), dimension);
            ++this.dimSize;
        }
        for (AttributeSuperBean att : this.dsdSuperBean.getSeriesAttributes()) {
            if (!this.isTimeSeries && att.getDimensionReferences().contains(this.dimensionAtObservation)) {
                this.obsAttributes.put(att.getId(), att);
                continue;
            }
            this.seriesAttributes.put(att.getId(), att);
        }
        for (AttributeSuperBean att : this.dsdSuperBean.getObservationAttributes()) {
            this.obsAttributes.put(att.getId(), att);
        }
    }

    @Override
    protected void validateObservation(Observation obs) {
        super.validateObservation(obs);
        this.validateTextFormat(this.dsdSuperBean.getPrimaryMeasure().getTextFormat(), obs.getObservationValue());
        for (KeyValue kv : obs.getAttributes()) {
            AttributeSuperBean attribute = this.obsAttributes.get(kv.getConcept());
            if (attribute == null) {
                throw new ValidationException("DSD observation attribute not found : " + kv.getConcept());
            }
            if (!attribute.isMandatory() && !ObjectUtil.validString(kv.getCode())) continue;
            this.validateComponent(kv, attribute);
        }
    }

    @Override
    protected void validateSeriesKey(Keyable keyable) {
        try {
            if (keyable.getKey().size() != this.dimSize) {
                throw new ValidationException("Dataset key unexpected size.  Got '" + keyable.getKey().size() + "', expected '" + this.dimSize + "' ");
            }
            for (KeyValue kv : keyable.getKey()) {
                DimensionSuperBean dimension = this.dimensionMap.get(kv.getConcept());
                if (dimension == null) {
                    throw new ValidationException("DSD series key component not found : " + kv.getConcept());
                }
                this.validateComponent(kv, dimension);
            }
            for (KeyValue kv : keyable.getAttributes()) {
                AttributeSuperBean attribute = this.seriesAttributes.get(kv.getConcept());
                if (attribute == null) {
                    throw new ValidationException("DSD series attribute not found : " + kv.getConcept());
                }
                this.validateComponent(kv, attribute);
            }
        }
        catch (ValidationException e) {
            if (keyable.isSeries()) {
                throw new ValidationException(e, "Error while processing series key: " + keyable.toString());
            }
            throw new ValidationException(e, "Error while processing group key: " + keyable.toString());
        }
    }

    private void validateComponent(KeyValue kv, ComponentSuperBean component) {
        if (component.getTextFormat() != null) {
            this.validateTextFormat(component.getTextFormat(), kv.getCode());
        }
        this.validateCode(kv, component);
    }

    private void validateTextFormat(TextFormatBean textFormat, String value) {
        switch (textFormat.getTextType()) {
            case DOUBLE: {
                try {
                    Double.parseDouble(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Value '" + value + "' is not of expected type 'Double'");
                }
            }
        }
    }

    private void validateCode(KeyValue kv, ComponentSuperBean component) {
        CodelistSuperBean codelist = component.getCodelist(true);
        if (codelist != null) {
            if (!ObjectUtil.validString(kv.getCode())) {
                throw new ValidationException("No value reported for concept : " + kv.getConcept());
            }
            CodeSuperBean code = codelist.getCodeByValue(kv.getCode());
            if (code == null) {
                throw new ValidationException("No code '" + kv.getCode() + "' found in codelist : " + codelist.getUrn());
            }
        }
    }
}

