/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.impl.AbstractDataValidationEngine;

public class SimpleDataValidationEngine
extends AbstractDataValidationEngine {
    public SimpleDataValidationEngine(DataReaderEngine dataReaderEngine) {
        super(dataReaderEngine);
    }

    @Override
    protected void validateSeriesKey(Keyable keyable) {
        try {
            if (keyable.getKey().size() != this.dimSize) {
                throw new ValidationException("Dataset key unexpected size.  Got '" + keyable.getKey().size() + "', expected '" + this.dimSize + "' ");
            }
            for (KeyValue kv : keyable.getKey()) {
                DimensionBean dimension = (DimensionBean)this.dimensionMap.get(kv.getConcept());
                if (dimension != null) continue;
                throw new ValidationException("DSD series key component not found : " + kv.getConcept());
            }
            for (KeyValue kv : keyable.getAttributes()) {
                AttributeBean attribute = (AttributeBean)this.seriesAttributes.get(kv.getConcept());
                if (attribute != null) continue;
                throw new ValidationException("DSD series attribute not found : " + kv.getConcept());
            }
        }
        catch (ValidationException e) {
            if (keyable.isSeries()) {
                throw new ValidationException(e, "Error while processing series key: " + keyable.toString());
            }
            throw new ValidationException(e, "Error while processing group key: " + keyable.toString());
        }
    }

    @Override
    protected void validateObservation(Observation obs) {
        super.validateObservation(obs);
        for (KeyValue kv : obs.getAttributes()) {
            AttributeBean attribute = (AttributeBean)this.obsAttributes.get(kv.getConcept());
            if (attribute != null) continue;
            throw new ValidationException("DSD observation attribute not found : " + kv.getConcept());
        }
    }
}

