/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.io.OutputStream;
import java.io.Serializable;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.util.io.StreamUtil;

public abstract class AbstractDataReaderEngine
implements DataReaderEngine,
Serializable {
    protected ReadableDataLocation dataLocation;
    private int datasetIndex = -1;
    private int keyableIndex = -1;
    private int obsIndex = -1;
    protected boolean hasNext = true;
    protected boolean hasNextObs = true;
    protected boolean hasNextDataset = true;
    protected DatasetHeaderBean datasetHeaderBean;
    protected DataStructureBean currentDsd;
    protected DataStructureBean defaultDsd;
    protected SdmxBeanRetrievalManager beanRetrieval;
    protected Observation currentObs;
    protected Keyable currentKey;
    protected HeaderBean headerBean;
    protected DATASET_POSITION datasetPosition;

    public AbstractDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean defaultDsd) {
        this.dataLocation = dataLocation;
        this.beanRetrieval = beanRetrieval;
        this.defaultDsd = defaultDsd;
        if (beanRetrieval == null && defaultDsd == null) {
            throw new IllegalArgumentException("AbstractDataReaderEngine expects either a SdmxBeanRetrievalManager or a DataStructureBean to be able to interpret the structures");
        }
    }

    @Override
    public void copyToOutputStream(OutputStream outputStream) {
        StreamUtil.copyStream(this.dataLocation.getInputStream(), outputStream);
    }

    @Override
    public HeaderBean getHeader() {
        return this.headerBean;
    }

    @Override
    public int getDatasetPosition() {
        return this.datasetIndex;
    }

    @Override
    public DatasetHeaderBean getCurrentDatasetHeaderBean() {
        return this.datasetHeaderBean;
    }

    @Override
    public boolean moveNextDataset() {
        this.currentKey = null;
        this.hasNextObs = true;
        this.obsIndex = -1;
        this.keyableIndex = -1;
        boolean moveSuccessful = this.moveNextDatasetInternal();
        if (moveSuccessful) {
            ++this.datasetIndex;
            this.determineCurrentDataStructure();
        }
        return moveSuccessful;
    }

    @Override
    public DataStructureBean getDataStructure() {
        return this.currentDsd;
    }

    protected void setCurrentDsd(DataStructureBean currentDsd) {
        this.currentDsd = currentDsd;
        if (this.datasetHeaderBean.getDataStructureReference() == null) {
            DatasetStructureReferenceBeanImpl dsRefBean = new DatasetStructureReferenceBeanImpl(currentDsd.asReference());
            this.datasetHeaderBean = this.datasetHeaderBean.modifyDataStructureReference(dsRefBean);
        }
    }

    private void setCurrentDsd(MaintainableRefBean dsdRef) {
        DataStructureBean dsd = this.beanRetrieval.getDataStructure(dsdRef);
        if (dsd == null) {
            throw new RuntimeException("Can not read dataset, the data set references the DSD '" + dsdRef + "' which could not be resolved");
        }
        this.setCurrentDsd(dsd);
    }

    private void determineCurrentDataStructure() {
        this.currentDsd = null;
        DatasetStructureReferenceBean dsStructRef = this.datasetHeaderBean.getDataStructureReference();
        if (dsStructRef == null && this.headerBean != null && this.headerBean.getStructures().size() == 1) {
            dsStructRef = this.headerBean.getStructures().get(0);
        }
        if (dsStructRef != null) {
            StructureReferenceBean sRef = dsStructRef.getStructureReference();
            switch (sRef.getTargetReference()) {
                case DSD: {
                    if (this.defaultDsd != null && sRef.isMatch(this.defaultDsd)) {
                        this.setCurrentDsd(this.defaultDsd);
                        break;
                    }
                    if (this.beanRetrieval == null) break;
                    this.setCurrentDsd(sRef.getMaintainableReference());
                    break;
                }
                case DATAFLOW: {
                    if (this.beanRetrieval == null) break;
                    DataflowBean flow = this.beanRetrieval.getDataflow(sRef.getMaintainableReference());
                    if (flow == null) {
                        throw new RuntimeException("Could not read dataset, the data set references dataflow '" + sRef.getMaintainableUrn() + "' which could not be resolved");
                    }
                    this.setCurrentDsd(flow.getDataStructureRef().getMaintainableReference());
                    break;
                }
                case PROVISION_AGREEMENT: {
                    if (this.beanRetrieval == null) break;
                    ProvisionAgreementBean provision = this.beanRetrieval.getProvisionAgreementBean(sRef.getMaintainableReference());
                    if (provision == null) {
                        throw new RuntimeException("Could not read dataset, the data set references provision '" + sRef.getMaintainableUrn() + "' which could not be resolved");
                    }
                    DataflowBean flow = this.beanRetrieval.getDataflow(provision.getStructureUseage().getMaintainableReference());
                    if (flow == null) {
                        throw new RuntimeException("Could not read dataset, the data set references dataflow '" + sRef.getMaintainableUrn() + "' which could not be resolved");
                    }
                    this.setCurrentDsd(flow.getDataStructureRef().getMaintainableReference());
                }
            }
            if (this.currentDsd == null) {
                throw new RuntimeException("Can not read dataset, the data set references the DSD '" + sRef.getMaintainableReference().getMaintainableId() + "' which could not be resolved");
            }
        } else {
            if (this.defaultDsd == null) {
                throw new RuntimeException("Can not read dataset, the data set does no reference any data structures, and there was no default data structure definition provided");
            }
            this.setCurrentDsd(this.defaultDsd);
        }
    }

    @Override
    public final boolean moveNextKeyable() {
        if (this.datasetIndex == -1) {
            this.moveNextDataset();
        }
        this.currentKey = null;
        if (!this.hasNext) {
            return false;
        }
        this.hasNextObs = true;
        this.obsIndex = -1;
        ++this.keyableIndex;
        return this.moveNextKeyableInternal();
    }

    @Override
    public final boolean moveNextObservation() {
        this.currentObs = null;
        if (!this.hasNext && !this.hasNextObs) {
            return false;
        }
        ++this.obsIndex;
        this.hasNextObs = this.moveNextObservationInternal();
        return this.hasNextObs;
    }

    @Override
    public final Observation getCurrentObservation() {
        if (this.currentObs != null) {
            return this.currentObs;
        }
        if (this.obsIndex < 0) {
            return null;
        }
        this.currentObs = this.lazyLoadObservation();
        return this.currentObs;
    }

    @Override
    public final Keyable getCurrentKey() {
        if (this.currentKey != null) {
            return this.currentKey;
        }
        if (this.keyableIndex < 0) {
            return null;
        }
        this.currentKey = this.lazyLoadKey();
        return this.currentKey;
    }

    protected abstract Observation lazyLoadObservation();

    protected abstract Keyable lazyLoadKey();

    protected abstract boolean moveNextDatasetInternal();

    protected abstract boolean moveNextKeyableInternal();

    protected abstract boolean moveNextObservationInternal();

    @Override
    public int getKeyablePosition() {
        return this.keyableIndex;
    }

    @Override
    public int getObsPosition() {
        return this.obsIndex;
    }

    public boolean isTimeSeries() {
        return this.getCrossSectionConcept().equals("TIME_PERIOD") || this.getCrossSectionConcept().equals("AllDimensions");
    }

    public String getCrossSectionConcept() {
        if (this.datasetHeaderBean == null) {
            return "TIME_PERIOD";
        }
        return this.datasetHeaderBean.getDataStructureReference().getDimensionAtObservation();
    }

    @Override
    public void reset() {
        this.hasNext = true;
        this.keyableIndex = -1;
        this.obsIndex = -1;
        this.currentObs = null;
        this.currentKey = null;
    }
}

