/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.reader.AbstractSdmxDataReaderEngine;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.stax.StaxUtil;

public class CompactDataReaderEngine
extends AbstractSdmxDataReaderEngine {
    private Map<String, String> rolledUpAttributes = new HashMap<String, String>();
    private Map<String, String> keyValues = new HashMap<String, String>();
    private Map<String, String> attributeValues = new HashMap<String, String>();
    private List<String> groups = new ArrayList<String>();
    private List<String> dimensionConcepts = new ArrayList<String>();
    private Map<String, List<String>> groupConcepts = new HashMap<String, List<String>>();
    private String primaryMeasureConcept;
    private String timeConcept;
    private Set<String> datasetAttributes = new HashSet<String>();
    private Set<String> seriesAttributes = new HashSet<String>();
    private Set<String> observationAttributes = new HashSet<String>();
    private Map<String, Set<String>> groupAttributeConcepts = new HashMap<String, Set<String>>();
    private Map<String, String> attributesOnDatasetNode = new HashMap<String, String>();

    public CompactDataReaderEngine(ReadableDataLocation dataLocation, DataStructureBean dataStructureBean) {
        this(dataLocation, null, dataStructureBean);
    }

    public CompactDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean dataStructureBean) {
        super(dataLocation, beanRetrieval, dataStructureBean);
        this.reset();
    }

    @Override
    public DataReaderEngine createCopy() {
        return new CompactDataReaderEngine(this.dataLocation, this.beanRetrieval, this.defaultDsd);
    }

    private void populateGroupConcepts(GroupBean groupBean, List<String> groups) {
        for (String dimensionId : groupBean.getDimensionRefs()) {
            groups.add(this.getComponentId(this.currentDsd.getDimension(dimensionId)));
        }
    }

    private String getComponentId(ComponentBean component) {
        if (component == null) {
            return null;
        }
        if (this.isTwoPointOne) {
            return component.getId();
        }
        return ConceptRefUtil.getConceptId(component.getConceptRef());
    }

    @Override
    protected boolean next(boolean includeObs) throws XMLStreamException {
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("DataSet")) {
                    this.datasetPosition = DATASET_POSITION.DATASET;
                    this.processDataSetNode();
                    return true;
                }
                if (nodeName.equals("Series")) {
                    StaxUtil.jumpToNode(this.runAheadParser, "Series", null);
                    this.datasetPosition = DATASET_POSITION.SERIES;
                    return true;
                }
                if (!this.isTwoPointOne && this.groups.contains(nodeName)) {
                    this.datasetPosition = DATASET_POSITION.GROUP;
                    this.groupId = nodeName;
                    return true;
                }
                if (this.isTwoPointOne && nodeName.equals("Group")) {
                    this.datasetPosition = DATASET_POSITION.GROUP;
                    this.groupId = this.parser.getAttributeValue("xsi", "type");
                    return true;
                }
                if (!nodeName.equals("Obs")) continue;
                if ((this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.OBSERVATION) && includeObs) {
                    this.datasetPosition = DATASET_POSITION.OBSERVATION;
                    return true;
                }
                if (this.datasetPosition != null && this.datasetPosition != DATASET_POSITION.OBSERAVTION_AS_SERIES) continue;
                this.datasetPosition = DATASET_POSITION.OBSERAVTION_AS_SERIES;
                return true;
            }
            if (event != 2) continue;
            nodeName = this.parser.getLocalName();
            if (nodeName.equals("Series")) {
                this.datasetPosition = null;
                continue;
            }
            if (this.groups.contains(nodeName)) {
                this.datasetPosition = null;
                continue;
            }
            if (!nodeName.equals("Group")) continue;
            this.datasetPosition = null;
        }
        this.datasetPosition = null;
        this.hasNext = false;
        return false;
    }

    private void processDataSetNode() {
        this.rolledUpAttributes = new HashMap<String, String>();
        this.keyValues = new HashMap<String, String>();
        this.attributeValues = new HashMap<String, String>();
        this.attributesOnDatasetNode = new HashMap<String, String>();
        this.datasetHeaderBean = new DatasetHeaderBeanImpl(this.parser, this.headerBean);
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeName = this.parser.getAttributeLocalName(i);
            this.attributesOnDatasetNode.put(attributeName, this.parser.getAttributeValue(i));
        }
    }

    private void setDimensionAtObservation(String dimensionAtObservation) {
        this.observationAttributes = new HashSet<String>();
        this.seriesAttributes = new HashSet<String>();
        for (AttributeBean attributeBean : this.currentDsd.getSeriesAttributes(dimensionAtObservation)) {
            this.seriesAttributes.add(this.getComponentId(attributeBean));
        }
        for (AttributeBean attributeBean : this.currentDsd.getObservationAttributes(dimensionAtObservation)) {
            this.observationAttributes.add(this.getComponentId(attributeBean));
        }
    }

    @Override
    public List<KeyValue> getDatasetAttributes() {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        for (AttributeBean attr : this.currentDsd.getDatasetAttributes()) {
            String attributeValue = this.attributesOnDatasetNode.get(attr.getId());
            if (attributeValue == null) continue;
            returnList.add(new KeyValueImpl(attributeValue, attr.getId()));
        }
        return returnList;
    }

    @Override
    protected void setCurrentDsd(DataStructureBean dsd) {
        super.setCurrentDsd(dsd);
        this.dimensionConcepts = new ArrayList<String>();
        this.datasetAttributes = new HashSet<String>();
        this.seriesAttributes = new HashSet<String>();
        this.observationAttributes = new HashSet<String>();
        this.groups = new ArrayList<String>();
        this.groupConcepts = new HashMap<String, List<String>>();
        if (this.datasetHeaderBean.getDataStructureReference() != null) {
            this.setDimensionAtObservation(this.datasetHeaderBean.getDataStructureReference().getDimensionAtObservation());
        } else {
            this.setDimensionAtObservation("TIME_PERIOD");
        }
        for (String attributeName : this.attributesOnDatasetNode.keySet()) {
            ComponentBean component = dsd.getComponent(attributeName);
            if (component == null) continue;
            this.rolledUpAttributes.put(attributeName, this.attributesOnDatasetNode.get(attributeName));
        }
        for (DimensionBean dimensionBean : dsd.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
            this.dimensionConcepts.add(this.getComponentId(dimensionBean));
        }
        for (AttributeBean attributeBean : dsd.getDatasetAttributes()) {
            this.datasetAttributes.add(this.getComponentId(attributeBean));
        }
        for (AttributeBean attributeBean : dsd.getDimensionGroupAttributes()) {
            this.seriesAttributes.add(this.getComponentId(attributeBean));
        }
        for (AttributeBean attributeBean : dsd.getObservationAttributes()) {
            this.observationAttributes.add(this.getComponentId(attributeBean));
        }
        this.primaryMeasureConcept = this.getComponentId(dsd.getPrimaryMeasure());
        this.timeConcept = this.getComponentId(dsd.getTimeDimension());
        for (GroupBean groupBean : dsd.getGroups()) {
            String groupId = groupBean.getId();
            this.groups.add(groupId);
            HashSet<String> groupAttributes = new HashSet<String>();
            for (AttributeBean attributeBean : dsd.getGroupAttributes(groupId)) {
                groupAttributes.add(this.getComponentId(attributeBean));
            }
            this.groupAttributeConcepts.put(groupId, groupAttributes);
            ArrayList<String> groups = new ArrayList<String>();
            this.populateGroupConcepts(groupBean, groups);
            this.groupConcepts.put(groupId, groups);
        }
    }

    @Override
    protected Keyable processSeriesNode() {
        this.keyValues.clear();
        this.attributeValues.clear();
        TIME_FORMAT timeFormat = null;
        String timeValue = null;
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeName = this.parser.getAttributeLocalName(i);
            String attributeValue = this.parser.getAttributeValue(i);
            if (attributeName.equals(this.timeConcept)) {
                timeValue = attributeValue;
                timeFormat = DateUtil.getTimeFormatOfDate(timeValue);
                continue;
            }
            if (this.dimensionConcepts.contains(attributeName)) {
                this.keyValues.put(attributeName, attributeValue);
                continue;
            }
            if (this.seriesAttributes.contains(attributeName)) {
                this.attributeValues.put(attributeName, attributeValue);
                continue;
            }
            if (this.datasetPosition != DATASET_POSITION.OBSERAVTION_AS_SERIES || this.observationAttributes.contains(attributeName) || attributeName.equals(this.primaryMeasureConcept) || attributeName.equals(this.timeConcept)) continue;
            throw new ValidationException("Unknown concept reported at series : " + attributeName);
        }
        ArrayList<KeyValue> key = new ArrayList<KeyValue>();
        for (String dimensionConcept : this.dimensionConcepts) {
            String conceptValue = null;
            conceptValue = this.keyValues.containsKey(dimensionConcept) ? this.keyValues.get(dimensionConcept) : this.rolledUpAttributes.get(dimensionConcept);
            if (conceptValue == null && this.datasetHeaderBean.getAction() != DATASET_ACTION.DELETE) {
                if (!this.isTimeSeries() && this.getCrossSectionConcept().equals(dimensionConcept)) continue;
                throw new IllegalArgumentException("Missing series key value for concept: " + dimensionConcept);
            }
            KeyValueImpl kv = new KeyValueImpl(conceptValue, dimensionConcept);
            key.add(kv);
        }
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        try {
            this.processAttributes(this.seriesAttributes, attributes);
        }
        catch (ValidationException e) {
            throw new ValidationException(e, "Error while procesing series attributes");
        }
        this.keyValues.clear();
        this.attributeValues.clear();
        if (this.isTimeSeries()) {
            if (this.datasetPosition == DATASET_POSITION.SERIES) {
                try {
                    while (this.runAheadParser.hasNext()) {
                        int event = this.runAheadParser.next();
                        if (event == 1) {
                            if (!this.runAheadParser.getLocalName().equals("Obs")) continue;
                            Observation obs = this.processObsNode(this.runAheadParser);
                            timeFormat = obs.getObsTimeFormat();
                        }
                        if (event != 2 || !this.runAheadParser.getLocalName().equals("Series")) continue;
                    }
                }
                catch (XMLStreamException ex) {
                    throw new RuntimeException(ex);
                }
            } else if (this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
                this.currentObs = this.processObsNode(this.parser);
                timeFormat = this.currentObs.getObsTimeFormat();
            }
        }
        this.currentKey = this.isTimeSeries() ? new KeyableImpl(key, attributes, timeFormat) : new KeyableImpl(key, attributes, timeFormat, this.getCrossSectionConcept(), timeValue);
        return this.currentKey;
    }

    @Override
    protected Keyable processGroupNode() {
        this.keyValues.clear();
        this.attributeValues.clear();
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeName = this.parser.getAttributeLocalName(i);
            String attributeValue = this.parser.getAttributeValue(i);
            String namespace = this.parser.getAttributePrefix(i);
            if (namespace != null && namespace.equals("xsi") && attributeName.equals("type")) {
                if (attributeValue.contains(":")) {
                    this.groupId = attributeValue.split(":")[1];
                    continue;
                }
                this.groupId = attributeValue;
                continue;
            }
            if (this.dimensionConcepts.contains(attributeName)) {
                this.keyValues.put(attributeName, attributeValue);
                continue;
            }
            this.attributeValues.put(attributeName, attributeValue);
        }
        ArrayList<KeyValue> key = new ArrayList<KeyValue>();
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        if (!this.groupConcepts.containsKey(this.groupId)) {
            throw new ValidationException("Data Structure '" + this.currentDsd + "' does not contain group '" + this.groupId + "'");
        }
        for (String groupConcept : this.groupConcepts.get(this.groupId)) {
            String conceptValue = null;
            conceptValue = this.keyValues.containsKey(groupConcept) ? this.keyValues.get(groupConcept) : this.rolledUpAttributes.get(groupConcept);
            if (conceptValue == null) {
                throw new IllegalArgumentException("No value found in data for group '" + this.groupId + "' and concept '" + groupConcept + "'.  ");
            }
            KeyValueImpl kv = new KeyValueImpl(conceptValue, groupConcept);
            key.add(kv);
        }
        try {
            this.processAttributes(this.groupAttributeConcepts.get(this.groupId), attributes);
        }
        catch (ValidationException e) {
            throw new ValidationException(e, "Error while procesing group attributes for group '" + this.groupId + "' ");
        }
        this.keyValues.clear();
        this.attributeValues.clear();
        this.currentKey = new KeyableImpl(key, attributes, this.groupId);
        return this.currentKey;
    }

    @Override
    protected Observation processObsNode(XMLStreamReader parser) {
        this.attributeValues.clear();
        String obsTime = null;
        String obsValue = null;
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        KeyValueImpl crossSection = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeLocalName(i);
            String attributeValue = parser.getAttributeValue(i);
            if (!this.isTimeSeries() && attributeName.equals(this.getCrossSectionConcept())) {
                crossSection = new KeyValueImpl(attributeValue, attributeName);
                continue;
            }
            if (this.observationAttributes.contains(attributeName)) {
                this.attributeValues.put(attributeName, attributeValue);
                continue;
            }
            if (attributeName.equals(this.primaryMeasureConcept)) {
                obsValue = attributeValue;
                continue;
            }
            if (!attributeName.equals(this.timeConcept)) continue;
            obsTime = attributeValue;
        }
        try {
            this.processAttributes(this.observationAttributes, attributes);
        }
        catch (ValidationException e) {
            throw new ValidationException(e, "Error while procesing observation attributes");
        }
        this.attributeValues.clear();
        try {
            if (this.isTimeSeries()) {
                return new ObservationImpl(obsTime, obsValue, attributes);
            }
            if (crossSection == null) {
                throw new ValidationException("Error while processing observation for series '" + this.currentKey + "' , missing required concept '" + this.getCrossSectionConcept() + "'");
            }
            return new ObservationImpl(this.currentKey.getObsTime(), obsValue, attributes, crossSection);
        }
        catch (Throwable th) {
            if (this.currentKey != null) {
                throw new ValidationException("Error while processing observation for key " + this.currentKey);
            }
            throw new ValidationException("Error while processing observation");
        }
    }

    private void processAttributes(Set<String> attributeConcepts, List<KeyValue> attributes) {
        for (String attributeConcept : attributeConcepts) {
            String conceptValue = null;
            conceptValue = this.attributeValues.containsKey(attributeConcept) ? this.attributeValues.get(attributeConcept) : this.rolledUpAttributes.get(attributeConcept);
            if (conceptValue == null) continue;
            KeyValueImpl kv = new KeyValueImpl(conceptValue, attributeConcept);
            attributes.add(kv);
        }
        if (this.attributeValues.keySet().size() != attributes.size()) {
            for (String attribute : this.attributeValues.keySet()) {
                if (attributeConcepts.contains(attribute)) continue;
                throw new ValidationException("Unknown attribute '" + attribute + "' reported in the data.  This attribute is not defined by the data structure definition");
            }
        }
    }

    public static enum MOVE_TO {
        SERIES,
        GROUP,
        KEYABLE;

    }
}

