/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.stax.StaxUtil;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.io.WriteableDataLocationTmp;

public abstract class AbstractDataWriterEngine
implements DataWriterEngine {
    protected boolean isClosed = false;
    protected String PREFIX_GENERIC = "generic";
    protected String PREFIX_MESSAGE = "message";
    protected String PREFIX_COMMON = "common";
    protected String PREFIX_COMPACT = "ns";
    protected static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    protected static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    protected Namespace GENERIC_NS;
    private Namespace MESSAGE_NS;
    private Namespace COMMON_NS;
    protected Namespace COMPACT_NS;
    protected boolean headerWritten = false;
    protected SDMX_SCHEMA schemaVersion;
    protected String crossSectionConcept;
    protected boolean isCrossSectional;
    private BASE_DATA_FORMAT dataFormat;
    protected XMLStreamWriter writer = null;
    protected XMLStreamWriter seriesWriter = null;
    private OutputStream seriesOut;
    private OutputStream out;
    private OutputStream finalOutputStream;
    protected List<String> conceptIds;
    protected List<String> currentGroupConceptIds;
    POSITION currentPosition;
    private List<DataSetOutputStreams> outputDatasetLocations = new ArrayList<DataSetOutputStreams>();
    private DataSetOutputStreams currentDatasetOutputLocations;
    private HeaderBean header;
    private List<Namespace> knownNamespaces = new ArrayList<Namespace>();

    public AbstractDataWriterEngine(SDMX_SCHEMA schemaVersion, BASE_DATA_FORMAT dataFormat, OutputStream out) {
        this.finalOutputStream = out;
        this.schemaVersion = schemaVersion;
        this.dataFormat = dataFormat;
        this.createNamespaces();
    }

    private void createNamespaces() {
        this.COMPACT_NS = new Namespace("http://www.sdmxfusion.com/ns/compact", this.PREFIX_COMPACT);
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) {
            this.GENERIC_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.sdmx.org/resources/sdmxml/schemas/v2_1/common", this.PREFIX_COMMON);
        }
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
            this.GENERIC_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v2_0/common", this.PREFIX_COMMON);
        }
        if (this.schemaVersion == SDMX_SCHEMA.VERSION_ONE) {
            this.GENERIC_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/generic", this.PREFIX_GENERIC);
            this.MESSAGE_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message", this.PREFIX_MESSAGE);
            this.COMMON_NS = new Namespace("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/common", this.PREFIX_COMMON);
        }
    }

    private void writeNameSpace(Namespace ns) throws XMLStreamException {
        if (ns != null) {
            this.writer.writeNamespace(ns.namespacePrefix, ns.namespaceURL);
        }
    }

    protected boolean isTwoPointOne() {
        return this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE;
    }

    protected void startElement(XMLStreamWriter streamWriter, Namespace ns, String elementName) throws XMLStreamException {
        streamWriter.writeStartElement(ns.namespacePrefix, elementName, ns.namespaceURL);
    }

    private String getDsdRef(DataStructureBean dsd) {
        return dsd.getAgencyId() + "_" + dsd.getId() + "_" + dsd.getVersion().replaceAll("\\.", "_");
    }

    @Override
    public void startDataset(DataStructureBean dsd, DatasetHeaderBean header) {
        if (dsd == null) {
            throw new IllegalArgumentException("Can not start dataset, no DataStructure provided");
        }
        this.closeCurrentWriter();
        this.currentPosition = POSITION.DATASET;
        this.currentDatasetOutputLocations = new DataSetOutputStreams(dsd, header, this.knownNamespaces, this.outputDatasetLocations.size() + 1);
        if (this.currentDatasetOutputLocations.dataNamespace != null) {
            this.knownNamespaces.add(this.currentDatasetOutputLocations.dataNamespace);
        }
        this.crossSectionConcept = this.currentDatasetOutputLocations.getDimensionAtObservation();
        this.isCrossSectional = !this.crossSectionConcept.equals("TIME_PERIOD");
        this.out = this.currentDatasetOutputLocations.outputStream;
        this.seriesOut = this.currentDatasetOutputLocations.seriesOutLocation.getOutputStream();
        this.outputDatasetLocations.add(this.currentDatasetOutputLocations);
    }

    @Override
    public void writeHeader(HeaderBean header) {
        this.header = header;
    }

    @Override
    public void writeObservation(Date obsTime, String obsValue, TIME_FORMAT sdmxTimeFormat) {
        if (!ObjectUtil.validString(obsValue)) {
            obsValue = "NaN";
        }
        this.writeObservation(DateUtil.formatDate(obsTime, sdmxTimeFormat), obsValue);
    }

    protected String getComponentId(ComponentBean component) {
        if (component == null) {
            return null;
        }
        if (this.isTwoPointOne()) {
            return component.getId();
        }
        return ConceptRefUtil.getConceptId(component.getConceptRef());
    }

    @Override
    public void startGroup(String groupId) {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not startGroup, no call has been made to startDataset");
        }
    }

    @Override
    public void writeGroupKeyValue(String id, String value) {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeGroupKeyValue, no call has been made to startDataset");
        }
        if (this.currentPosition != POSITION.GROUP && this.currentPosition != POSITION.GROUP_KEY && this.currentPosition != POSITION.GROUP_KEY_ATTRIBUTE) {
            throw new IllegalArgumentException("Can not writeGroupKeyValue, not in a group");
        }
    }

    @Override
    public void startSeries() {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not startSeries, no call has been made to startDataset");
        }
    }

    @Override
    public void writeSeriesKeyValue(String id, String value) {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeSeriesKeyValue, no call has been made to startDataset");
        }
    }

    @Override
    public void writeAttributeValue(String id, String value) {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeAttributeValue, no call has been made to startDataset");
        }
    }

    @Override
    public void writeObservation(String obsIdValue, String obsValue) {
        if (this.currentPosition == null) {
            throw new IllegalArgumentException("Can not writeObservation, no call has been made to startDataset");
        }
    }

    public void writeDatasetAttribute(String id, String value) {
        this.currentDatasetOutputLocations.datasetAttributes.put(id, value);
    }

    protected abstract void closeGroupWriter() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.closeCurrentWriter();
        try {
            this.flushOutput();
        }
        finally {
            try {
                this.writer.writeEndDocument();
                this.writer.flush();
                this.writer.close();
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
            }
            catch (Throwable e) {
                System.err.println("Error trying to close resources");
                e.printStackTrace();
            }
        }
    }

    private void closeCurrentWriter() {
        if (this.currentDatasetOutputLocations != null) {
            try {
                if (this.isTwoPointOne()) {
                    this.seriesWriter.writeEndDocument();
                    this.seriesWriter.flush();
                    this.seriesWriter.close();
                    StreamUtil.closeStream(this.seriesOut);
                    this.closeGroupWriter();
                    this.copyToOutputStream(this.currentDatasetOutputLocations.seriesOutLocation);
                }
                this.writer.writeEndDocument();
                this.writer.flush();
                this.writer.close();
                this.out.flush();
                this.out.close();
            }
            catch (Throwable e) {
                this.currentDatasetOutputLocations.out.close();
                this.currentDatasetOutputLocations.seriesOutLocation.close();
                this.currentDatasetOutputLocations = null;
                this.isClosed = true;
                throw new RuntimeException(e);
            }
            finally {
                this.currentPosition = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToOutputStream(ReadableDataLocation rdl) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        InputStream is = rdl.getInputStream();
        XMLStreamReader parser = factory.createXMLStreamReader(is, "UTF-8");
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                StaxUtil.copyNode(parser, true, false, false, this.writer);
            }
        }
        catch (Throwable throwable) {
            parser.close();
            StreamUtil.closeStream(is);
            rdl.close();
            throw throwable;
        }
        parser.close();
        StreamUtil.closeStream(is);
        rdl.close();
    }

    private void flushOutput() {
        try {
            boolean multipleDatasets;
            XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
            this.writer = xmlOutputfactory.createXMLStreamWriter(this.finalOutputStream, "UTF-8");
            this.writer.writeStartDocument();
            boolean bl = multipleDatasets = this.outputDatasetLocations.size() > 1;
            if (this.isTwoPointOne()) {
                if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    this.startElement(this.writer, this.MESSAGE_NS, "StructureSpecificData");
                    this.writer.writeNamespace("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific");
                } else if (this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    this.startElement(this.writer, this.MESSAGE_NS, "GenericData");
                }
            } else if (multipleDatasets) {
                this.startElement(this.writer, this.MESSAGE_NS, "MessageGroup");
            } else {
                this.startElement(this.writer, this.MESSAGE_NS, this.dataFormat.getRootNode());
            }
            if (this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                this.writeNameSpace(this.GENERIC_NS);
            } else {
                HashSet<String> nameSpacePrefixWritten = new HashSet<String>();
                for (DataSetOutputStreams dsOut : this.outputDatasetLocations) {
                    if (!nameSpacePrefixWritten.contains(((DataSetOutputStreams)dsOut).dataNamespace.namespacePrefix)) {
                        this.writeNameSpace(dsOut.dataNamespace);
                        nameSpacePrefixWritten.add(((DataSetOutputStreams)dsOut).dataNamespace.namespacePrefix);
                    }
                    if (nameSpacePrefixWritten.contains(((DataSetOutputStreams)dsOut).datasetNamespace.namespacePrefix)) continue;
                    this.writeNameSpace(dsOut.datasetNamespace);
                    nameSpacePrefixWritten.add(((DataSetOutputStreams)dsOut).datasetNamespace.namespacePrefix);
                }
            }
            this.writeNameSpace(this.COMMON_NS);
            this.writeNameSpace(this.MESSAGE_NS);
            this.writer.writeNamespace("xsi", XSI_NS);
            this.writer.writeNamespace("xml", XML_NS);
            this.writeHeader();
            for (DataSetOutputStreams dsOut : this.outputDatasetLocations) {
                Namespace datasetNamespace = dsOut.datasetNamespace;
                if (multipleDatasets && !this.isTwoPointOne() && this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    datasetNamespace = this.GENERIC_NS;
                }
                this.startElement(this.writer, datasetNamespace, "DataSet");
                if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    for (String attributeName : dsOut.datasetAttributes.keySet()) {
                        this.writer.writeAttribute(attributeName, (String)dsOut.datasetAttributes.get(attributeName));
                    }
                }
                this.writeDatasetHeader(dsOut, multipleDatasets);
                this.copyToOutputStream(dsOut.out);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDatasetHeader(DataSetOutputStreams dsOut, boolean hasMultipleDatasets) throws XMLStreamException {
        if (this.isTwoPointOne()) {
            if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                this.writer.writeAttribute("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific", "dataScope", "DataStructure");
                this.writer.writeAttribute("xsi", XSI_NS, "type", this.COMPACT_NS.namespacePrefix + ":DataSetType");
                this.writer.writeAttribute("ss", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific", "structureRef", this.getDsdRef(dsOut.dsd));
            } else {
                this.writer.writeAttribute("structureRef", this.getDsdRef(dsOut.dsd));
            }
        }
        if (dsOut.headerBean != null) {
            DatasetHeaderBean datasetHeader = dsOut.headerBean;
            if (ObjectUtil.validString(datasetHeader.getPublicationPeriod())) {
                this.writer.writeAttribute("publicationPeriod", datasetHeader.getPublicationPeriod());
            }
            if (datasetHeader.getPublicationYear() > 0) {
                this.writer.writeAttribute("publicationYear", Integer.toString(datasetHeader.getPublicationYear()));
            }
            if (datasetHeader.getValidFrom() != null) {
                this.writer.writeAttribute("validFromDate", DateUtil.formatDate(datasetHeader.getValidFrom()));
            }
            if (datasetHeader.getValidTo() != null) {
                this.writer.writeAttribute("validToDate", DateUtil.formatDate(datasetHeader.getValidTo()));
            }
            if (hasMultipleDatasets) {
                if (datasetHeader.getAction() != null) {
                    this.writer.writeAttribute("action", datasetHeader.getAction().getAction());
                }
                if (ObjectUtil.validString(datasetHeader.getDatasetId())) {
                    if (this.isTwoPointOne()) {
                        this.writer.writeAttribute("setID", datasetHeader.getDatasetId());
                    } else {
                        this.writer.writeAttribute("datasetID", datasetHeader.getDatasetId());
                    }
                }
                if (!this.isTwoPointOne()) {
                    this.writer.writeAttribute("keyFamilyURI", dsOut.dsd.getUrn());
                }
                if (datasetHeader.getReportingBeginDate() != null) {
                    this.writer.writeAttribute("reportingBeginDate", DateUtil.formatDate(datasetHeader.getReportingBeginDate()));
                }
                if (datasetHeader.getReportingEndDate() != null) {
                    this.writer.writeAttribute("reportingEndDate", DateUtil.formatDate(datasetHeader.getReportingEndDate()));
                }
            }
        }
    }

    private void writeHeader() {
        try {
            this.startElement(this.writer, this.MESSAGE_NS, "Header");
            this.startElement(this.writer, this.MESSAGE_NS, "ID");
            if (this.header != null && ObjectUtil.validString(this.header.getId())) {
                this.writer.writeCharacters(this.header.getId());
            } else {
                this.writer.writeCharacters(Long.toString(new Date().getTime()));
            }
            this.writer.writeEndElement();
            this.startElement(this.writer, this.MESSAGE_NS, "Test");
            if (this.header != null) {
                this.writer.writeCharacters(new Boolean(this.header.isTest()).toString());
            } else {
                this.writer.writeCharacters("false");
            }
            this.writer.writeEndElement();
            if (!this.isTwoPointOne() && this.header != null && this.header.getName() != null) {
                this.writeMapContents(this.COMMON_NS, "Name", this.header.getName());
            }
            this.startElement(this.writer, this.MESSAGE_NS, "Prepared");
            if (this.header != null && this.header.getPrepared() != null) {
                this.writer.writeCharacters(DateUtil.formatDate(this.header.getPrepared()));
            } else {
                this.writer.writeCharacters(DateUtil.formatDate(new Date()));
            }
            this.writer.writeEndElement();
            this.startElement(this.writer, this.MESSAGE_NS, "Sender");
            if (this.header != null && this.header.getSender() != null) {
                this.writeParty(this.header.getSender(), this.isTwoPointOne());
            } else {
                this.writer.writeAttribute("id", "MetadataTechnology");
            }
            this.writer.writeEndElement();
            if (this.header != null && this.header.getReceiver() != null) {
                this.writeReceiver(this.header.getReceiver());
            }
            if (this.isTwoPointOne() && this.header != null && this.header.getName() != null) {
                this.writeMapContents(this.COMMON_NS, "Name", this.header.getName());
            }
            HashSet<DataStructureBean> dsds = new HashSet<DataStructureBean>();
            for (DataSetOutputStreams os : this.outputDatasetLocations) {
                dsds.add(os.dsd);
            }
            if (this.isTwoPointOne()) {
                for (DataStructureBean currentDsd : dsds) {
                    this.startElement(this.writer, this.MESSAGE_NS, "Structure");
                    this.writer.writeAttribute("structureID", this.getDsdRef(currentDsd));
                    if (this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                        this.writer.writeAttribute("namespace", this.COMPACT_NS.namespaceURL);
                    }
                    if (this.crossSectionConcept != null) {
                        this.writer.writeAttribute("dimensionAtObservation", this.crossSectionConcept);
                    } else {
                        this.writer.writeAttribute("dimensionAtObservation", "TIME_PERIOD");
                    }
                    this.startElement(this.writer, this.COMMON_NS, "Structure");
                    this.writer.writeStartElement("Ref");
                    this.writer.writeAttribute("agencyID", currentDsd.getAgencyId());
                    this.writer.writeAttribute("id", currentDsd.getId());
                    this.writer.writeAttribute("version", currentDsd.getVersion());
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
            } else if (dsds.size() == 1) {
                DataStructureBean dsd = (DataStructureBean)dsds.toArray()[0];
                this.startElement(this.writer, this.MESSAGE_NS, "KeyFamilyRef");
                this.writer.writeCharacters(dsd.getId());
                this.writer.writeEndElement();
                this.startElement(this.writer, this.MESSAGE_NS, "KeyFamilyAgency");
                this.writer.writeCharacters(dsd.getAgencyId());
                this.writer.writeEndElement();
            }
            if (this.header != null) {
                String reportingEndDate;
                String reportingBeginDate;
                MaintainableRefBean ref;
                if (this.isTwoPointOne() && this.header.getDataProviderReference() != null && ObjectUtil.validString((ref = this.header.getDataProviderReference().getMaintainableReference()).getAgencyId(), ref.getMaintainableId())) {
                    this.startElement(this.writer, this.MESSAGE_NS, "DataProvider");
                    this.writer.writeStartElement("Ref");
                    this.writer.writeAttribute("agencyID", ref.getAgencyId());
                    this.writer.writeAttribute("id", ref.getMaintainableId());
                    if (ObjectUtil.validString(ref.getVersion())) {
                        this.writer.writeAttribute("version", ref.getVersion());
                    } else {
                        this.writer.writeAttribute("version", "1.0");
                    }
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                if (!this.isTwoPointOne() && this.header.hasAdditionalAttribute("DATASET_AGENCY")) {
                    this.startElement(this.writer, this.MESSAGE_NS, "DataSetAgency");
                    this.writer.writeCharacters(this.header.getAdditionalAttribute("DATASET_AGENCY"));
                    this.writer.writeEndElement();
                }
                String datasetId = this.getDatasetIdForHeader();
                String datasetAction = this.getDatasetActionForHeader();
                if (this.isTwoPointOne()) {
                    this.writeDatasetAction(datasetAction);
                    this.writeDatasetId(datasetId);
                } else {
                    this.writeDatasetId(datasetId);
                    this.writeDatasetAction(datasetAction);
                }
                if (this.header.getExtracted() != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "Extracted");
                    this.writer.writeCharacters(DateUtil.formatDate(this.header.getExtracted()));
                    this.writer.writeEndElement();
                }
                if ((reportingBeginDate = this.getReportingBeginForHeader()) != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "ReportingBegin");
                    this.writer.writeCharacters(reportingBeginDate);
                    this.writer.writeEndElement();
                }
                if ((reportingEndDate = this.getReportingEndForHeader()) != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "ReportingEnd");
                    this.writer.writeCharacters(reportingEndDate);
                    this.writer.writeEndElement();
                }
                if (this.isTwoPointOne() && this.header.getEmbargoDate() != null) {
                    this.startElement(this.writer, this.MESSAGE_NS, "EmbargoDate");
                    this.writer.writeCharacters(DateUtil.formatDate(this.header.getEmbargoDate()));
                    this.writer.writeEndElement();
                }
                this.writeMapContents(this.MESSAGE_NS, "Source", this.header.getSource());
            }
            this.writer.writeEndElement();
            this.headerWritten = true;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean writeDatasetId(String datasetId) throws XMLStreamException {
        if (ObjectUtil.validString(datasetId)) {
            this.startElement(this.writer, this.MESSAGE_NS, "DataSetID");
            this.writer.writeCharacters(datasetId);
            this.writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeDatasetAction(String datasetAction) throws XMLStreamException {
        if (ObjectUtil.validString(datasetAction)) {
            this.startElement(this.writer, this.MESSAGE_NS, "DataSetAction");
            this.writer.writeCharacters(datasetAction);
            this.writer.writeEndElement();
            return true;
        }
        return false;
    }

    private String getDatasetIdForHeader() {
        if (ObjectUtil.validString(this.header.getDatasetId())) {
            return this.header.getDatasetId();
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return primaryHeaderBean.getDatasetId();
        }
        String primaryId = primaryHeaderBean.getDatasetId();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null) {
                return null;
            }
            if (primaryId.equals(headerBean.getDatasetId())) continue;
            return null;
        }
        return primaryId;
    }

    private String getDatasetActionForHeader() {
        if (this.header.getAction() != null) {
            return this.header.getAction().getAction();
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getAction() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return primaryHeaderBean.getAction().getAction();
        }
        DATASET_ACTION primaryAction = primaryHeaderBean.getAction();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getAction() == null) {
                return null;
            }
            if (primaryAction.equals((Object)headerBean.getAction())) continue;
            return null;
        }
        return primaryAction.getAction();
    }

    private String getReportingBeginForHeader() {
        if (this.header.getReportingBegin() != null) {
            return DateUtil.formatDate(this.header.getReportingBegin());
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getReportingBeginDate() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return DateUtil.formatDate(primaryHeaderBean.getReportingBeginDate());
        }
        Date primaryDate = primaryHeaderBean.getReportingBeginDate();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getReportingBeginDate() == null) {
                return null;
            }
            if (primaryDate.equals(headerBean.getReportingBeginDate())) continue;
            return null;
        }
        return DateUtil.formatDate(primaryDate);
    }

    private String getReportingEndForHeader() {
        if (this.header.getReportingEnd() != null) {
            return DateUtil.formatDate(this.header.getReportingEnd());
        }
        if (this.outputDatasetLocations.size() == 0) {
            return null;
        }
        DatasetHeaderBean primaryHeaderBean = this.outputDatasetLocations.get(0).headerBean;
        if (primaryHeaderBean == null || primaryHeaderBean.getReportingEndDate() == null) {
            return null;
        }
        if (this.outputDatasetLocations.size() == 1) {
            return DateUtil.formatDate(primaryHeaderBean.getReportingEndDate());
        }
        Date primaryDate = primaryHeaderBean.getReportingEndDate();
        for (int i = 1; i < this.outputDatasetLocations.size(); ++i) {
            DatasetHeaderBean headerBean = this.outputDatasetLocations.get(i).headerBean;
            if (headerBean == null || headerBean.getReportingEndDate() == null) {
                return null;
            }
            if (primaryDate.equals(headerBean.getReportingEndDate())) continue;
            return null;
        }
        return DateUtil.formatDate(primaryDate);
    }

    private void writeReceiver(List<PartyBean> receivers) throws XMLStreamException {
        if (receivers != null) {
            for (PartyBean currentReceiver : receivers) {
                this.startElement(this.writer, this.MESSAGE_NS, "Receiver");
                this.writeParty(currentReceiver, false);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeParty(PartyBean party, boolean includeTimeZone) throws XMLStreamException {
        if (ObjectUtil.validString(party.getId())) {
            this.writer.writeAttribute("id", party.getId());
            if (party.getName() != null) {
                Namespace nameNamespace = this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE ? this.COMMON_NS : this.MESSAGE_NS;
                this.writeMapContents(nameNamespace, "Name", party.getName());
            }
            if (party.getContacts() != null) {
                this.writeContacts(party.getContacts());
            }
            if (includeTimeZone && ObjectUtil.validString(party.getTimeZone())) {
                this.startElement(this.writer, this.MESSAGE_NS, "Timezone");
                this.writer.writeCharacters(party.getTimeZone());
                this.writer.writeEndElement();
            }
        } else {
            this.writer.writeAttribute("id", "unknown");
        }
    }

    private void writeMapContents(Namespace ns, String elementName, Map<String, String> map) throws XMLStreamException {
        if (map != null) {
            for (String lang : map.keySet()) {
                String value = map.get(lang);
                if (!ObjectUtil.validString(value)) continue;
                this.startElement(this.writer, ns, elementName);
                this.writer.writeAttribute("xml", XML_NS, "lang", lang);
                this.writer.writeCharacters(value);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeListContents(Namespace nameSpace, String elementName, List<String> list) throws XMLStreamException {
        if (list != null) {
            for (String value : list) {
                if (!ObjectUtil.validString(value)) continue;
                this.startElement(this.writer, nameSpace, elementName);
                this.writer.writeCharacters(value);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeContacts(List<PartyBean.ContactBean> contacts) throws XMLStreamException {
        if (contacts != null) {
            for (PartyBean.ContactBean currentContact : contacts) {
                this.startElement(this.writer, this.MESSAGE_NS, "Contact");
                this.writeContact(currentContact);
                this.writer.writeEndElement();
            }
        }
    }

    private void writeContact(PartyBean.ContactBean contact) throws XMLStreamException {
        Namespace nameNamespace = this.schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE ? this.COMMON_NS : this.MESSAGE_NS;
        this.writeMapContents(nameNamespace, "Name", contact.getName());
        this.writeMapContents(this.MESSAGE_NS, "Department", contact.getDepartments());
        this.writeMapContents(this.MESSAGE_NS, "Role", contact.getRole());
        this.writeListContents(this.MESSAGE_NS, "Telephone", contact.getTelephone());
        this.writeListContents(this.MESSAGE_NS, "Fax", contact.getFax());
        this.writeListContents(this.MESSAGE_NS, "X400", contact.getX400());
        this.writeListContents(this.MESSAGE_NS, "URI", contact.getUri());
        this.writeListContents(this.MESSAGE_NS, "Email", contact.getEmail());
    }

    private class DataSetOutputStreams {
        private WriteableDataLocation seriesOutLocation;
        private WriteableDataLocation out;
        private OutputStream outputStream;
        private DatasetHeaderBean headerBean;
        private DataStructureBean dsd;
        private Namespace datasetNamespace;
        private Namespace dataNamespace;
        private String dimensionAtObservation;
        private Map<String, String> datasetAttributes = new HashMap<String, String>();

        public DataSetOutputStreams(DataStructureBean dsd, DatasetHeaderBean headerBean, List<Namespace> knownNamespaces, int writerNumber) {
            this.dsd = dsd;
            this.out = new WriteableDataLocationTmp();
            this.outputStream = this.out.getOutputStream();
            this.headerBean = headerBean;
            this.setDimensionAtObservation();
            AbstractDataWriterEngine.this.writer = this.createWriter(this.outputStream, knownNamespaces, writerNumber);
            if (AbstractDataWriterEngine.this.isTwoPointOne()) {
                this.seriesOutLocation = new WriteableDataLocationTmp();
                AbstractDataWriterEngine.this.seriesWriter = this.createWriter(this.seriesOutLocation.getOutputStream(), knownNamespaces, writerNumber);
            } else {
                AbstractDataWriterEngine.this.seriesWriter = AbstractDataWriterEngine.this.writer;
                this.seriesOutLocation = this.out;
            }
        }

        public String getDimensionAtObservation() {
            return this.dimensionAtObservation;
        }

        private void setDimensionAtObservation() {
            this.dimensionAtObservation = this.headerBean == null || this.headerBean.getDataStructureReference() == null || !ObjectUtil.validString(this.headerBean.getDataStructureReference().getDimensionAtObservation()) ? "TIME_PERIOD" : this.headerBean.getDataStructureReference().getDimensionAtObservation();
        }

        private Namespace getNamespaceIfKnown(List<Namespace> knownNamespaces, String namespaceUrl) {
            for (Namespace currentNamespace : knownNamespaces) {
                if (!currentNamespace.namespaceURL.equals(namespaceUrl)) continue;
                return currentNamespace;
            }
            return null;
        }

        private XMLStreamWriter createWriter(OutputStream writerOut, List<Namespace> knownNamespaces, int writerNumber) {
            try {
                XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = xmlOutputfactory.createXMLStreamWriter(writerOut, "UTF-8");
                writer.writeStartDocument();
                if (AbstractDataWriterEngine.this.dataFormat == BASE_DATA_FORMAT.COMPACT) {
                    String ssNamespaceUrl = this.dsd.getUrn() + "ObsLevelDim:" + this.getDimensionAtObservation();
                    this.dataNamespace = this.getNamespaceIfKnown(knownNamespaces, ssNamespaceUrl);
                    if (this.dataNamespace == null) {
                        this.dataNamespace = new Namespace(ssNamespaceUrl, "ns" + writerNumber);
                    }
                    String namespaceUrl = null;
                    switch (AbstractDataWriterEngine.this.schemaVersion) {
                        case VERSION_ONE: {
                            namespaceUrl = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/compact";
                            this.datasetNamespace = new Namespace(namespaceUrl, "compact");
                            break;
                        }
                        case VERSION_TWO: {
                            namespaceUrl = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/compact";
                            this.datasetNamespace = new Namespace(namespaceUrl, "compact");
                            break;
                        }
                        case VERSION_TWO_POINT_ONE: {
                            this.datasetNamespace = this.dataNamespace;
                        }
                    }
                    AbstractDataWriterEngine.this.COMPACT_NS = this.dataNamespace;
                } else {
                    this.datasetNamespace = AbstractDataWriterEngine.this.MESSAGE_NS;
                }
                AbstractDataWriterEngine.this.startElement(writer, this.datasetNamespace, "DataSet");
                writer.writeNamespace(((AbstractDataWriterEngine)AbstractDataWriterEngine.this).MESSAGE_NS.namespacePrefix, ((AbstractDataWriterEngine)AbstractDataWriterEngine.this).MESSAGE_NS.namespaceURL);
                if (this.dataNamespace != null && this.dataNamespace != this.datasetNamespace) {
                    writer.writeNamespace(this.dataNamespace.namespacePrefix, this.dataNamespace.namespaceURL);
                }
                if (AbstractDataWriterEngine.this.dataFormat == BASE_DATA_FORMAT.GENERIC) {
                    writer.writeNamespace(AbstractDataWriterEngine.this.GENERIC_NS.namespacePrefix, AbstractDataWriterEngine.this.GENERIC_NS.namespaceURL);
                }
                writer.writeNamespace("xsi", AbstractDataWriterEngine.XSI_NS);
                writer.writeNamespace("xml", AbstractDataWriterEngine.XML_NS);
                if (this.datasetNamespace != AbstractDataWriterEngine.this.MESSAGE_NS) {
                    writer.writeNamespace(this.datasetNamespace.namespacePrefix, this.datasetNamespace.namespaceURL);
                }
                return writer;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static enum POSITION {
        DATASET,
        DATASET_ATTRIBUTE,
        SERIES_KEY,
        SERIES_KEY_ATTRIBUTE,
        GROUP,
        GROUP_KEY,
        GROUP_KEY_ATTRIBUTE,
        GROUP_SERIES_KEY,
        GROUP_SERIES_KEY_ATTRIBUTE,
        OBSERVATION,
        OBSERVATION_ATTRIBUTE;

    }

    class Namespace {
        protected String namespaceURL;
        protected String namespacePrefix;

        public Namespace(String namespaceURL, String namespacePrefix) {
            this.namespaceURL = namespaceURL;
            this.namespacePrefix = namespacePrefix;
        }
    }
}

