/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.dataparser.engine.writer.AbstractDataWriterEngine;
import org.sdmxsource.util.ObjectUtil;

public class CompactDataWriterEngine
extends AbstractDataWriterEngine {
    private String primaryMeasureConcept;
    private String timeConcept;

    public CompactDataWriterEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        super(schemaVersion, BASE_DATA_FORMAT.COMPACT, out);
    }

    @Override
    public void startDataset(DataStructureBean dsd, DatasetHeaderBean header) {
        super.startDataset(dsd, header);
        this.primaryMeasureConcept = this.getComponentId(dsd.getPrimaryMeasure());
        this.timeConcept = this.getComponentId(dsd.getTimeDimension());
    }

    @Override
    public void writeObservation(String obsIdValue, String obsValue) {
        super.writeObservation(obsIdValue, obsValue);
        if (!ObjectUtil.validString(obsValue)) {
            obsValue = "NaN";
        }
        if (obsIdValue == null) {
            if (this.isCrossSectional) {
                throw new ValidationException("Error while writing observation, a value for cross sectional concept '" + this.crossSectionConcept + "' expected and not given");
            }
            throw new ValidationException("Error while writing observation, an observation time was expected and not given");
        }
        try {
            switch (this.currentPosition) {
                case OBSERVATION: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case OBSERVATION_ATTRIBUTE: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case SERIES_KEY: {
                    break;
                }
                case SERIES_KEY_ATTRIBUTE: {
                    break;
                }
                default: {
                    if (this.isTwoPointOne()) break;
                    throw new IllegalArgumentException("An observation may only be written while inside a series");
                }
            }
            this.currentPosition = AbstractDataWriterEngine.POSITION.OBSERVATION;
            if (this.isTwoPointOne()) {
                this.seriesWriter.writeStartElement("Obs");
            } else {
                this.startElement(this.seriesWriter, this.COMPACT_NS, "Obs");
            }
            if (this.isCrossSectional) {
                this.seriesWriter.writeAttribute(this.crossSectionConcept, obsIdValue);
            } else {
                if (this.timeConcept == null) {
                    throw new IllegalArgumentException("Can not write observation - writer engine is not outputting cross sectional data, and there is no time dimension");
                }
                this.seriesWriter.writeAttribute(this.timeConcept, obsIdValue);
            }
            if (obsValue == null) {
                throw new ValidationException("Observation value can not be null");
            }
            this.seriesWriter.writeAttribute(this.primaryMeasureConcept, obsValue);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startGroup(String groupId) {
        super.startGroup(groupId);
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case OBSERVATION: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case GROUP: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                    }
                }
            }
            if (this.isTwoPointOne()) {
                this.writer.writeStartElement("Group");
                this.writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.COMPACT_NS.namespacePrefix + ":" + groupId);
            } else {
                this.writer.writeStartElement(this.COMPACT_NS.namespacePrefix, groupId, this.COMPACT_NS.namespaceURL);
            }
            this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeGroupWriter() throws Exception {
        if (this.currentPosition != null) {
            switch (this.currentPosition) {
                case GROUP: {
                    this.writer.writeEndElement();
                    break;
                }
                case GROUP_KEY_ATTRIBUTE: {
                    this.writer.writeEndElement();
                }
            }
        }
        this.writer.flush();
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        super.writeGroupKeyValue(conceptId, conceptValue);
        try {
            if (this.currentPosition != AbstractDataWriterEngine.POSITION.GROUP) {
                throw new IllegalArgumentException("startGroup must be called before calling writeGroupKeyValue");
            }
            this.writer.writeAttribute(conceptId, conceptValue);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startSeries() {
        super.startSeries();
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case OBSERVATION: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case GROUP: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                    }
                }
            }
            if (this.isTwoPointOne()) {
                this.seriesWriter.writeStartElement("Series");
            } else {
                this.startElement(this.seriesWriter, this.COMPACT_NS, "Series");
            }
            this.currentPosition = AbstractDataWriterEngine.POSITION.SERIES_KEY;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeSeriesKeyValue(String dimensionId, String dimensionValue) {
        super.writeSeriesKeyValue(dimensionId, dimensionValue);
        try {
            if (this.currentPosition != AbstractDataWriterEngine.POSITION.SERIES_KEY) {
                this.startSeries();
            }
            this.seriesWriter.writeAttribute(dimensionId, dimensionValue);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeAttributeValue(String attributeId, String attributeValue) {
        super.writeAttributeValue(attributeId, attributeValue);
        if (attributeValue == null) {
            attributeValue = "";
        }
        try {
            switch (this.currentPosition) {
                case DATASET: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.DATASET_ATTRIBUTE;
                    break;
                }
                case OBSERVATION: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.OBSERVATION_ATTRIBUTE;
                    break;
                }
                case SERIES_KEY: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.SERIES_KEY_ATTRIBUTE;
                    break;
                }
                case GROUP: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                }
            }
            if (this.currentPosition == AbstractDataWriterEngine.POSITION.DATASET_ATTRIBUTE) {
                super.writeDatasetAttribute(attributeId, attributeValue);
            } else if (this.currentPosition == AbstractDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE) {
                this.writer.writeAttribute(attributeId, attributeValue);
            } else {
                this.seriesWriter.writeAttribute(attributeId, attributeValue);
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

