/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.dataparser.engine.writer.AbstractDataWriterEngine;
import org.sdmxsource.util.ObjectUtil;

public class GenericDataWriterEngine
extends AbstractDataWriterEngine {
    private String conceptAttribute;

    public GenericDataWriterEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        super(schemaVersion, BASE_DATA_FORMAT.GENERIC, out);
        this.setConceptAttribute();
    }

    private void setConceptAttribute() {
        this.conceptAttribute = this.isTwoPointOne() ? "id" : "concept";
    }

    @Override
    public void startDataset(DataStructureBean dsd, DatasetHeaderBean header) {
        super.startDataset(dsd, header);
        if (!this.isTwoPointOne()) {
            try {
                this.startElement(this.writer, this.GENERIC_NS, "KeyFamilyRef");
                this.writer.writeCharacters(dsd.getId());
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void startSeries() {
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case DATASET_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case OBSERVATION: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case GROUP: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case GROUP_KEY: {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                    }
                }
            }
            this.startElement(this.seriesWriter, this.GENERIC_NS, "Series");
            this.startElement(this.seriesWriter, this.GENERIC_NS, "SeriesKey");
            this.currentPosition = AbstractDataWriterEngine.POSITION.SERIES_KEY;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeAttributeValue(String conceptId, String conceptValue) {
        if (conceptValue == null) {
            conceptValue = "";
        }
        XMLStreamWriter attributeWriter = this.seriesWriter;
        try {
            switch (this.currentPosition) {
                case DATASET: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.DATASET_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case OBSERVATION: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.OBSERVATION_ATTRIBUTE;
                    this.startElement(this.seriesWriter, this.GENERIC_NS, "Attributes");
                    break;
                }
                case SERIES_KEY: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.SERIES_KEY_ATTRIBUTE;
                    this.seriesWriter.writeEndElement();
                    this.startElement(this.seriesWriter, this.GENERIC_NS, "Attributes");
                    break;
                }
                case GROUP: {
                    this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case GROUP_KEY: {
                    this.writer.writeEndElement();
                    this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                    this.startElement(this.writer, this.GENERIC_NS, "Attributes");
                    attributeWriter = this.writer;
                    break;
                }
                case GROUP_KEY_ATTRIBUTE: {
                    attributeWriter = this.writer;
                }
            }
            this.startElement(attributeWriter, this.GENERIC_NS, "Value");
            attributeWriter.writeAttribute(this.conceptAttribute, conceptId);
            attributeWriter.writeAttribute("value", conceptValue);
            attributeWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        try {
            if (this.currentPosition != AbstractDataWriterEngine.POSITION.GROUP && this.currentPosition != AbstractDataWriterEngine.POSITION.GROUP_KEY) {
                throw new IllegalArgumentException("startGroup must be called before valling writeGroupKeyValue");
            }
            this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP_KEY;
            this.startElement(this.writer, this.GENERIC_NS, "Value");
            this.writer.writeAttribute(this.conceptAttribute, conceptId);
            this.writer.writeAttribute("value", conceptValue);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeSeriesKeyValue(String conceptId, String conceptValue) {
        try {
            if (this.currentPosition != AbstractDataWriterEngine.POSITION.SERIES_KEY) {
                this.startSeries();
            }
            this.startElement(this.seriesWriter, this.GENERIC_NS, "Value");
            this.seriesWriter.writeAttribute(this.conceptAttribute, conceptId);
            this.seriesWriter.writeAttribute("value", conceptValue);
            this.seriesWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeGroupWriter() throws Exception {
        if (this.currentPosition != null) {
            switch (this.currentPosition) {
                case GROUP: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observation to group , an observation must belong to a series");
                }
                case GROUP_KEY_ATTRIBUTE: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observation to group , an observation must belong to a series");
                }
            }
        }
        this.writer.flush();
    }

    @Override
    public void writeObservation(String obsConcept, String obsValue) {
        if (!ObjectUtil.validString(obsValue)) {
            obsValue = "NaN";
        }
        if (obsConcept == null) {
            if (this.isCrossSectional) {
                throw new ValidationException("Error while writing observation, a value for cross sectional concept '" + this.crossSectionConcept + "' expected and not given");
            }
            throw new ValidationException("Error while writing observation, an observation time was expected and not given");
        }
        try {
            switch (this.currentPosition) {
                case OBSERVATION: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case OBSERVATION_ATTRIBUTE: {
                    this.seriesWriter.writeEndElement();
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case SERIES_KEY_ATTRIBUTE: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case SERIES_KEY: {
                    this.seriesWriter.writeEndElement();
                    break;
                }
                case GROUP: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observastion to group , an observation must belong to a series");
                }
                case GROUP_KEY: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observastion to group , an observation must belong to a series");
                }
                case GROUP_KEY_ATTRIBUTE: {
                    if (this.isTwoPointOne()) {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                        break;
                    }
                    throw new ValidationException("Attempting to write observastion to group , an observation must belong to a series");
                }
                default: {
                    throw new IllegalArgumentException("An observation may only be written while inside a series");
                }
            }
            this.currentPosition = AbstractDataWriterEngine.POSITION.OBSERVATION;
            this.startElement(this.seriesWriter, this.GENERIC_NS, "Obs");
            if (this.isTwoPointOne()) {
                this.startElement(this.seriesWriter, this.GENERIC_NS, "ObsDimension");
                if (this.isCrossSectional) {
                    this.seriesWriter.writeAttribute("id", this.crossSectionConcept);
                }
                this.seriesWriter.writeAttribute("value", obsConcept);
                this.seriesWriter.writeEndElement();
            } else {
                this.startElement(this.seriesWriter, this.GENERIC_NS, "Time");
                this.seriesWriter.writeCharacters(obsConcept);
                this.seriesWriter.writeEndElement();
            }
            this.startElement(this.seriesWriter, this.GENERIC_NS, "ObsValue");
            if (ObjectUtil.validString(obsValue)) {
                this.seriesWriter.writeAttribute("value", obsValue);
            }
            this.seriesWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startGroup(String groupId) {
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case DATASET_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case OBSERVATION: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case SERIES_KEY: {
                        this.seriesWriter.writeEndElement();
                        this.seriesWriter.writeEndElement();
                        break;
                    }
                    case GROUP: {
                        this.writer.writeEndElement();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writer.writeEndElement();
                        this.writer.writeEndElement();
                    }
                }
            }
            this.startElement(this.writer, this.GENERIC_NS, "Group");
            this.writer.writeAttribute("type", groupId);
            this.startElement(this.writer, this.GENERIC_NS, "GroupKey");
            this.currentPosition = AbstractDataWriterEngine.POSITION.GROUP;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

