/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.factory;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.factory.DataReaderFactory;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.reader.CompactDataReaderEngine;
import org.sdmxsource.sdmx.dataparser.engine.reader.GenericDataReaderEngine;
import org.sdmxsource.sdmx.dataparser.manager.DataInformationManager;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SdmxDataReaderFactory
implements DataReaderFactory {
    private static Logger LOG = Logger.getLogger(SdmxDataReaderFactory.class);
    @Autowired
    private DataInformationManager dataInformationManager;
    @Autowired
    private EdiParseManager ediParseManager;

    @Override
    public DataReaderEngine getDataReaderEngine(ReadableDataLocation sourceData, DataStructureBean dsd) {
        DataFormat dataFormat;
        LOG.debug("Get Data Reader Engine");
        MESSAGE_TYPE message = SdmxMessageUtil.getMessageType(sourceData);
        if (message == MESSAGE_TYPE.ERROR) {
            SdmxMessageUtil.parseSdmxErrorMessage(sourceData);
        }
        if (message != MESSAGE_TYPE.COMPACT_DATA && message != MESSAGE_TYPE.GENERIC_DATA && message != MESSAGE_TYPE.SDMX_EDI && message != MESSAGE_TYPE.UTILITY_DATA) {
            throw new IllegalArgumentException("Can not process message of type:" + message.getNodeName());
        }
        LOG.debug("No chained factories found reader for data, assume data is SDMX/EDI");
        try {
            dataFormat = this.dataInformationManager.getDataType(sourceData);
        }
        catch (Throwable th) {
            return null;
        }
        if (dataFormat != null && dataFormat.getSdmxDataFormat() != null) {
            switch (dataFormat.getSdmxDataFormat().getBaseDataFormat()) {
                case EDI: {
                    return this.ediParseManager.parseEDIMessage(sourceData).getDataReader(dsd);
                }
                case COMPACT: {
                    return new CompactDataReaderEngine(sourceData, dsd);
                }
                case GENERIC: {
                    return new GenericDataReaderEngine(sourceData, dsd);
                }
            }
        }
        return null;
    }

    @Override
    public DataReaderEngine getDataReaderEngine(ReadableDataLocation sourceData, SdmxBeanRetrievalManager retrievalManager) {
        DataFormat dataFormat;
        try {
            dataFormat = this.dataInformationManager.getDataType(sourceData);
        }
        catch (Throwable th) {
            return null;
        }
        if (dataFormat != null && dataFormat.getSdmxDataFormat() != null) {
            switch (dataFormat.getSdmxDataFormat().getBaseDataFormat()) {
                case EDI: {
                    return this.ediParseManager.parseEDIMessage(sourceData).getDataReader(retrievalManager);
                }
                case COMPACT: {
                    return new CompactDataReaderEngine(sourceData, retrievalManager, null);
                }
                case GENERIC: {
                    return new GenericDataReaderEngine(sourceData, retrievalManager, null);
                }
            }
        }
        return null;
    }
}

