/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.ConstraintRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.validation.DataValidationManager;
import org.sdmxsource.sdmx.dataparser.manager.impl.ConstraintValidationManager;
import org.sdmxsource.sdmx.dataparser.manager.impl.DeepDataValidationManager;
import org.sdmxsource.sdmx.structureretrieval.manager.SdmxSuperBeanRetrievalManagerImpl;
import org.springframework.beans.factory.annotation.Required;

public class ChainedValidationManager
implements DataValidationManager {
    private ConstraintRetrievalManager constraintRetrievalManager;
    private SdmxSuperBeanRetrievalManager superBeanRetrievalManager;
    private SdmxBeanRetrievalManager beanRetrievalManager;

    @Override
    public void validateData(DataReaderEngine dre) {
        this.validateDataAgainstDataStructure(dre);
        this.validateDataAgainstConstraint(dre);
    }

    protected void validateDataAgainstDataStructure(DataReaderEngine dre) {
        this.validate(new DeepDataValidationManager(this.superBeanRetrievalManager), dre);
    }

    protected void validateDataAgainstConstraint(DataReaderEngine dre) {
        this.validate(new ConstraintValidationManager(this.constraintRetrievalManager, this.beanRetrievalManager), dre);
    }

    protected void validate(DataValidationManager dvm, DataReaderEngine dre) {
        dvm.validateData(dre);
    }

    @Required
    public void setBeanRetrievalManager(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
        this.superBeanRetrievalManager = new SdmxSuperBeanRetrievalManagerImpl(beanRetrievalManager);
    }

    @Required
    public void setConstraintRetrievalManager(ConstraintRetrievalManager constraintRetrievalManager) {
        this.constraintRetrievalManager = constraintRetrievalManager;
    }
}

