/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.ConstraintRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.dataparser.engine.impl.ConstraintValidationEngine;
import org.sdmxsource.sdmx.dataparser.manager.impl.AbstractValidationManager;

public class ConstraintValidationManager
extends AbstractValidationManager {
    private static final Logger LOG = Logger.getLogger(ConstraintValidationManager.class);
    private ConstraintRetrievalManager constraintRetrievalManager;
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public ConstraintValidationManager(ConstraintRetrievalManager constraintRetrievalManager, SdmxBeanRetrievalManager beanRetrievalManager) {
        if (constraintRetrievalManager == null) {
            throw new IllegalArgumentException("ConstraintValidationManager can not be constructucted: ConstraintRetrievalManager can not be null");
        }
        if (beanRetrievalManager == null) {
            throw new IllegalArgumentException("ConstraintValidationManager can not be constructucted: SdmxBeanRetrievalManager can not be null");
        }
        this.constraintRetrievalManager = constraintRetrievalManager;
        this.beanRetrievalManager = beanRetrievalManager;
    }

    @Override
    public void validateData(DataReaderEngine dre) {
        LOG.info("Perform constraint data validation: Validate data against restrictions defined by ContentConstraint");
        super.validateData(new ConstraintValidationEngine(dre, this.constraintRetrievalManager, this.beanRetrievalManager), dre);
    }
}

