/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SdmxConstants;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.FixedConceptEngine;
import org.sdmxsource.sdmx.dataparser.engine.ReportedDateEngine;
import org.sdmxsource.sdmx.dataparser.manager.DataInformationManager;
import org.sdmxsource.sdmx.dataparser.model.DataInformation;
import org.sdmxsource.sdmx.sdmxbeans.model.data.SdmxDataFormat;
import org.sdmxsource.sdmx.util.exception.ParseException;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataInformationManagerImpl
implements DataInformationManager {
    @Autowired
    private ReportedDateEngine reportedDateEngine;
    @Autowired
    private FixedConceptEngine fixedConceptEngine;

    @Override
    public Map<TIME_FORMAT, List<String>> getAllReportedDates(DataReaderEngine dataReaderEngine) {
        return this.reportedDateEngine.getAllReportedDates(dataReaderEngine);
    }

    @Override
    public List<KeyValue> getFixedConcepts(DataReaderEngine dre, boolean includeObs, boolean includeAttributes) {
        return this.fixedConceptEngine.getFixedConcepts(dre, includeObs, includeAttributes);
    }

    @Override
    public DataInformation getDataInformation(DataReaderEngine dre) {
        return new DataInformation(dre);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataFormat getDataType(ReadableDataLocation sourceData) {
        if (SdmxMessageUtil.getMessageType(sourceData) == MESSAGE_TYPE.SDMX_EDI) {
            return new SdmxDataFormat(DATA_TYPE.EDI_TS);
        }
        stream = sourceData.getInputStream();
        try {
            factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(stream, "UTF-8");
            rootNode = null;
            while (parser.hasNext()) {
                event = parser.next();
                if (event != 1) continue;
                rootNode = parser.getLocalName();
                ** GOTO lbl14
            }
            {
                throw new ParseException(ExceptionCode.XML_PARSE_EXCEPTION, new Object[]{"Unknown Data type with root node :" + rootNode});
lbl14:
                // 2 sources

                for (i = 0; i < parser.getNamespaceCount(); ++i) {
                    ns = parser.getNamespaceURI(i);
                    if (SdmxConstants.getNamespacesV1().contains(ns)) {
                        if (rootNode.equals("GenericData")) {
                            var9_10 = new SdmxDataFormat(DATA_TYPE.GENERIC_1_0);
                            return var9_10;
                        }
                        if (rootNode.equals("UtilityData")) {
                            var9_11 = new SdmxDataFormat(DATA_TYPE.UTILITY_1_0);
                            return var9_11;
                        }
                        if (rootNode.equals("CompactData")) {
                            var9_12 = new SdmxDataFormat(DATA_TYPE.COMPACT_1_0);
                            return var9_12;
                        }
                        if (rootNode.equals("CrossSectionalData")) {
                            var9_13 = new SdmxDataFormat(DATA_TYPE.CROSS_SECTIONAL_1_0);
                            return var9_13;
                        }
                        if (rootNode.equals("MessageGroup") == false) throw new IllegalArgumentException("Unexpected root node '" + rootNode + "'");
                        dataForamt = this.getMessageGroupDataFormat(parser);
                        if (dataForamt == null) throw new IllegalArgumentException("Unknown Message Group Format");
                        switch (1.$SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT[dataForamt.ordinal()]) {
                            case 1: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_1_0_COMPACT);
                                return e;
                            }
                            case 2: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_1_0_GENERIC);
                                return e;
                            }
                            case 3: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_1_0_UTILITY);
                                return e;
                            }
                        }
                        throw new IllegalArgumentException("Unknown Message Group Format");
                    }
                    if (SdmxConstants.getNamespacesV2().contains(ns)) {
                        if (rootNode.equals("GenericData")) {
                            dataForamt = new SdmxDataFormat(DATA_TYPE.GENERIC_2_0);
                            return dataForamt;
                        }
                        if (rootNode.equals("UtilityData")) {
                            dataForamt = new SdmxDataFormat(DATA_TYPE.UTILITY_2_0);
                            return dataForamt;
                        }
                        if (rootNode.equals("CompactData")) {
                            dataForamt = new SdmxDataFormat(DATA_TYPE.COMPACT_2_0);
                            return dataForamt;
                        }
                        if (rootNode.equals("CrossSectionalData")) {
                            dataForamt = new SdmxDataFormat(DATA_TYPE.CROSS_SECTIONAL_2_0);
                            return dataForamt;
                        }
                        if (rootNode.equals("MessageGroup") == false) throw new IllegalArgumentException("Unexpected root node '" + rootNode + "'");
                        dataForamt = this.getMessageGroupDataFormat(parser);
                        if (dataForamt == null) throw new IllegalArgumentException("Unknown Message Group Format");
                        switch (1.$SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT[dataForamt.ordinal()]) {
                            case 1: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_2_0_COMPACT);
                                return e;
                            }
                            case 2: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_2_0_GENERIC);
                                return e;
                            }
                            case 3: {
                                e = new SdmxDataFormat(DATA_TYPE.MESSAGE_GROUP_2_0_UTILITY);
                                return e;
                            }
                        }
                        throw new IllegalArgumentException("Unknown Message Group Format");
                    }
                    if (!SdmxConstants.getNamespacesV2_1().contains(ns)) continue;
                    if (rootNode.equals("StructureSpecificTimeSeriesData") || rootNode.equals("StructureSpecificData")) {
                        var9_20 = new SdmxDataFormat(DATA_TYPE.COMPACT_2_1);
                        return var9_20;
                    }
                    if (rootNode.equals("GenericTimeSeriesData") || rootNode.equals("GenericData")) {
                        var9_21 = new SdmxDataFormat(DATA_TYPE.GENERIC_2_1);
                        return var9_21;
                    }
                    ** try [egrp 33[TRYBLOCK] [32 : 1074->1174)] { 
lbl78:
                    // 1 sources

                    throw new IllegalArgumentException("Unexpected root node '" + rootNode + "'");
                }
                throw new ParseException(ExceptionCode.XML_PARSE_EXCEPTION, new Object[]{"Can not determine data type unknown namespaces defined"});
            }
        }
lbl80:
        // 2 sources

        catch (XMLStreamException e) {
            throw new ParseException((Throwable)e, ExceptionCode.XML_PARSE_EXCEPTION, new Object[0]);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private BASE_DATA_FORMAT getMessageGroupDataFormat(XMLStreamReader parser) throws XMLStreamException {
        while (parser.hasNext()) {
            String rootNode;
            int event = parser.next();
            if (event != 1 || !(rootNode = parser.getLocalName()).equals("DataSet")) continue;
            String namespaceURI = parser.getNamespaceURI();
            if ("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/generic".equals(namespaceURI) || "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/generic".equals(namespaceURI)) {
                return BASE_DATA_FORMAT.GENERIC;
            }
            if ("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/utility".equals(namespaceURI) || "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/utility".equals(namespaceURI)) {
                return BASE_DATA_FORMAT.UTILITY;
            }
            if ("http://www.SDMX.org/resources/SDMXML/schemas/v1_0/compact".equals(namespaceURI) || "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/compact".equals(namespaceURI)) {
                return BASE_DATA_FORMAT.COMPACT;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTargetNamepace(ReadableDataLocation sourceData) {
        InputStream stream = sourceData.getInputStream();
        try {
            String string = this.jumpToNode(stream, "DataSet", null, true).getNamespaceURI();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private XMLStreamReader jumpToNode(InputStream stream, String findNodeName, String doNotProcessPastNodeName, boolean throwException) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(stream, "UTF-8");
            String rootNode = null;
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && (rootNode = parser.getLocalName()).equals(findNodeName)) {
                    return parser;
                }
                if (event != 2) continue;
                String nodeName = parser.getLocalName();
                if (doNotProcessPastNodeName == null || !nodeName.equals(doNotProcessPastNodeName)) continue;
                if (throwException) {
                    throw new IllegalArgumentException("Could not find element: " + nodeName);
                }
                return null;
            }
            throw new IllegalArgumentException("Could not find element: " + findNodeName);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT;

        static {
            $SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT = new int[BASE_DATA_FORMAT.values().length];
            try {
                1.$SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT[BASE_DATA_FORMAT.COMPACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT[BASE_DATA_FORMAT.GENERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$sdmxsource$sdmx$api$constants$BASE_DATA_FORMAT[BASE_DATA_FORMAT.UTILITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

