/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.util.Collection;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.factory.DataReaderFactory;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.manager.DataReaderManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class DataReaderManagerImpl
implements DataReaderManager,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public DataReaderEngine getDataReaderEngine(ReadableDataLocation sourceData, DataStructureBean dsd) {
        for (DataReaderFactory currentFactory : this.getDataReaderFactories()) {
            DataReaderEngine dre = currentFactory.getDataReaderEngine(sourceData, dsd);
            if (dre == null) continue;
            return dre;
        }
        throw new UnsupportedException(new Object[]{"Data format is either not supported, or has an invalid syntax"});
    }

    @Override
    public DataReaderEngine getDataReaderEngine(ReadableDataLocation sourceData, SdmxBeanRetrievalManager retrievalManager) {
        for (DataReaderFactory currentFactory : this.getDataReaderFactories()) {
            DataReaderEngine dre = currentFactory.getDataReaderEngine(sourceData, retrievalManager);
            if (dre == null) continue;
            return dre;
        }
        throw new UnsupportedException(new Object[]{"Data format is either not supported, or has an invalid syntax"});
    }

    private Collection<DataReaderFactory> getDataReaderFactories() throws IllegalArgumentException {
        return this.applicationContext.getBeansOfType(DataReaderFactory.class).values();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

