/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.OutputStream;
import java.util.Collection;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.factory.DataWriterFactory;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.dataparser.manager.DataWriterManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class DataWriterManagerImpl
implements DataWriterManager,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public DataWriterEngine getDataWriterEngine(DataFormat dataFormat, OutputStream out) {
        for (DataWriterFactory dwf : this.getDataWriterFactories()) {
            DataWriterEngine dwe = dwf.getDataWriterEngine(dataFormat, out);
            if (dwe == null) continue;
            return dwe;
        }
        throw new UnsupportedException(new Object[]{"Could not write data out in type: " + dataFormat});
    }

    private Collection<DataWriterFactory> getDataWriterFactories() throws IllegalArgumentException {
        return this.applicationContext.getBeansOfType(DataWriterFactory.class).values();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

