/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.manager.DataInformationManager;
import org.sdmxsource.sdmx.dataparser.manager.SchemaGenerationManager;
import org.sdmxsource.sdmx.dataparser.manager.SchemaValidationManager;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.io.WriteableDataLocationTmp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaDataValidationManager
implements SchemaValidationManager {
    private static Logger LOG = Logger.getLogger(SchemaDataValidationManager.class);
    @Autowired
    private DataInformationManager dataInformationManager;
    @Autowired
    private SchemaGenerationManager schemaGenerationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateDatasetAgainstSchema(ReadableDataLocation dataset, DataStructureSuperBean dsd) throws ValidationException {
        LOG.info("Validating dataset against schema");
        DataFormat dataFormat = this.dataInformationManager.getDataType(dataset);
        if (dataFormat.getSdmxDataFormat() == null) {
            throw new IllegalArgumentException("Could not determine datatype of data.  Expecting an SDMX message");
        }
        if (dataFormat.getSdmxDataFormat() != null) {
            DATA_TYPE dataType = dataFormat.getSdmxDataFormat();
            if (dataType == DATA_TYPE.GENERIC_1_0 || dataType == DATA_TYPE.GENERIC_2_0) {
                LOG.debug("Validate against Generic XSD");
                XMLParser.validateXML(dataset, dataType.getSchemaVersion(), new ReadableDataLocation[0]);
            } else {
                if (dsd == null) {
                    throw new IllegalArgumentException("Can not generate a Schema, no DataStructure was supplied");
                }
                WriteableDataLocationTmp schemaLocation = new WriteableDataLocationTmp();
                OutputStream out = null;
                try {
                    out = schemaLocation.getOutputStream();
                    String targetNamespace = this.dataInformationManager.getTargetNamepace(dataset);
                    LOG.debug("Generate a ");
                    this.schemaGenerationManager.generateSchema(out, dsd, targetNamespace, dataType, null);
                    LOG.debug("schema generated, perform validation");
                    XMLParser.validateXML(dataset, dataType.getSchemaVersion(), schemaLocation);
                }
                finally {
                    schemaLocation.close();
                }
            }
            LOG.info("Dataset is valid against schema");
        }
    }
}

