/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.dataparser.manager.SchemaGenerationManager;
import org.sdmxsource.sdmx.dataparser.transform.impl.SchemaGeneratorCompact;
import org.sdmxsource.sdmx.dataparser.transform.impl.SchemaGeneratorUtility;
import org.sdmxsource.util.io.StreamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaGenerationManagerImpl
implements SchemaGenerationManager {
    @Autowired(required=false)
    private SchemaGeneratorCompact schemaGeneratorCompact;
    @Autowired(required=false)
    private SchemaGeneratorUtility schemaGeneratorUtility;

    @Override
    public void generateSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, DATA_TYPE schema, Map<String, Set<String>> constraintsMap) {
        SDMX_SCHEMA schemaVersion = schema.getSchemaVersion();
        switch (schema.getBaseDataFormat()) {
            case GENERIC: {
                FileInputStream is;
                try {
                    switch (schemaVersion) {
                        case VERSION_ONE: {
                            is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                            break;
                        }
                        case VERSION_TWO: {
                            is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                            break;
                        }
                        case VERSION_TWO_POINT_ONE: {
                            is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Generic format not supported in version : " + (Object)((Object)schemaVersion));
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                StreamUtil.copyStream(is, out);
                break;
            }
            case COMPACT: {
                this.schemaGeneratorCompact.transform(out, targetNamespace, schemaVersion, dsd, constraintsMap);
                break;
            }
            case UTILITY: {
                if (schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
                    this.schemaGeneratorUtility.transform(out, targetNamespace, schemaVersion, dsd, constraintsMap);
                    break;
                }
                throw new IllegalArgumentException("Can not create utility schema in version '" + (Object)((Object)schemaVersion) + "' only version 2.0 supported");
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Schema generation for format " + (Object)((Object)schema.getBaseDataFormat()));
            }
        }
    }

    @Override
    public void generateCrossSectionalSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, DATA_TYPE schema, String crossSectionalDimensionId, Map<String, Set<String>> constraintsMap) {
        SDMX_SCHEMA schemaVersion = schema.getSchemaVersion();
        if (!(schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_ONE) || schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO) || schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE))) {
            throw new IllegalArgumentException("Invalid DATA_TYPE supplied. Invalid value of: " + (Object)((Object)schema));
        }
        this.schemaGeneratorCompact.transformCrossSectional(out, targetNamespace, schema.getSchemaVersion(), dsd, crossSectionalDimensionId, constraintsMap);
    }
}

