/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstrainedDataKeyBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintDataKeySetBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.util.ObjectUtil;

public class ContentConstraintModel {
    private ContentConstraintBean constraint;
    private DataStructureBean dsd;
    private Date dateFrom;
    private Date dateTo;
    private Map<String, Set<String>> filterConceptValues;
    private Map<String, Set<String>> onlyAllowConceptValues;
    private Map<String, DimensionValues> filterDimensionValueMap;
    private Map<String, DimensionValues> onlyAllowDimensionValueMap;
    private boolean acceptNothing;

    public ContentConstraintModel(ContentConstraintBean constraintBean, DataStructureBean dataStructureBean) {
        this.constraint = constraintBean;
        this.dsd = dataStructureBean;
        this.createFilterMaps();
    }

    public boolean isValidObservation(Observation obs) {
        if (this.acceptNothing) {
            return false;
        }
        if (this.filterKeyValue(obs.getAttributes())) {
            return false;
        }
        if (this.dateFrom != null && this.dateFrom.getTime() > obs.getObsAsTimeDate().getTime()) {
            return false;
        }
        return this.dateTo == null || this.dateTo.getTime() >= obs.getObsAsTimeDate().getTime();
    }

    public boolean isValidKey(Keyable key) {
        Set<SeriesKey> validSeriesForDimension;
        DimensionValues dimValues;
        if (this.acceptNothing) {
            return false;
        }
        if (this.filterKeyValue(key.getKey()) || this.filterKeyValue(key.getAttributes())) {
            return false;
        }
        if (this.onlyAllowDimensionValueMap != null) {
            Set<SeriesKey> validSeries = null;
            for (KeyValue kv : key.getKey()) {
                dimValues = this.onlyAllowDimensionValueMap.get(kv.getConcept());
                validSeriesForDimension = dimValues.getValidSeriesForValue(kv.getCode());
                if (validSeries == null) {
                    validSeries = validSeriesForDimension;
                } else {
                    validSeries.retainAll(validSeriesForDimension);
                }
                if (ObjectUtil.validCollection(validSeries)) continue;
                break;
            }
            if (validSeries.size() == 0) {
                return false;
            }
        }
        if (this.filterDimensionValueMap != null) {
            Set<SeriesKey> invlaidSeries = null;
            for (KeyValue kv : key.getKey()) {
                dimValues = this.filterDimensionValueMap.get(kv.getConcept());
                validSeriesForDimension = dimValues.getValidSeriesForValue(kv.getCode());
                if (invlaidSeries == null) {
                    invlaidSeries = validSeriesForDimension;
                } else {
                    invlaidSeries.retainAll(validSeriesForDimension);
                }
                if (ObjectUtil.validCollection(invlaidSeries)) continue;
                break;
            }
            if (invlaidSeries.size() > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean filterKeyValue(Collection<KeyValue> keyValues) {
        if (this.filterConceptValues != null || this.onlyAllowConceptValues != null) {
            for (KeyValue kv : keyValues) {
                if (!this.filterKeyValue(kv)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterKeyValue(KeyValue kv) {
        boolean filterValBaseOnInclude;
        Set<String> filterValues = null;
        Set<String> keepValues = null;
        if (this.filterConceptValues != null) {
            filterValues = this.filterConceptValues.get(kv.getConcept());
        }
        if (this.onlyAllowConceptValues != null) {
            keepValues = this.onlyAllowConceptValues.get(kv.getConcept());
        }
        boolean filterValBaseOnExclude = filterValues != null && filterValues.contains(kv.getCode());
        boolean bl = filterValBaseOnInclude = keepValues != null && !keepValues.contains(kv.getCode());
        return filterValBaseOnExclude || filterValBaseOnInclude;
    }

    private void createFilterMaps() {
        Set<SeriesKey> seriesKeys;
        if (this.constraint.getIncludedSeriesKeys() != null) {
            if (!ObjectUtil.validCollection(this.constraint.getIncludedSeriesKeys().getConstrainedDataKeys())) {
                this.acceptNothing = true;
            } else {
                seriesKeys = this.createFilteredSeries(this.constraint.getIncludedSeriesKeys());
                if (ObjectUtil.validCollection(seriesKeys)) {
                    this.onlyAllowDimensionValueMap = new HashMap<String, DimensionValues>();
                    for (DimensionBean dim : this.dsd.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                        this.onlyAllowDimensionValueMap.put(dim.getId(), new DimensionValues(dim.getId(), seriesKeys));
                    }
                }
            }
        }
        if (this.constraint.getExcludedSeriesKeys() != null && ObjectUtil.validCollection(seriesKeys = this.createFilteredSeries(this.constraint.getExcludedSeriesKeys()))) {
            this.filterDimensionValueMap = new HashMap<String, DimensionValues>();
            for (DimensionBean dim : this.dsd.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                this.filterDimensionValueMap.put(dim.getId(), new DimensionValues(dim.getId(), seriesKeys));
            }
        }
        if (this.constraint.getExcludedCubeRegion() != null) {
            this.filterConceptValues = new HashMap<String, Set<String>>();
            this.addKeysToConstraint(this.constraint.getExcludedCubeRegion().getKeyValues(), false);
            this.addKeysToConstraint(this.constraint.getExcludedCubeRegion().getAttributeValues(), false);
        }
        if (this.constraint.getIncludedCubeRegion() != null) {
            this.onlyAllowConceptValues = new HashMap<String, Set<String>>();
            this.addKeysToConstraint(this.constraint.getIncludedCubeRegion().getKeyValues(), true);
            this.addKeysToConstraint(this.constraint.getIncludedCubeRegion().getAttributeValues(), true);
        }
        if (this.constraint.getReferencePeriod() != null) {
            if (this.constraint.getReferencePeriod().getStartTime() != null) {
                this.dateFrom = this.constraint.getReferencePeriod().getStartTime().getDate();
            }
            if (this.constraint.getReferencePeriod().getEndTime() != null) {
                this.dateTo = this.constraint.getReferencePeriod().getEndTime().getDate();
            }
        }
    }

    private void addKeysToConstraint(Collection<KeyValues> kvs, boolean isInclude) {
        Map<String, Set<String>> keyValuesSet = isInclude ? this.onlyAllowConceptValues : this.filterConceptValues;
        for (KeyValues currentKeyValues : kvs) {
            String dimensionId = currentKeyValues.getId();
            Set<String> currentAllowValues = keyValuesSet.get(dimensionId);
            if (currentAllowValues == null) {
                currentAllowValues = new HashSet<String>();
                keyValuesSet.put(dimensionId, currentAllowValues);
            }
            currentAllowValues.addAll(currentKeyValues.getValues());
        }
    }

    private Set<SeriesKey> createFilteredSeries(ConstraintDataKeySetBean cdks) {
        HashMap<String, KeyValue> kvs = new HashMap<String, KeyValue>();
        HashSet<SeriesKey> seriesKeys = new HashSet<SeriesKey>();
        for (ConstrainedDataKeyBean dataKey : cdks.getConstrainedDataKeys()) {
            SeriesKey sk = new SeriesKey();
            for (KeyValue kv : dataKey.getKeyValues()) {
                String curKv = kv.getConcept() + ":" + kv.getCode();
                KeyValue skv = (KeyValue)kvs.get(curKv);
                if (skv == null) {
                    skv = kv;
                    kvs.put(curKv, skv);
                }
                sk.addKeyValue(skv);
            }
            seriesKeys.add(sk);
        }
        return seriesKeys;
    }

    private class SeriesKey {
        private List<KeyValue> keyValues = new ArrayList<KeyValue>();
        private Map<String, String> conceptValueMap = new HashMap<String, String>();

        private SeriesKey() {
        }

        private void addKeyValue(KeyValue kv) {
            this.keyValues.add(kv);
            this.conceptValueMap.put(kv.getConcept(), kv.getCode());
        }

        private String getValueForConcept(String dimensionId) {
            return this.conceptValueMap.get(dimensionId);
        }
    }

    private class DimensionValues {
        private String dimensionId;
        private Map<String, Set<SeriesKey>> valueToKey = new HashMap<String, Set<SeriesKey>>();
        private Set<SeriesKey> wildcardedForDimension = new HashSet<SeriesKey>();

        public DimensionValues(String dimensionId, Set<SeriesKey> seriesKeys) {
            this.dimensionId = dimensionId;
            for (SeriesKey sk : seriesKeys) {
                this.addSeriesKey(sk);
            }
        }

        public void addSeriesKey(SeriesKey sk) {
            String dimVal = sk.getValueForConcept(this.dimensionId);
            if (!ObjectUtil.validString(dimVal) || dimVal.equals("*")) {
                this.wildcardedForDimension.add(sk);
            } else {
                Set<SeriesKey> currentSeriesForValue = this.valueToKey.get(dimVal);
                if (currentSeriesForValue == null) {
                    currentSeriesForValue = new HashSet<SeriesKey>();
                    this.valueToKey.put(dimVal, currentSeriesForValue);
                }
                currentSeriesForValue.add(sk);
            }
        }

        public Set<SeriesKey> getValidSeriesForValue(String value) {
            HashSet<SeriesKey> returnSet = new HashSet<SeriesKey>();
            Set<SeriesKey> validSeries = this.valueToKey.get(value);
            if (validSeries != null) {
                returnSet.addAll(validSeries);
            }
            returnSet.addAll(this.wildcardedForDimension);
            return returnSet;
        }
    }
}

