/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.model;

import java.io.Serializable;
import java.util.HashSet;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.model.data.Keyable;

public class DataInformation
implements Serializable {
    private static final long serialVersionUID = 4279234605066137963L;
    private int groups = 0;
    private int keys = 0;
    private int observations = 0;

    public DataInformation(DataReaderEngine dre) {
        if (dre == null) {
            throw new IllegalArgumentException("No DataReaderEngine specified.");
        }
        dre.reset();
        HashSet<String> keySet = new HashSet<String>();
        HashSet<String> groupSet = new HashSet<String>();
        while (dre.moveNextKeyable()) {
            Keyable currentKey = dre.getCurrentKey();
            if (currentKey.isSeries()) {
                keySet.add(currentKey.getShortCode());
            } else {
                groupSet.add(currentKey.getShortCode());
            }
            while (dre.moveNextObservation()) {
                ++this.observations;
            }
        }
        this.keys = keySet.size();
        this.groups = groupSet.size();
    }

    public int getNumberOfSeriesKeys() {
        return this.keys;
    }

    public int getGroups() {
        return this.groups;
    }

    public int getNumberOfObservations() {
        return this.observations;
    }
}

