/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.GroupSuperBean;

public abstract class BaseSchemaGenerator {
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public String COMPACT_NS;
    public String COMMON_NS;
    public String UTILITY_NS;
    public String MESSAGE_NS;
    public static final int COMPACT = 1;
    public static final int UTILITY = 2;
    DataStructureSuperBean keyFamily;
    XMLStreamWriter writer;
    protected String schemaLocation;
    protected Map<String, Set<String>> validCodeMap;

    public BaseSchemaGenerator(Map<String, Set<String>> validCodeMap) {
        this.validCodeMap = validCodeMap;
    }

    void init(OutputStream out, int xsdType, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily) {
        switch (targetSchemaVersion) {
            case VERSION_ONE: {
                this.COMPACT_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/compact";
                this.COMMON_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/common";
                this.UTILITY_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/utility";
                this.MESSAGE_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message";
                break;
            }
            case VERSION_TWO: {
                this.COMPACT_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/compact";
                this.COMMON_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/common";
                this.UTILITY_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/utility";
                this.MESSAGE_NS = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message";
                break;
            }
            case VERSION_TWO_POINT_ONE: {
                this.COMPACT_NS = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/compact";
                this.COMMON_NS = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/common";
                this.UTILITY_NS = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/utility";
                this.MESSAGE_NS = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific";
                break;
            }
            default: {
                throw new ValidationException(ExceptionCode.UNSUPPORTED, new Object[]{targetSchemaVersion});
            }
        }
        if (targetNamespace == null) {
            targetNamespace = "undefined";
        }
        this.keyFamily = keyFamily;
        try {
            XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
            this.writer = xmlOutputfactory.createXMLStreamWriter(out, "UTF-8");
            this.writer.writeStartDocument();
            this.writer.writeStartElement("xs", "schema", SCHEMA_NS);
            if (targetSchemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) {
                this.writer.writeAttribute("xmlns:dsd", "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/data/structurespecific");
            }
            this.writer.writeDefaultNamespace(targetNamespace);
            this.writer.writeNamespace("xs", SCHEMA_NS);
            switch (xsdType) {
                case 1: {
                    this.writer.writeNamespace("compact", this.COMPACT_NS);
                    break;
                }
                case 2: {
                    this.writer.writeNamespace("utility", this.UTILITY_NS);
                }
            }
            this.writer.writeNamespace("common", this.COMMON_NS);
            this.writer.writeNamespace("message", this.MESSAGE_NS);
            this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.writer.writeAttribute("targetNamespace", targetNamespace);
            this.writer.writeAttribute("elementFormDefault", "qualified");
            this.writer.writeAttribute("attributeFormDefault", "unqualified");
            this.writer.writeStartElement(SCHEMA_NS, "import");
            this.writer.writeAttribute("namespace", this.COMMON_NS);
            this.writer.writeAttribute("schemaLocation", this.schemaLocation + "SDMXCommon.xsd");
            this.writer.writeEndElement();
            if (targetSchemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE)) {
                this.writer.writeStartElement(SCHEMA_NS, "import");
                this.writer.writeAttribute("namespace", this.MESSAGE_NS);
                this.writer.writeAttribute("schemaLocation", this.schemaLocation + "SDMXDataStructureSpecific.xsd");
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(SCHEMA_NS, "import");
                switch (xsdType) {
                    case 1: {
                        this.writer.writeAttribute("namespace", this.COMPACT_NS);
                        this.writer.writeAttribute("schemaLocation", this.schemaLocation + "SDMXCompactData.xsd");
                        break;
                    }
                    case 2: {
                        this.writer.writeAttribute("namespace", this.UTILITY_NS);
                        this.writer.writeAttribute("schemaLocation", this.schemaLocation + "SDMXUtilityData.xsd");
                    }
                }
                this.writer.writeEndElement();
                this.writer.writeStartElement(SCHEMA_NS, "import");
                this.writer.writeAttribute("namespace", this.MESSAGE_NS);
                this.writer.writeAttribute("schemaLocation", this.schemaLocation + "SDMXMessage.xsd");
                this.writer.writeEndElement();
            }
            for (ComponentSuperBean csb : keyFamily.getComponents()) {
                if (csb.getCodelist(true) == null) continue;
                this.processCodelist(csb.getId(), csb.getCodelist(true));
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    void writeGroupAttributes(GroupSuperBean group) throws XMLStreamException {
        for (DimensionSuperBean dim : group.getDimensions()) {
            this.writer.writeStartElement(SCHEMA_NS, "attribute");
            this.writer.writeAttribute("name", dim.getConcept().getId());
            if (dim.getCodelist(true) != null) {
                this.writer.writeAttribute("type", this.getCodelistReference(dim.getId(), dim.getCodelist(true).getId()));
            } else {
                this.writer.writeAttribute("type", "xs:String");
            }
            this.writer.writeAttribute("use", "required");
            this.writer.writeEndElement();
        }
        for (AttributeSuperBean bean : this.keyFamily.getGroupAttributes(group.getId())) {
            this.addAttributeBean(bean);
        }
    }

    void addKfComponenet(ComponentSuperBean componentBean) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "attribute");
        this.writer.writeAttribute("name", componentBean.getConcept().getId());
        if (componentBean.getCodelist(true) == null) {
            this.writer.writeAttribute("type", "xs:string");
        } else {
            this.writer.writeAttribute("type", this.getCodelistReference(componentBean.getId(), componentBean.getCodelist(true).getId()));
        }
        if (componentBean instanceof AttributeSuperBean) {
            if (((AttributeSuperBean)componentBean).isMandatory()) {
                this.writer.writeAttribute("use", "required");
            } else {
                this.writer.writeAttribute("use", "optional");
            }
        }
        this.writer.writeEndElement();
    }

    void addAttributeBean(AttributeSuperBean attributeBean) throws XMLStreamException {
        this.addComponentBean(attributeBean);
        if (attributeBean.getAssignmentStatus().equals("Mandatory")) {
            this.writer.writeAttribute("use", "required");
        } else {
            this.writer.writeAttribute("use", "optional");
        }
        this.writer.writeEndElement();
    }

    void addComponentBean(ComponentSuperBean componentBean) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "attribute");
        this.writer.writeAttribute("name", componentBean.getConcept().getId());
        if (componentBean.getBuiltFrom().getStructureType() == SDMX_STRUCTURE_TYPE.TIME_DIMENSION) {
            this.writer.writeAttribute("type", "common:TimePeriodType");
        } else if (componentBean.getCodelist(true) == null) {
            this.writer.writeAttribute("type", "xs:string");
        } else {
            this.writer.writeAttribute("type", this.getCodelistReference(componentBean.getId(), componentBean.getCodelist(true).getId()));
        }
    }

    void addAnnotations() throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "element");
        this.writer.writeAttribute("name", "Annotations");
        this.writer.writeAttribute("type", "common:AnnotationsType");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeEndElement();
    }

    void addChoice(int xsdType, String minOccurs, String maxOccurs) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "choice");
        if (xsdType == 1) {
            this.writer.writeAttribute("minOccurs", minOccurs);
        }
        this.writer.writeAttribute("maxOccurs", maxOccurs);
    }

    void addComplexType(String name, String extensionBaseName) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "complexType");
        this.writer.writeAttribute("name", name);
        this.writer.writeStartElement(SCHEMA_NS, "complexContent");
        this.writer.writeStartElement(SCHEMA_NS, "extension");
        this.writer.writeAttribute("base", extensionBaseName);
    }

    void addComplexTypeForRestriction(String name, String restrictionBaseName) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "complexType");
        this.writer.writeAttribute("name", name);
        this.writer.writeStartElement(SCHEMA_NS, "complexContent");
        this.writer.writeStartElement(SCHEMA_NS, "restriction");
        this.writer.writeAttribute("base", restrictionBaseName);
    }

    void endComplexType(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    void addElement(String name, String type) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "element");
        this.writer.writeAttribute("name", name);
        this.writer.writeAttribute("type", type);
        this.writer.writeEndElement();
    }

    void addElement(String name, String type, String substitutionGroup) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "element");
        this.writer.writeAttribute("name", name);
        this.writer.writeAttribute("type", type);
        if (substitutionGroup != null) {
            this.writer.writeAttribute("substitutionGroup", substitutionGroup);
        }
        this.writer.writeEndElement();
    }

    void addElement(ComponentSuperBean componentBean) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "element");
        this.writer.writeAttribute("name", componentBean.getConcept().getId());
        if (componentBean.getCodelist(true) == null) {
            this.writer.writeAttribute("type", "xs:string");
        } else {
            this.writer.writeAttribute("type", this.getCodelistReference(componentBean.getId(), componentBean.getCodelist(true).getId()));
        }
        if (componentBean instanceof AttributeSuperBean) {
            if (((AttributeSuperBean)componentBean).isMandatory()) {
                this.writer.writeAttribute("use", "required");
            } else {
                this.writer.writeAttribute("use", "optional");
            }
        }
        this.writer.writeEndElement();
    }

    void processCodelist(String componentId, CodelistSuperBean codelist) throws XMLStreamException {
        this.writer.writeStartElement(SCHEMA_NS, "simpleType");
        this.writer.writeAttribute("name", this.getCodelistReference(componentId, codelist.getId()));
        this.writer.writeStartElement(SCHEMA_NS, "restriction");
        this.writer.writeAttribute("base", "xs:string");
        for (CodeSuperBean code : codelist.getCodes()) {
            this.processCode(componentId, code);
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    protected String getCodelistReference(String componentId, String codelistId) {
        return componentId + "_" + codelistId;
    }

    void processCode(String componentId, CodeSuperBean code) throws XMLStreamException {
        Set<String> validCodes;
        boolean validForOutput = true;
        if (this.validCodeMap != null && (validCodes = this.validCodeMap.get(componentId)) != null) {
            validForOutput = validCodes.contains(code.getId());
        }
        if (validForOutput) {
            this.writer.writeStartElement(SCHEMA_NS, "enumeration");
            this.writer.writeAttribute("value", code.getId());
            this.writer.writeStartElement(SCHEMA_NS, "annotation");
            for (Locale locale : code.getDescriptions().keySet()) {
                this.writer.writeStartElement(SCHEMA_NS, "documentation");
                this.writer.writeAttribute("xml:lang", locale.getLanguage());
                this.writer.writeCharacters(code.getDescriptions().get(locale));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        if (code.hasChildren()) {
            for (CodeSuperBean child : code.getChildren()) {
                this.processCode(componentId, child);
            }
        }
    }

    void close() {
        try {
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Error trying to close parser : " + e);
        }
    }
}

