/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.impl.BaseSchemaGenerator;

public abstract class CompactSchemaCreator
extends BaseSchemaGenerator {
    protected OutputStream out;
    protected String targetNamespace;
    protected SDMX_SCHEMA targetSchemaVersion;
    protected DataStructureSuperBean keyFamily;
    protected DimensionSuperBean crossSectionDimension;
    protected boolean generatingCrossSectional;

    public CompactSchemaCreator(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String schemaLocation, Map<String, Set<String>> validCodes) {
        super(validCodes);
        this.out = out;
        if (out == null) {
            throw new IllegalArgumentException("No output stream provided");
        }
        this.targetNamespace = targetNamespace;
        this.targetSchemaVersion = targetSchemaVersion;
        this.keyFamily = keyFamily;
        this.schemaLocation = schemaLocation;
    }

    public CompactSchemaCreator(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String crossSectionDimensionId, String schemaLocation, Map<String, Set<String>> validCodes) {
        this(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes);
        this.crossSectionDimension = keyFamily.getDimensionById(crossSectionDimensionId);
        if (this.crossSectionDimension == null) {
            throw new IllegalArgumentException("The specified cross-section dimension: " + crossSectionDimensionId + " does not exist within the key family: " + keyFamily);
        }
        this.generatingCrossSectional = true;
    }

    public void createSchema() {
        try {
            this.writeSchemaInformation();
            this.writeDataset();
            this.writeGroups();
            this.writeSeries();
            this.writeObservations();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            this.close();
        }
    }

    protected abstract void addComplexContentRoot(String var1, String var2) throws Exception;

    protected abstract void writeSchemaInformation();

    protected abstract void writeDataset() throws Exception;

    protected abstract void writeGroups() throws Exception;

    protected abstract void writeSeries() throws Exception;

    protected abstract void writeObservations() throws Exception;

    protected void addOptionalDimensionBean(ComponentSuperBean dimensionBean) throws XMLStreamException {
        this.addDimensionBean(dimensionBean, "optional");
    }

    protected void addRequiredDimensionBean(ComponentSuperBean dimensionBean) throws XMLStreamException {
        this.addDimensionBean(dimensionBean, "required");
    }

    protected void addProhibitedDimensionBean(ComponentSuperBean dimensionBean) throws XMLStreamException {
        this.addDimensionBean(dimensionBean, "prohibited");
    }

    private void addDimensionBean(ComponentSuperBean dimensionBean, String useageType) throws XMLStreamException {
        this.addComponentBean(dimensionBean);
        this.writer.writeAttribute("use", useageType);
        this.writer.writeEndElement();
    }

    @Override
    void addAttributeBean(AttributeSuperBean attributeBean) throws XMLStreamException {
        this.addComponentBean(attributeBean);
        this.writer.writeAttribute("use", "optional");
        this.writer.writeEndElement();
    }
}

