/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.GroupSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreator;

public class CompactSchemaCreatorSdmx
extends CompactSchemaCreator {
    private static Logger LOG = Logger.getLogger(CompactSchemaCreatorSdmx.class);

    public CompactSchemaCreatorSdmx(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String schemaLocation, Map<String, Set<String>> validCodes) {
        super(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes);
    }

    public CompactSchemaCreatorSdmx(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String crossSectionDimensionId, String schemaLocation, Map<String, Set<String>> validCodes) {
        super(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes);
    }

    @Override
    public void createSchema() {
        LOG.info("Generating Schema: " + (Object)((Object)this.targetSchemaVersion) + (this.generatingCrossSectional ? " - cross sectional" : ""));
        super.createSchema();
    }

    @Override
    protected void writeSchemaInformation() {
        this.init(this.out, 1, this.targetNamespace, this.targetSchemaVersion, this.keyFamily);
    }

    @Override
    protected void writeDataset() throws Exception {
        this.addElement("DataSet", "DataSetType", "compact:DataSet");
        this.addComplexContentRoot("DataSetType", "TimeSeriesDataSetType");
        this.addChoice(1, "0", "unbounded");
        for (GroupSuperBean groupSuperBean : this.keyFamily.getGroups()) {
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
            this.writer.writeAttribute("ref", groupSuperBean.getId());
            this.writer.writeEndElement();
        }
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("ref", "Series");
        this.writer.writeEndElement();
        this.addAnnotations();
        this.writer.writeEndElement();
        for (DimensionSuperBean dimensionSuperBean : this.keyFamily.getDimensions()) {
            this.addOptionalDimensionBean(dimensionSuperBean);
        }
        for (AttributeSuperBean attributeSuperBean : this.keyFamily.getDatasetAttributes()) {
            this.addAttributeBean(attributeSuperBean);
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void writeGroups() throws Exception {
        for (GroupSuperBean currentGroup : this.keyFamily.getGroups()) {
            this.addElement(currentGroup.getId(), currentGroup.getId() + "Type", "compact:Group");
            this.addComplexType(currentGroup.getId() + "Type", "compact:GroupType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            this.addAnnotations();
            this.writer.writeEndElement();
            this.writeGroupAttributes(currentGroup);
            this.endComplexType(this.writer);
        }
    }

    @Override
    protected void writeSeries() throws Exception {
        this.addElement("Series", "SeriesType", "compact:Series");
        this.addComplexContentRoot("SeriesType", "TimeSeriesType");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("ref", "Obs");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeAttribute("maxOccurs", "unbounded");
        this.writer.writeEndElement();
        this.addAnnotations();
        this.writer.writeEndElement();
        for (DimensionSuperBean dimensionSuperBean : this.keyFamily.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.TIME_DIMENSION)) {
            this.addOptionalDimensionBean(dimensionSuperBean);
        }
        for (AttributeSuperBean attributeSuperBean : this.keyFamily.getSeriesAttributes()) {
            this.addComponentBean(attributeSuperBean);
            this.writer.writeAttribute("use", "optional");
            this.writer.writeEndElement();
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void writeObservations() throws Exception {
        this.addElement("Obs", "ObsType", "compact:Obs");
        this.addComplexContentRoot("ObsType", "TimeSeriesObsType");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
        this.addAnnotations();
        this.writer.writeEndElement();
        if (this.generatingCrossSectional) {
            this.addRequiredDimensionBean(this.crossSectionDimension);
        }
        if (this.keyFamily.getPrimaryMeasure() != null) {
            this.addOptionalDimensionBean(this.keyFamily.getPrimaryMeasure());
        }
        if (this.keyFamily.getTimeDimension() != null) {
            this.addOptionalDimensionBean(this.keyFamily.getTimeDimension());
        }
        for (AttributeSuperBean bean : this.keyFamily.getObservationAttributes()) {
            this.addComponentBean(bean);
            this.writer.writeAttribute("use", "optional");
            this.writer.writeEndElement();
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void addComplexContentRoot(String type, String type_2_1) throws Exception {
        this.addComplexType(type, "compact:" + type);
    }
}

