/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.GroupSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreator;

public class CompactSchemaCreatorSdmx2_1
extends CompactSchemaCreator {
    private static Logger LOG = Logger.getLogger(CompactSchemaCreatorSdmx2_1.class);

    public CompactSchemaCreatorSdmx2_1(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String schemaLocation, Map<String, Set<String>> validCodes) {
        super(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes);
    }

    public CompactSchemaCreatorSdmx2_1(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String crossSectionDimensionId, String schemaLocation, Map<String, Set<String>> validCodes) {
        super(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes);
    }

    @Override
    public void createSchema() {
        LOG.info("Generating Schema: SDMX 2.1 " + (this.generatingCrossSectional ? " - cross sectional" : ""));
        super.createSchema();
    }

    @Override
    protected void writeSchemaInformation() {
        DimensionSuperBean timeDimensionBean;
        this.targetNamespace = this.generatingCrossSectional ? this.crossSectionDimension.getUrn() : ((timeDimensionBean = this.keyFamily.getTimeDimension()) == null ? this.keyFamily.getPrimaryMeasure().getUrn() : this.keyFamily.getTimeDimension().getUrn());
        this.init(this.out, 1, this.targetNamespace, this.targetSchemaVersion, this.keyFamily);
    }

    @Override
    protected void writeDataset() throws Exception {
        this.addElement("DataSet", "DataSetType", "compact:DataSet");
        this.addComplexContentRoot("DataSetType", "TimeSeriesDataSetType");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
        this.addAnnotations();
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("name", "DataProvider");
        this.writer.writeAttribute("type", "common:DataProviderReferenceType");
        this.writer.writeAttribute("form", "unqualified");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeEndElement();
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "choice");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("name", "Series");
        this.writer.writeAttribute("type", "SeriesType");
        this.writer.writeAttribute("form", "unqualified");
        this.writer.writeAttribute("maxOccurs", "unbounded");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        for (AttributeSuperBean bean : this.keyFamily.getDatasetAttributes()) {
            this.addAttributeBean(bean);
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void writeGroups() throws Exception {
        for (GroupSuperBean currentGroup : this.keyFamily.getGroups()) {
            this.addElement(currentGroup.getId(), currentGroup.getId() + "Type", "compact:Group");
            this.addComplexTypeForRestriction(currentGroup.getId() + "Type", "dsd:GroupType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            this.addAnnotations();
            this.writer.writeEndElement();
            this.writeGroupAttributes(currentGroup);
            this.endComplexType(this.writer);
        }
    }

    @Override
    protected void writeSeries() throws Exception {
        this.addElement("Series", "SeriesType", "compact:Series");
        this.addComplexContentRoot("SeriesType", "TimeSeriesType");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
        this.addAnnotations();
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("name", "Obs");
        this.writer.writeAttribute("type", "ObsType");
        this.writer.writeAttribute("form", "unqualified");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeAttribute("maxOccurs", "unbounded");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        if (this.generatingCrossSectional) {
            for (DimensionSuperBean dimensionSuperBean : this.keyFamily.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.TIME_DIMENSION)) {
                if (dimensionSuperBean.getId().equals(this.crossSectionDimension.getId())) continue;
                this.addRequiredDimensionBean(dimensionSuperBean);
            }
        } else {
            for (DimensionSuperBean dimensionSuperBean : this.keyFamily.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                this.addOptionalDimensionBean(dimensionSuperBean);
            }
        }
        for (AttributeSuperBean attributeSuperBean : this.keyFamily.getSeriesAttributes()) {
            this.addComponentBean(attributeSuperBean);
            this.writer.writeAttribute("use", "optional");
            this.writer.writeEndElement();
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void writeObservations() throws Exception {
        this.addElement("Obs", "ObsType", "compact:Obs");
        this.addComplexContentRoot("ObsType", "TimeSeriesObsType");
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
        this.addAnnotations();
        this.writer.writeEndElement();
        if (this.generatingCrossSectional) {
            this.addRequiredDimensionBean(this.crossSectionDimension);
        }
        if (this.keyFamily.getPrimaryMeasure() != null) {
            this.addOptionalDimensionBean(this.keyFamily.getPrimaryMeasure());
        }
        for (AttributeSuperBean bean : this.keyFamily.getObservationAttributes()) {
            this.addComponentBean(bean);
            this.writer.writeAttribute("use", "optional");
            this.writer.writeEndElement();
        }
        if (this.generatingCrossSectional && this.keyFamily.getTimeDimension() != null) {
            this.addProhibitedDimensionBean(this.keyFamily.getTimeDimension());
        }
        this.endComplexType(this.writer);
    }

    @Override
    protected void addComplexContentRoot(String type, String type_2_1) throws Exception {
        String complexType = this.generatingCrossSectional ? type : type_2_1;
        this.addComplexTypeForRestriction(type, "dsd:" + complexType);
    }

    @Override
    void addElement(String name, String type, String substitutionGroup) throws XMLStreamException {
        super.addElement(name, type, null);
    }

    @Override
    void addComponentBean(ComponentSuperBean componentBean) throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "attribute");
        this.writer.writeAttribute("name", componentBean.getConcept().getId());
        if (componentBean.getBuiltFrom().getStructureType() == SDMX_STRUCTURE_TYPE.TIME_DIMENSION) {
            this.writer.writeAttribute("type", "common:ObservationalTimePeriodType");
        } else if (componentBean.getCodelist(true) == null) {
            this.writer.writeAttribute("type", "xs:string");
        } else {
            this.writer.writeAttribute("type", this.getCodelistReference(componentBean.getId(), componentBean.getCodelist(true).getId()));
        }
    }

    @Override
    void addAnnotations() throws XMLStreamException {
        this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
        this.writer.writeAttribute("ref", "common:Annotations");
        this.writer.writeAttribute("minOccurs", "0");
        this.writer.writeEndElement();
    }
}

