/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.dataparser.transform.DataReaderWriterTransform;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.springframework.stereotype.Component;

@Component
public class DataReaderWriterTransformImpl
implements DataReaderWriterTransform {
    private void pivot(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension) {
        HashMap outputMap = new HashMap();
        DatasetHeaderBean datasetHeader = dataReaderEngine.getCurrentDatasetHeaderBean();
        String currentCrossSectionConcept = datasetHeader.getDataStructureReference().getDimensionAtObservation();
        boolean pivotIsTime = pivotDimension.equals("TIME_PERIOD");
        boolean fromIsTimeSeries = datasetHeader.isTimeSeries();
        DataStructureBean keyFamily = dataReaderEngine.getDataStructure();
        List<String> seriesAttributeConcepts = null;
        List<String> obsAttributeConcepts = null;
        if (keyFamily != null) {
            seriesAttributeConcepts = this.getSeriesAttributes(pivotDimension, keyFamily);
            obsAttributeConcepts = this.getObsAttributes(pivotDimension, keyFamily);
        }
        HashSet<String> shortCodes = new HashSet<String>();
        HashMap<String, Keyable> keyMap = new HashMap<String, Keyable>();
        HashMap<String, HashSet<ObservationImpl>> obsMap = new HashMap<String, HashSet<ObservationImpl>>();
        while (dataReaderEngine.moveNextKeyable()) {
            String codeForPivot;
            Keyable key = dataReaderEngine.getCurrentKey();
            if (!key.isSeries()) {
                this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, key, 0);
                continue;
            }
            String string = codeForPivot = pivotIsTime ? key.getObsTime() : key.getKeyValue(pivotDimension);
            while (dataReaderEngine.moveNextObservation()) {
                Observation obs = dataReaderEngine.getCurrentObservation();
                String currentObsCode = fromIsTimeSeries ? obs.getObsTime() : obs.getCrossSectionalValue().getCode();
                String newKeyShortCode = this.getKeyShortCode(key, currentObsCode, pivotDimension);
                HashSet<ObservationImpl> observations = (HashSet<ObservationImpl>)obsMap.get(newKeyShortCode);
                if (!shortCodes.contains(newKeyShortCode)) {
                    shortCodes.add(newKeyShortCode);
                    keyMap.put(newKeyShortCode, this.createNewKey(key, pivotDimension, currentCrossSectionConcept, currentObsCode, pivotIsTime, fromIsTimeSeries, seriesAttributeConcepts));
                    observations = new HashSet<ObservationImpl>();
                    obsMap.put(newKeyShortCode, observations);
                }
                observations.add(new ObservationImpl(codeForPivot, obs.getObservationValue(), obs.getAttributes()));
            }
        }
        for (String currentKey : keyMap.keySet()) {
            Keyable key = (Keyable)keyMap.get(currentKey);
            this.writeKeyableToWriter(dataWriterEngine, (Keyable)keyMap.get(currentKey));
            for (Observation obs : (Set)obsMap.get(currentKey)) {
                this.writeObsToWriter(dataWriterEngine, key, obs);
            }
        }
    }

    private String getKeyShortCode(Keyable currentKey, String promoteCode, String ignoreConcept) {
        String returnString = "";
        for (KeyValue kv : currentKey.getKey()) {
            if (kv.getConcept().equals(ignoreConcept)) continue;
            returnString = returnString + kv.getCode() + ":";
        }
        returnString = returnString + promoteCode;
        return returnString;
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean copyHeader, boolean closeWriter) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, null, includeObs, -1, null, null, copyHeader, closeWriter);
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, boolean includeHeader, boolean closeOnCompletion) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, null, true, -1, null, null, includeHeader, closeOnCompletion);
    }

    @Override
    public void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean closeOnCompletion) {
        this.copyToWriter(dataReaderEngine, dataWriterEngine, pivotDimension, true, -1, null, null, true, closeOnCompletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyDatasetToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean includeHeader, boolean closeOnCompletion) {
        block16: {
            try {
                if (includeHeader && dataReaderEngine.getHeader() != null) {
                    dataWriterEngine.writeHeader(dataReaderEngine.getHeader());
                }
                DatasetHeaderBean datasetHeader = dataReaderEngine.getCurrentDatasetHeaderBean();
                boolean fromIsTimeSeries = datasetHeader.isTimeSeries();
                String dimensionAtObs = datasetHeader.getDataStructureReference().getDimensionAtObservation();
                if (pivotDimension == null || fromIsTimeSeries && pivotDimension.equals("TIME_PERIOD") || dimensionAtObs.equals(pivotDimension)) {
                    dataWriterEngine.startDataset(dataReaderEngine.getDataStructure(), datasetHeader);
                    Keyable currentKey = null;
                    while (true) {
                        try {
                            if (!dataReaderEngine.moveNextKeyable()) {
                                break block16;
                            }
                            currentKey = dataReaderEngine.getCurrentKey();
                        }
                        catch (Throwable th) {
                            if (currentKey == null) {
                                throw new ValidationException(th, "Error while trying read first series key");
                            }
                            throw new ValidationException(th, "Error while trying to read next series/group in the DataSet.  The last sucessfully processed key was: " + currentKey);
                        }
                        try {
                            if (includeObs) {
                                this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, currentKey, maxObs, dateFrom, dateTo);
                                continue;
                            }
                            this.writeKeyableToWriter(dataWriterEngine, currentKey);
                        }
                        catch (Throwable th) {
                            throw new ValidationException(th, "Error occurred while processing " + currentKey);
                        }
                    }
                }
                String dsId = null;
                StructureReferenceBean structureRef = null;
                String serviceURL = null;
                String structureURL = null;
                if (datasetHeader.getDataStructureReference() != null) {
                    dsId = datasetHeader.getDataStructureReference().getId();
                    structureRef = datasetHeader.getDataStructureReference().getStructureReference();
                    serviceURL = datasetHeader.getDataStructureReference().getServiceURL();
                    structureURL = datasetHeader.getDataStructureReference().getStructureURL();
                } else {
                    structureRef = dataReaderEngine.getDataStructure().asReference();
                }
                DatasetStructureReferenceBeanImpl dsStructureRef = new DatasetStructureReferenceBeanImpl(dsId, structureRef, serviceURL, structureURL, pivotDimension);
                DatasetHeaderBean modifiedDatasetHeader = datasetHeader.modifyDataStructureReference(dsStructureRef);
                dataWriterEngine.startDataset(dataReaderEngine.getDataStructure(), modifiedDatasetHeader);
                this.pivot(dataReaderEngine, dataWriterEngine, pivotDimension);
            }
            finally {
                if (closeOnCompletion) {
                    dataWriterEngine.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, String pivotDimension, boolean includeObs, Integer maxObs, Date dateFrom, Date dateTo, boolean includeHeader, boolean closeOnCompletion) {
        dataReaderEngine.reset();
        HeaderBean header = dataReaderEngine.getHeader();
        if (includeHeader && header != null) {
            dataWriterEngine.writeHeader(header);
        }
        try {
            while (dataReaderEngine.moveNextDataset()) {
                this.copyDatasetToWriter(dataReaderEngine, dataWriterEngine, pivotDimension, includeObs, maxObs, dateFrom, dateTo, false, false);
            }
        }
        finally {
            if (closeOnCompletion) {
                dataWriterEngine.close();
            }
        }
    }

    private List<String> getSeriesAttributes(String pivotDimension, DataStructureBean keyFamily) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (AttributeBean currentAttribute : keyFamily.getSeriesAttributes(pivotDimension)) {
            returnList.add(currentAttribute.getId());
        }
        return returnList;
    }

    private List<String> getObsAttributes(String pivotDimension, DataStructureBean keyFamily) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (AttributeBean currentAttribute : keyFamily.getObservationAttributes(pivotDimension)) {
            returnList.add(currentAttribute.getId());
        }
        return returnList;
    }

    private Keyable createNewKey(Keyable keyable, String ignoreConcept, String includeNewConcept, String newConceptValue, boolean movingToTimeSeries, boolean movingFromTimeSeries, List<String> seriesAttributeConcepts) {
        List<KeyValue> newKeyList = keyable.getKey();
        KeyValue removeKv = null;
        for (KeyValue kv : keyable.getKey()) {
            if (!kv.getConcept().equals(ignoreConcept)) continue;
            removeKv = kv;
            break;
        }
        ArrayList<KeyValue> newAttList = new ArrayList<KeyValue>();
        for (KeyValue currentAttr : keyable.getAttributes()) {
            if (!seriesAttributeConcepts.contains(currentAttr.getConcept())) continue;
            newAttList.add(currentAttr);
        }
        newKeyList.remove(removeKv);
        if (movingToTimeSeries) {
            newKeyList.add(new KeyValueImpl(keyable.getObsTime(), "TIME_PERIOD"));
        } else {
            newKeyList.add(new KeyValueImpl(newConceptValue, includeNewConcept));
        }
        return new KeyableImpl(newKeyList, newAttList, null, null);
    }

    @Override
    public void writeKeyableToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, Keyable keyable, Integer maxObs, Date dateFrom, Date dateTo) {
        boolean seriesKeysOnly;
        boolean writtenKey = false;
        boolean filteredObs = false;
        String fromDateFormatted = null;
        String toDateFormatted = null;
        boolean bl = seriesKeysOnly = maxObs != null && maxObs == 0;
        if (keyable.isSeries() && !seriesKeysOnly) {
            boolean hasMax = maxObs != null && maxObs > 0;
            ArrayList<Observation> obsList = new ArrayList<Observation>();
            Observation obs = null;
            while (true) {
                TIME_FORMAT format;
                try {
                    if (!dataReaderEngine.moveNextObservation()) {
                        break;
                    }
                }
                catch (Throwable th) {
                    if (obs == null) {
                        throw new ValidationException(th, "Error occurred whilst trying to read frist observation in key");
                    }
                    throw new ValidationException(th, "Error occurred whilst trying to determine if series key had another observation, last successfully processed observation: " + obs);
                }
                obs = dataReaderEngine.getCurrentObservation();
                if (dateFrom != null) {
                    if (fromDateFormatted == null) {
                        format = obs.getObsTimeFormat();
                        fromDateFormatted = DateUtil.formatDate(dateFrom, format);
                    }
                    if (obs.getObsTime().compareTo(fromDateFormatted) < 0) {
                        filteredObs = true;
                        continue;
                    }
                }
                if (dateTo != null) {
                    if (toDateFormatted == null) {
                        format = obs.getObsTimeFormat();
                        toDateFormatted = DateUtil.formatDate(dateTo, format);
                    }
                    if (obs.getObsTime().compareTo(toDateFormatted) > 0) {
                        filteredObs = true;
                        continue;
                    }
                }
                if (!writtenKey) {
                    this.writeKeyableToWriter(dataWriterEngine, keyable);
                    writtenKey = true;
                }
                if (!hasMax) {
                    this.writeObsToWriter(dataWriterEngine, keyable, obs);
                    continue;
                }
                obsList.add(obs);
            }
            if (obsList.size() > 0) {
                Collections.sort(obsList);
                Collections.reverse(obsList);
                int loopCount = obsList.size() > maxObs ? maxObs.intValue() : obsList.size();
                for (int i = 0; i < loopCount; ++i) {
                    this.writeObsToWriter(dataWriterEngine, keyable, (Observation)obsList.get(i));
                }
            }
            if (!filteredObs && !writtenKey) {
                this.writeKeyableToWriter(dataWriterEngine, keyable);
            }
        } else {
            this.writeKeyableToWriter(dataWriterEngine, keyable);
        }
    }

    @Override
    public void writeObsToWriter(DataWriterEngine dataWriterEngine, Keyable keyable, Observation obs) {
        if (obs.isCrossSection()) {
            KeyValue crossSection = obs.getCrossSectionalValue();
            if (crossSection == null) {
                throw new ValidationException("Dataset is cross sectional, missing cross section value for observation at time '" + keyable.getObsTime());
            }
            dataWriterEngine.writeObservation(crossSection.getCode(), obs.getObservationValue());
        } else {
            dataWriterEngine.writeObservation(obs.getObsTime(), obs.getObservationValue());
        }
        if (obs.getAttributes() != null) {
            for (KeyValue kv : obs.getAttributes()) {
                dataWriterEngine.writeAttributeValue(kv.getConcept(), kv.getCode());
            }
        }
    }

    private void writeKeyableToWriter(DataWriterEngine dataWriterEngine, Keyable keyable) {
        if (keyable.isSeries()) {
            dataWriterEngine.startSeries();
            for (KeyValue kv : keyable.getKey()) {
                dataWriterEngine.writeSeriesKeyValue(kv.getConcept(), kv.getCode());
            }
            if (!keyable.isTimeSeries()) {
                if (keyable.getObsTime() == null) {
                    throw new ValidationException("Dataset is cross sectional, cross section is missing a time");
                }
                dataWriterEngine.writeSeriesKeyValue("TIME_PERIOD", keyable.getObsTime());
            }
        } else {
            dataWriterEngine.startGroup(keyable.getGroupName());
            for (KeyValue kv : keyable.getKey()) {
                dataWriterEngine.writeGroupKeyValue(kv.getConcept(), kv.getCode());
            }
        }
        if (keyable.getAttributes() != null) {
            for (KeyValue kv : keyable.getAttributes()) {
                dataWriterEngine.writeAttributeValue(kv.getConcept(), kv.getCode());
            }
        }
    }

    @Override
    public void writeKeyableToWriter(DataReaderEngine dataReaderEngine, DataWriterEngine dataWriterEngine, Keyable keyable, Integer maxObs) {
        this.writeKeyableToWriter(dataReaderEngine, dataWriterEngine, keyable, maxObs, null, null);
    }
}

