/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.SchemaGenerator;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreator;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreatorSdmx;
import org.sdmxsource.sdmx.dataparser.transform.impl.CompactSchemaCreatorSdmx2_1;
import org.springframework.beans.factory.annotation.Required;

public class SchemaGeneratorCompact
implements SchemaGenerator {
    private Map<SDMX_SCHEMA, String> schemaLocationMap;

    @Override
    public void transform(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, Map<String, Set<String>> validCodes) {
        String schemaLocation = this.obtainSchemaLocation(targetSchemaVersion);
        CompactSchemaCreator creator = targetSchemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE) ? new CompactSchemaCreatorSdmx2_1(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes) : new CompactSchemaCreatorSdmx(out, targetNamespace, targetSchemaVersion, keyFamily, schemaLocation, validCodes);
        creator.createSchema();
    }

    public void transformCrossSectional(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, String crossSectionDimensionId, Map<String, Set<String>> validCodes) {
        String schemaLocation = this.obtainSchemaLocation(targetSchemaVersion);
        CompactSchemaCreator creator = targetSchemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE) ? new CompactSchemaCreatorSdmx2_1(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes) : new CompactSchemaCreatorSdmx(out, targetNamespace, targetSchemaVersion, keyFamily, crossSectionDimensionId, schemaLocation, validCodes);
        creator.createSchema();
    }

    private String obtainSchemaLocation(SDMX_SCHEMA targetSchemaVersion) {
        String schemaLocation = this.schemaLocationMap.get((Object)targetSchemaVersion);
        if (schemaLocation == null) {
            throw new IllegalArgumentException("The supplied schema version is invalid or else the Map for SchemaGeneratorCompact has not been instantiated correctly! Target schema: " + (Object)((Object)targetSchemaVersion));
        }
        return schemaLocation;
    }

    @Required
    public void setSchemaLocationMap(Map<SDMX_SCHEMA, String> schmaLocationMap) {
        this.schemaLocationMap = schmaLocationMap;
    }
}

