/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.transform.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.GroupSuperBean;
import org.sdmxsource.sdmx.dataparser.transform.SchemaGenerator;
import org.sdmxsource.sdmx.dataparser.transform.impl.BaseSchemaGenerator;
import org.springframework.stereotype.Service;

@Service
public class SchemaGeneratorUtility
extends BaseSchemaGenerator
implements SchemaGenerator {
    public SchemaGeneratorUtility() {
        super(null);
    }

    @Override
    public void transform(OutputStream out, String targetNamespace, SDMX_SCHEMA targetSchemaVersion, DataStructureSuperBean keyFamily, Map<String, Set<String>> validCodes) {
        this.validCodeMap = validCodes;
        if (out == null) {
            throw new IllegalArgumentException("No output stream provided");
        }
        try {
            this.init(out, 2, targetNamespace, targetSchemaVersion, keyFamily);
            this.addElement("DataSet", "DataSetType", "utility:DataSet");
            this.addComplexType("DataSetType", "utility:DataSetType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            this.addChoice(2, "", "unbounded");
            for (GroupSuperBean groupSuperBean : keyFamily.getGroups()) {
                this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
                this.writer.writeAttribute("ref", groupSuperBean.getId());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
            this.writer.writeAttribute("ref", "Series");
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.addAnnotations();
            this.writer.writeEndElement();
            for (AttributeSuperBean attributeSuperBean : keyFamily.getDatasetAttributes()) {
                this.addKfComponenet(attributeSuperBean);
            }
            this.endComplexType(this.writer);
            for (GroupSuperBean groupSuperBean : keyFamily.getGroups()) {
                this.addElement(groupSuperBean.getId(), groupSuperBean.getId() + "Type", "utility:Group");
                this.addComplexType(groupSuperBean.getId() + "Type", "utility:GroupType");
                this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
                this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
                this.writer.writeAttribute("ref", "Series");
                this.writer.writeAttribute("maxOccurs", "unbounded");
                this.writer.writeEndElement();
                this.addAnnotations();
                this.writer.writeEndElement();
                this.writeGroupAttributes(groupSuperBean);
                this.endComplexType(this.writer);
            }
            this.addElement("Series", "SeriesType", "utility:Series");
            this.addComplexType("SeriesType", "utility:SeriesType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
            this.writer.writeAttribute("ref", "Key");
            this.writer.writeEndElement();
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "element");
            this.writer.writeAttribute("ref", "Obs");
            this.writer.writeAttribute("maxOccurs", "unbounded");
            this.writer.writeEndElement();
            this.addAnnotations();
            this.writer.writeEndElement();
            for (AttributeSuperBean attributeSuperBean : keyFamily.getSeriesAttributes()) {
                this.addKfComponenet(attributeSuperBean);
            }
            this.endComplexType(this.writer);
            this.addElement("Key", "KeyType", "utility:Key");
            this.addComplexType("KeyType", "utility:KeyType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            for (DimensionSuperBean dimensionSuperBean : keyFamily.getDimensions()) {
                this.addElement(dimensionSuperBean);
            }
            this.writer.writeEndElement();
            this.endComplexType(this.writer);
            this.addElement("Obs", "ObsType", "utility:Obs");
            this.addComplexType("ObsType", "utility:ObsType");
            this.writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "sequence");
            if (keyFamily.getTimeDimension() != null) {
                this.addElement(keyFamily.getTimeDimension());
            }
            if (keyFamily.getPrimaryMeasure() != null) {
                this.addElement(keyFamily.getPrimaryMeasure());
            }
            this.addAnnotations();
            this.writer.writeEndElement();
            for (AttributeSuperBean attributeSuperBean : keyFamily.getObservationAttributes()) {
                this.addKfComponenet(attributeSuperBean);
            }
            this.endComplexType(this.writer);
            this.writer.writeEndElement();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            this.close();
        }
    }
}

