/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.writer.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.EDI_TIME_FORMAT;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.engine.writer.EDIDataWriterEngine;
import org.sdmxsource.sdmx.ediparser.model.impl.InterchangeHeader;
import org.sdmxsource.sdmx.ediparser.model.impl.MessageIdentification;
import org.sdmxsource.sdmx.ediparser.util.EDIDataWriterUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.io.WriteableDataLocationTmp;

public class EDIDataWriterEngineImpl
implements EDIDataWriterEngine {
    private static int DATASET_ID = 1;
    private PrintWriter writer;
    private DataStructureBean dsd;
    private HeaderBean headerBean;
    private int numLines;
    private int numMessages;
    private InterchangeHeader header;
    private MessageIdentification messageId;
    private WriteableDataLocation tmpAttributeFileDataset;
    private WriteableDataLocation tmpAttributeFileSeries;
    private WriteableDataLocation tmpAttributeFileObs;
    private PrintWriter datasetAttributeWriter;
    private PrintWriter seriesAttributeWriter;
    private PrintWriter obsAttributeWriter;
    private String currentSeriesKey = "";
    private String currentAttributeKey = null;
    private Date currentObsStartDate;
    private Date currentObsEndDate;
    private Map<AttributeBean, AttributeKeyCreator> seriesAttributeKeyCreator = new HashMap<AttributeBean, AttributeKeyCreator>();
    private Map<String, Date> dateMap = new HashMap<String, Date>();
    private Map<String, TIME_FORMAT> timeFormatMap = new HashMap<String, TIME_FORMAT>();
    private Map<String, String> dateValues = new HashMap<String, String>();
    private Map<TIME_FORMAT, DateIterations> dateIterationsMap = new HashMap<TIME_FORMAT, DateIterations>();
    private String currentObsTime;
    private String currentObsValue = "-";
    private String currentObsStatus = "";
    private String currentObsConf = "";
    private String currentObsPreBreak = "";
    private static final int MAX_MISSING = 3;
    private boolean hasAttributes;
    private TIME_FORMAT timeFormat;
    private Date currentObsDate;
    private Map<String, String> keyValues = new HashMap<String, String>();
    private List<String> dimensionIds = new ArrayList<String>();
    private POSITION currentPOS = POSITION.DATASET;
    private boolean headerWritten = false;
    private DatasetHeaderBean currentDatasetHeader;
    private Map<String, String> bufferedAttributes = new TreeMap<String, String>();

    public EDIDataWriterEngineImpl(OutputStream out) {
        ++DATASET_ID;
        this.writer = new PrintWriter(out);
    }

    private PrintWriter getAttributeWriter() {
        switch (this.currentPOS) {
            case DATASET: {
                if (this.datasetAttributeWriter == null) {
                    this.tmpAttributeFileDataset = new WriteableDataLocationTmp();
                    this.datasetAttributeWriter = new PrintWriter(this.tmpAttributeFileDataset.getOutputStream());
                    this.datasetAttributeWriter.println(EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET));
                }
                return this.datasetAttributeWriter;
            }
            case OBS: {
                if (this.obsAttributeWriter == null) {
                    this.tmpAttributeFileObs = new WriteableDataLocationTmp();
                    this.obsAttributeWriter = new PrintWriter(this.tmpAttributeFileObs.getOutputStream());
                    this.obsAttributeWriter.println(EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION));
                }
                return this.obsAttributeWriter;
            }
        }
        if (this.seriesAttributeWriter == null) {
            this.tmpAttributeFileSeries = new WriteableDataLocationTmp();
            this.seriesAttributeWriter = new PrintWriter(this.tmpAttributeFileSeries.getOutputStream());
            this.seriesAttributeWriter.println(EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP));
        }
        return this.seriesAttributeWriter;
    }

    @Override
    public void writeHeader(HeaderBean header) {
        if (this.headerWritten) {
            throw new ValidationException("Can not write header as message has already been started");
        }
        this.headerBean = header;
    }

    private void startMessage() {
        if (!this.headerWritten) {
            this.headerWritten = true;
            String senderId = "undefined";
            String receiverId = null;
            Date preparedDate = new Date();
            String iref = null;
            if (this.headerBean != null) {
                if (this.headerBean.getId() != null) {
                    iref = this.headerBean.getId();
                }
                if (this.headerBean.getSender() != null) {
                    senderId = this.headerBean.getSender().getId();
                }
                if (this.headerBean.getReceiver().size() > 0) {
                    receiverId = this.headerBean.getReceiver().get(0).getId();
                }
                if (this.headerBean.getPrepared() != null) {
                    preparedDate = this.headerBean.getPrepared();
                }
            }
            InterchangeHeader header = iref == null ? new InterchangeHeader(senderId, receiverId, preparedDate, DATASET_ID, null) : new InterchangeHeader(senderId, receiverId, preparedDate, iref, DATASET_ID, null);
            this.writeInterchangeAdministration(header);
        }
    }

    @Override
    public void startDataset(DataStructureBean dsd, DatasetHeaderBean datasetHeader) {
        this.flushCurrentDataset();
        if (dsd == null) {
            throw new IllegalArgumentException("Can not start EDI dataset, data structure definition not provided");
        }
        if (!this.headerWritten) {
            this.startMessage();
        }
        this.currentDatasetHeader = datasetHeader;
        if (this.currentDatasetHeader == null) {
            this.currentDatasetHeader = new DatasetHeaderBeanImpl(dsd.getId(), DATASET_ACTION.APPEND, new DatasetStructureReferenceBeanImpl(dsd.asReference()));
        }
        this.dsd = dsd;
        this.dimensionIds = new ArrayList<String>();
        this.seriesAttributeKeyCreator = new HashMap<AttributeBean, AttributeKeyCreator>();
        for (DimensionBean currentDim : dsd.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
            this.dimensionIds.add(currentDim.getId());
        }
        for (AttributeBean attribute : dsd.getSeriesAttributes(null)) {
            this.seriesAttributeKeyCreator.put(attribute, new AttributeKeyCreator(attribute));
        }
        ++DATASET_ID;
        MessageIdentification identification = new MessageIdentification(1);
        this.writeMessageIdentification(identification);
        this.writeMessageFunction(MESSSAGE_FUNCTION.STATISTICAL_DATA);
        this.writeStructureMaintAgency(dsd.getAgencyId());
        String sender = "sender";
        String receiver = "receiver";
        String datasetId = this.currentDatasetHeader.getDatasetId();
        String reportingPeriod = null;
        if (this.headerBean != null) {
            if (this.headerBean.getSender() != null) {
                sender = this.headerBean.getSender().getId();
            }
            if (this.headerBean.getReceiver() != null) {
                receiver = this.headerBean.getReceiver().get(0).getId();
            }
            if (datasetId == null && ObjectUtil.validString(this.headerBean.getDatasetId())) {
                datasetId = this.headerBean.getDatasetId();
            }
            if (datasetId == null && ObjectUtil.validString(this.headerBean.getId())) {
                datasetId = this.headerBean.getId();
            }
            if (this.currentDatasetHeader.getReportingBeginDate() != null && this.currentDatasetHeader.getReportingEndDate() != null) {
                reportingPeriod = EDIDataWriterUtil.parseReportingPeriodDate(this.currentDatasetHeader.getReportingBeginDate(), this.currentDatasetHeader.getReportingEndDate());
            } else if (this.headerBean.getReportingBegin() != null && this.headerBean.getReportingEnd() != null) {
                reportingPeriod = EDIDataWriterUtil.parseReportingPeriodDate(this.headerBean.getReportingBegin(), this.headerBean.getReportingEnd());
            }
        }
        this.writeRecievingAgency(receiver);
        this.writeSendingAgency(sender);
        this.writeSegment(EDIDataWriterUtil.parseDataSetIdentifier(datasetId));
        this.writeSegment(EDIDataWriterUtil.parseStatus(this.currentDatasetHeader.getAction()));
        if (this.headerBean != null && this.headerBean.getPrepared() != null) {
            this.writeSegment(EDIDataWriterUtil.parsePreperationDate(this.headerBean.getPrepared()));
        } else {
            this.writeSegment(EDIDataWriterUtil.parsePreperationDate(new Date()));
        }
        if (reportingPeriod != null) {
            this.writeSegment(reportingPeriod);
        }
        this.writeSegment(EDIDataWriterUtil.parseDataStructureIdentifier(dsd.getId()));
        this.writeSegment(EDIDataWriterUtil.parseMethodToSendDataSet());
        this.writeSegment(EDIDataWriterUtil.parseMissingValue());
    }

    public void setCrossSectionConcept(String concept) throws UnsupportedException {
        if (concept != null && !concept.equals("TIME_PERIOD")) {
            throw new UnsupportedException(new Object[]{"Cross sectional datasets are not supported for EDI data"});
        }
    }

    @Override
    public void startGroup(String groupId) {
        this.startMessage();
        this.flushDataLine();
        this.currentPOS = POSITION.GROUP;
        this.currentSeriesKey = "";
        this.keyValues.clear();
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        if (this.currentPOS != POSITION.GROUP) {
            throw new ValidationException("Can not write group key value, a call to the method startGroup(..) must first be made");
        }
        this.keyValues.put(conceptId, conceptValue);
    }

    @Override
    public void startSeries() {
        this.startMessage();
        this.flushDataLine();
        this.currentPOS = POSITION.SERIES;
        this.currentSeriesKey = "";
        this.keyValues.clear();
    }

    @Override
    public void writeSeriesKeyValue(String conceptId, String conceptValue) {
        if (this.currentPOS != POSITION.SERIES) {
            this.startSeries();
        }
        if (!this.dimensionIds.contains(conceptId)) {
            throw new ValidationException("Data Structure '" + this.dsd.getId() + "' does not contain dimension with id '" + conceptId + "'");
        }
        this.keyValues.put(conceptId, conceptValue);
    }

    private void createSeriesKey() {
        if (this.currentSeriesKey.length() == 0 && this.keyValues.size() > 0) {
            String concat = "";
            for (String currentDimension : this.dimensionIds) {
                String val = this.keyValues.get(currentDimension);
                this.currentSeriesKey = String.valueOf(this.currentSeriesKey) + concat;
                if (val != null) {
                    this.currentSeriesKey = String.valueOf(this.currentSeriesKey) + val;
                }
                concat = ":";
            }
        }
    }

    private void flushAttributes() {
        for (String key : this.bufferedAttributes.keySet()) {
            this.flushAttributeValue(key, this.bufferedAttributes.get(key));
        }
        this.bufferedAttributes.clear();
    }

    @Override
    public void writeAttributeValue(String attributeId, String conceptValue) {
        this.bufferedAttributes.put(attributeId, conceptValue);
    }

    private void flushAttributeValue(String attributeId, String conceptValue) {
        if (conceptValue == null) {
            conceptValue = "";
        }
        this.startMessage();
        if (this.currentPOS == POSITION.OBS) {
            if (attributeId.equals("OBS_STATUS")) {
                this.currentObsStatus = conceptValue;
                return;
            }
            if (attributeId.equals("OBS_CONF")) {
                this.currentObsConf = conceptValue;
                return;
            }
            if (attributeId.equals("OBS_PRE_BREAK")) {
                this.currentObsPreBreak = conceptValue;
                return;
            }
        }
        this.hasAttributes = true;
        AttributeBean attribute = this.dsd.getAttribute(attributeId);
        if (attribute == null) {
            throw new ValidationException("Data Structure '" + this.dsd.getId() + "' does not contain an attribute with identifier: " + attributeId);
        }
        switch (attribute.getAttachmentLevel()) {
            case DATA_SET: {
                if (this.currentPOS == POSITION.DATASET) break;
                throw new ValidationException("Can not write a dataset attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case DIMENSION_GROUP: {
                if (this.currentPOS == POSITION.SERIES) break;
                throw new ValidationException("Can not write a series attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case GROUP: {
                if (this.currentPOS == POSITION.GROUP) break;
                throw new ValidationException("Can not write a group attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case OBSERVATION: {
                if (this.currentPOS == POSITION.OBS) break;
                throw new ValidationException("Can not write a observation attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
        }
        boolean isCoded = attribute.hasCodedRepresentation();
        this.createSeriesKey();
        String outputKey = this.currentSeriesKey;
        int keyLength = this.dimensionIds.size();
        if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP) {
            outputKey = this.seriesAttributeKeyCreator.get(attribute).createSubKey();
        } else if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET) {
            keyLength = 0;
            outputKey = "";
        } else if (this.currentPOS == POSITION.OBS) {
            outputKey = String.valueOf(outputKey) + this.currentObsTime + ":" + (Object)((Object)EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false));
            keyLength += 2;
        }
        PrintWriter pw = this.getAttributeWriter();
        if (this.currentAttributeKey == null || !outputKey.equals(this.currentAttributeKey)) {
            pw.println(EDIDataWriterUtil.parseAttributeAttachment(keyLength, outputKey));
            this.currentAttributeKey = outputKey;
        }
        pw.println(EDIDataWriterUtil.parseAttributeIdentifier(attributeId, isCoded));
        if (conceptValue.length() > 0) {
            List<String> values = EDIDataWriterUtil.parseAttributeValue(conceptValue, isCoded);
            for (String val : values) {
                pw.println(val);
            }
        }
    }

    @Override
    public void writeObservation(String obsTime, String obsValue) {
        this.flushObs();
        if (obsValue == null || obsValue.equals("NaN")) {
            obsValue = "-";
        }
        this.currentPOS = POSITION.OBS;
        this.currentObsDate = this.dateMap.get(obsTime);
        if (this.currentObsDate == null) {
            this.currentObsDate = DateUtil.formatDate(obsTime, false);
            this.dateMap.put(obsTime, this.currentObsDate);
        }
        this.timeFormat = this.timeFormatMap.get(obsTime);
        if (this.timeFormat == null) {
            this.timeFormat = DateUtil.getTimeFormatOfDate(obsTime);
            this.timeFormatMap.put(obsTime, this.timeFormat);
            this.dateIterationsMap.put(this.timeFormat, new DateIterations(this.timeFormat));
        }
        this.currentObsTime = obsTime;
        this.currentObsValue = obsValue;
    }

    private void storeReportedDate() {
        if (this.currentObsStartDate == null || this.currentObsDate.getTime() < this.currentObsStartDate.getTime()) {
            this.currentObsStartDate = this.currentObsDate;
        }
        if (this.currentObsEndDate == null || this.currentObsDate.getTime() > this.currentObsEndDate.getTime()) {
            this.currentObsEndDate = this.currentObsDate;
        }
    }

    private void flushObs() {
        this.flushAttributes();
        if (this.currentObsTime != null) {
            this.createObsValue();
            if (this.timeFormat == TIME_FORMAT.DATE_TIME || this.timeFormat == TIME_FORMAT.HOUR) {
                this.createSeriesKey();
                EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false);
                this.outputObs(ediTimeFormat.formatDate(this.currentObsDate), ediTimeFormat.getEdiValue(), this.currentObsValue);
            } else {
                this.dateValues.put(this.currentObsTime, this.currentObsValue);
                this.storeReportedDate();
            }
        }
        this.currentObsValue = "-";
        this.currentObsStatus = "";
        this.currentObsConf = "";
        this.currentObsPreBreak = "";
    }

    @Override
    public void writeObservation(Date obsTime, String obsValue, TIME_FORMAT sdmxTimeFormat) {
        this.writeObservation(DateUtil.formatDate(obsTime, sdmxTimeFormat), obsValue);
    }

    private void createObsValue() {
        if (this.currentDatasetHeader.getAction() == DATASET_ACTION.DELETE) {
            this.currentObsValue = "";
        }
        if (this.currentObsTime != null) {
            if (this.currentObsPreBreak.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus + ":" + this.currentObsConf + ":" + this.currentObsPreBreak;
            } else if (this.currentObsConf.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus + ":" + this.currentObsConf;
            } else if (this.currentObsStatus.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus;
            }
        }
    }

    private void flushDataLine() {
        this.flushObs();
        this.createSeriesKey();
        if (this.currentObsEndDate != null && this.currentObsStartDate != null) {
            if (this.currentDatasetHeader.getAction() == DATASET_ACTION.DELETE) {
                for (String time : this.dateIterationsMap.get((Object)this.timeFormat).getIterations(this.currentObsStartDate, this.currentObsEndDate)) {
                    String reportedValue = this.dateValues.get(time);
                    if (reportedValue == null) continue;
                    String EdiTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false).getEdiValue();
                    this.outputObs(time, EdiTimeFormat, reportedValue);
                }
            } else {
                ArrayList<DataGroup> dataGroupList = new ArrayList<DataGroup>();
                int noVal = 0;
                int numObs = 0;
                DataGroup currentDataGroup = null;
                for (String time : this.dateIterationsMap.get((Object)this.timeFormat).getIterations(this.currentObsStartDate, this.currentObsEndDate)) {
                    String reportedValue;
                    if (numObs == 0 || numObs == 9999) {
                        currentDataGroup = new DataGroup(time);
                        dataGroupList.add(currentDataGroup);
                        noVal = 0;
                        numObs = 0;
                    }
                    if ((reportedValue = this.dateValues.get(time)) == null) {
                        ++noVal;
                    } else {
                        if (noVal > 0) {
                            if (noVal > 3) {
                                currentDataGroup = new DataGroup(time);
                                dataGroupList.add(currentDataGroup);
                                numObs = 0;
                            } else {
                                currentDataGroup.addEmptyValues(noVal);
                            }
                            noVal = 0;
                        }
                        currentDataGroup.addObservationValue(time, reportedValue);
                    }
                    ++numObs;
                }
                for (DataGroup currentGroup : dataGroupList) {
                    this.outputObs(currentGroup.getTimePeriod(), currentGroup.getTimeRangeFormat(), currentGroup.getDataLine());
                }
            }
            this.currentObsEndDate = null;
            this.currentObsStartDate = null;
            this.currentObsTime = null;
            this.dateValues = new HashMap<String, String>();
        } else if (this.currentSeriesKey.length() > 0 && !this.hasAttributes) {
            this.writeSegment((Object)((Object)EDI_PREFIX.DATASET_DATA) + this.currentSeriesKey + "'");
        }
    }

    private void outputObs(String timePeriod, String timeRange, String dataLine) {
        String segmentOutput = (Object)((Object)EDI_PREFIX.DATASET_DATA) + this.currentSeriesKey + ":" + timePeriod + ":" + timeRange + dataLine + "'";
        this.writeSegment(segmentOutput);
    }

    protected void writeInterchangeAdministration(InterchangeHeader header) {
        this.header = header;
        this.writer.println((Object)((Object)EDI_PREFIX.MESSAGE_START) + "'");
        this.writer.println(header.toString());
    }

    protected void writeMessageIdentification(MessageIdentification messageId) {
        this.messageId = messageId;
        this.numLines = 1;
        ++this.numMessages;
        this.writeSegment(messageId.toString());
    }

    protected void writeMessageFunction(MESSSAGE_FUNCTION messagefunctionEnum) {
        this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_FUNCTION.toString()) + messagefunctionEnum.getEDIString() + "'");
    }

    protected void writeStructureMaintAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeRecievingAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.RECIEVING_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeSendingAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.SENDING_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeEndMessageAdministration() {
        this.writeSegment(String.valueOf(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString()) + this.numLines + "+" + this.messageId.getMessageRefNum() + "'");
    }

    protected void writeEndMessage() {
        if (this.header != null) {
            this.writer.println(String.valueOf(EDI_PREFIX.END_MESSAGE.toString()) + this.numMessages + "+" + this.header.getInterchangeRef() + "'");
        }
    }

    protected void writeSegment(String str) {
        this.writer.println(str);
        ++this.numLines;
    }

    private void flushCurrentDataset() {
        if (this.currentDatasetHeader != null) {
            this.flushDataLine();
            if (this.hasAttributes) {
                this.writeSegment(EDIDataWriterUtil.parseStartAttributes());
            }
            this.hasAttributes = false;
            if (this.datasetAttributeWriter != null) {
                this.datasetAttributeWriter.close();
                this.writeAttributes(this.tmpAttributeFileDataset);
                this.datasetAttributeWriter = null;
            }
            if (this.seriesAttributeWriter != null) {
                this.seriesAttributeWriter.close();
                this.writeAttributes(this.tmpAttributeFileSeries);
                this.seriesAttributeWriter = null;
            }
            if (this.obsAttributeWriter != null) {
                this.obsAttributeWriter.close();
                this.writeAttributes(this.tmpAttributeFileObs);
                this.obsAttributeWriter = null;
            }
            this.currentSeriesKey = "";
            this.currentAttributeKey = null;
            this.currentObsStartDate = null;
            this.currentObsEndDate = null;
            this.currentObsTime = null;
            this.currentObsValue = "-";
            this.currentObsStatus = "";
            this.currentObsConf = "";
            this.currentObsPreBreak = "";
            this.keyValues.clear();
            this.writeEndMessageAdministration();
        }
    }

    @Override
    public void close() {
        if (this.headerWritten) {
            this.flushCurrentDataset();
            this.writeEndMessage();
            this.writer.close();
        }
    }

    private void writeAttributes(WriteableDataLocation attributeFile) {
        BufferedReader br = null;
        if (attributeFile != null) {
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(attributeFile.getInputStream()));
                    String currentLine = br.readLine();
                    while (currentLine != null) {
                        this.writeSegment(currentLine);
                        currentLine = br.readLine();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                attributeFile.close();
            }
        }
    }

    private class AttributeKeyCreator {
        private boolean[] keyPos;

        public AttributeKeyCreator(AttributeBean attribute) {
            this.keyPos = new boolean[EDIDataWriterEngineImpl.this.dimensionIds.size()];
            for (String currentRef : attribute.getDimensionReferences()) {
                this.keyPos[((EDIDataWriterEngineImpl)EDIDataWriterEngineImpl.this).dimensionIds.indexOf((Object)currentRef)] = true;
            }
        }

        public String createSubKey() {
            String[] keySplit = EDIDataWriterEngineImpl.this.currentSeriesKey.split(":");
            StringBuilder sb = new StringBuilder();
            String concat = "";
            int i = 0;
            while (i < this.keyPos.length) {
                sb.append(concat);
                if (this.keyPos[i]) {
                    sb.append(keySplit[i]);
                }
                concat = ":";
                ++i;
            }
            return sb.toString();
        }
    }

    private class DataGroup {
        private StringBuilder segmentSb = new StringBuilder();
        private String startPeriod;
        private String endPeriod;
        private String prepend = ":";

        public DataGroup(String startPeriod) {
            this.startPeriod = startPeriod;
            this.endPeriod = startPeriod;
        }

        public String getTimePeriod() {
            Date startDate = (Date)EDIDataWriterEngineImpl.this.dateMap.get(this.startPeriod);
            Date endDate = (Date)EDIDataWriterEngineImpl.this.dateMap.get(this.endPeriod);
            EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(EDIDataWriterEngineImpl.this.timeFormat, false);
            String dateToOutput = ediTimeFormat.formatDate(startDate);
            if (this.isRange()) {
                dateToOutput = String.valueOf(dateToOutput) + ediTimeFormat.formatDate(endDate);
            }
            return dateToOutput;
        }

        public String getDataLine() {
            return this.segmentSb.toString();
        }

        public String getTimeRangeFormat() {
            return EDI_TIME_FORMAT.parseTimeFormat(EDIDataWriterEngineImpl.this.timeFormat, this.isRange()).getEdiValue();
        }

        private boolean isRange() {
            return !this.startPeriod.equals(this.endPeriod);
        }

        public void addEmptyValues(int numVals) {
            int i = 0;
            while (i < numVals) {
                this.segmentSb.append("+");
                ++i;
            }
        }

        public void addObservationValue(String date, String value) {
            this.endPeriod = date;
            this.segmentSb.append(String.valueOf(this.prepend) + value);
            this.prepend = "+";
        }
    }

    private class DateIterations {
        private Date from;
        private Date to;
        private TIME_FORMAT format;
        private List<String> datesIterated;

        public DateIterations(TIME_FORMAT format) {
            this.format = format;
        }

        private List<String> getIterations(Date from, Date to) {
            List<String> timeValues;
            if (this.from == null) {
                this.datesIterated = DateUtil.createTimeValues(from, to, this.format);
                this.from = from;
                this.to = to;
            }
            if (from.before(this.from)) {
                timeValues = DateUtil.createTimeValues(from, this.from, this.format);
                timeValues.remove(timeValues.size() - 1);
                this.datesIterated.addAll(0, timeValues);
                this.from = from;
            } else if (to.after(this.to)) {
                timeValues = DateUtil.createTimeValues(this.to, to, this.format);
                timeValues.remove(0);
                this.datesIterated.addAll(timeValues);
                this.to = to;
            }
            String dateFromStr = DateUtil.formatDate(from, this.format);
            String dateToStr = DateUtil.formatDate(to, this.format);
            int idxFrom = this.datesIterated.indexOf(dateFromStr);
            int idxTo = this.datesIterated.indexOf(dateToStr) + 1;
            return this.datesIterated.subList(idxFrom, idxTo);
        }
    }

    static enum POSITION {
        DATASET,
        GROUP,
        SERIES,
        OBS;

    }
}

