/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.reader.impl;

import java.io.OutputStream;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.model.reader.FileReader;
import org.sdmxsource.util.io.StreamUtil;

public class FileReaderImpl
implements FileReader {
    private static Logger LOG = Logger.getLogger(FileReaderImpl.class);
    protected ReadableDataLocation dataFile;
    private String endOfLineTag;
    private Scanner scanner;
    protected String currentLine;
    protected boolean backLine;
    protected int filePosition;
    private int startIndex = -1;
    private int endIndex = -1;

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.resetReader();
    }

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag, int startindex, int endIndex) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.startIndex = startindex;
        this.endIndex = endIndex;
        this.resetReader();
    }

    @Override
    public void resetReader() {
        if (this.scanner != null) {
            this.scanner.close();
        }
        this.scanner = new Scanner(this.dataFile.getInputStream());
        this.scanner.useDelimiter(this.endOfLineTag);
        this.filePosition = 0;
        if (this.startIndex > 0) {
            while (this.filePosition != this.startIndex) {
                this.moveNext();
            }
        }
    }

    @Override
    public boolean moveNext() {
        if (this.filePosition == this.endIndex) {
            this.currentLine = null;
            return false;
        }
        if (this.scanner.hasNext()) {
            ++this.filePosition;
            this.currentLine = this.scanner.next();
            LOG.debug("Move Next : " + this.currentLine);
        } else {
            this.currentLine = null;
        }
        this.cleanLine();
        return this.currentLine != null && this.currentLine.length() > 0;
    }

    @Override
    public String getNextLine() {
        if (this.backLine) {
            this.backLine = false;
            return this.currentLine;
        }
        if (this.moveNext()) {
            return this.getCurrentLine();
        }
        return null;
    }

    @Override
    public String getCurrentLine() {
        return this.currentLine;
    }

    private void cleanLine() {
        if (this.currentLine != null) {
            this.currentLine = this.currentLine.replaceAll("\\u000A", "");
            this.currentLine = this.currentLine.replaceAll("\\u000D", "");
        }
    }

    @Override
    public int getLineNumber() {
        return this.filePosition;
    }

    @Override
    public void moveBackLine() {
        this.backLine = true;
    }

    @Override
    public void copyToStream(OutputStream out) {
        StreamUtil.copyStream(this.dataFile.getInputStream(), out);
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

