/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIReader;

public class EDIUtil {
    private static String siblingGroupId = "Sibling";

    public static int parseStringAsInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Expecting integer value, but was '" + str + "'");
        }
    }

    public static String stringToEdi(String inputStr) {
        inputStr = inputStr.replaceAll("\\?", "??");
        inputStr = inputStr.replaceAll(":", "?:");
        inputStr = inputStr.replaceAll("\\+", "?+");
        inputStr = inputStr.replaceAll("'", "?'");
        return inputStr;
    }

    public static String ediToString(String inputStr) {
        inputStr = inputStr.replaceAll("(?<!\\?):", "");
        inputStr = inputStr.replaceAll("\\?:", ":");
        inputStr = inputStr.replaceAll("\\?'", "'");
        inputStr = inputStr.replaceAll("\\?\\+", "+");
        inputStr = inputStr.replaceAll("\\?\\?", "?");
        return inputStr;
    }

    public static String stringToEDIFreeText(String str, int segmentLength, int maxLength) {
        if (str.length() > maxLength) {
            throw new IllegalArgumentException("Error in segment " + (Object)((Object)EDI_PREFIX.STRING) + " - text string exceeds max length of " + maxLength);
        }
        return EDIUtil.stringToEDI(str, segmentLength);
    }

    public static List<String> stringToEDIFreeText(String str, int segmentLength, int lineLength, int maxRows) {
        if (str.length() > lineLength * maxRows) {
            throw new IllegalArgumentException("Error in segment " + (Object)((Object)EDI_PREFIX.STRING) + " - text string exceeds max length of " + lineLength);
        }
        ArrayList<String> returnedStrings = new ArrayList<String>();
        int strLen = str.length();
        int rows = 0;
        while (rows < strLen) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)EDI_PREFIX.STRING);
            String stringPart = str.substring(rows, Math.min(strLen, rows + lineLength));
            returnedStrings.add(EDIUtil.stringToEDI(stringPart, segmentLength));
            rows += lineLength;
        }
        if (returnedStrings.size() > maxRows) {
            throw new IllegalArgumentException("Error in segment " + (Object)((Object)EDI_PREFIX.STRING) + " - text string exceeds the maximum permitted rows: " + maxRows + " with " + returnedStrings.size());
        }
        return returnedStrings;
    }

    private static String stringToEDI(String str, int partitionSize) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EDI_PREFIX.STRING);
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            String stringPart = str.substring(i, Math.min(strLen, i + partitionSize));
            if (i != 0 && !stringPart.trim().equals("")) {
                sb.append(":");
            }
            sb.append(EDIUtil.stringToEdi(stringPart));
            i += partitionSize;
        }
        sb.append("'");
        return sb.toString();
    }

    public static void parseId(String id) {
        Pattern idPattern = Pattern.compile("([A-Z]||[0-9]|_|)*");
        if (!idPattern.matcher(id).matches()) {
            throw new IllegalArgumentException("Illegal id, '" + id + "'.\nId's must only contain upper case characters [A-Z], integers [0-9], and underscores [_] ");
        }
        if (id.length() > 18) {
            throw new IllegalArgumentException("Illegal id, structure identifiers can not be more then 18 characters in EDI");
        }
    }

    public static String[] splitOnPlus(String str) {
        return EDIUtil.splitOnChar(str, "\\+", -1);
    }

    public static String[] splitOnPlus(String str, int expectedNumbersplits) {
        return EDIUtil.splitOnChar(str, "\\+", expectedNumbersplits);
    }

    public static String[] splitOnColon(String str) {
        return EDIUtil.splitOnChar(str, ":", -1);
    }

    public static String[] splitOnColon(String str, int expectedNumbersplits) {
        return EDIUtil.splitOnChar(str, ":", expectedNumbersplits);
    }

    private static String[] splitOnChar(String str, String charecter, int expectedNumbersplits) {
        String[] splitOnPlus = str.split("(?<!\\?)" + charecter);
        if (expectedNumbersplits > 0 && splitOnPlus.length != expectedNumbersplits) {
            throw new IllegalArgumentException("Unexpected number of '" + charecter + "' characters, expecting " + expectedNumbersplits + " actual '" + splitOnPlus.length + "'");
        }
        return splitOnPlus;
    }

    public static boolean assertPrefix(EDIReader dataReader, EDI_PREFIX prefix, boolean errorOnFail) {
        if (dataReader.getLineType() != prefix) {
            if (errorOnFail) {
                throw new IllegalArgumentException("Expecting prefix : '" + prefix.getPrefix() + "' but got '" + (Object)((Object)dataReader.getLineType()) + "'");
            }
            return false;
        }
        return true;
    }

    public static String getSiblingGroupId() {
        return siblingGroupId;
    }

    public static void setSiblingGroupId(String siblingGroupId) {
        EDIUtil.siblingGroupId = siblingGroupId;
    }
}

