/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URL;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AgenciesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AgencySchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AgencyType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AgencyMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AgencySchemeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AgencyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.OrganisationSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AgencyMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AgencySchemeMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class AgencySchemeBeanImpl
extends OrganisationSchemeBeanImpl<AgencyBean>
implements AgencySchemeBean {
    private static final long serialVersionUID = -787661696574731583L;

    private AgencySchemeBeanImpl(AgencySchemeBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public AgencySchemeBeanImpl(AgencySchemeMutableBean bean) {
        super(bean);
        if (bean.getItems() != null) {
            for (AgencyMutableBean item : bean.getItems()) {
                this.items.add(new AgencyBeanImpl(item, (AgencySchemeBean)this));
            }
        }
    }

    public AgencySchemeBeanImpl(AgencySchemeType type) {
        super(type, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
        if (ObjectUtil.validCollection(type.getAgencyList())) {
            for (AgencyType currentAgency : type.getAgencyList()) {
                this.items.add(new AgencyBeanImpl(currentAgency, (AgencySchemeBean)this));
            }
        }
    }

    public AgencySchemeBeanImpl(OrganisationSchemeType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, bean.getValidTo(), bean.getValidFrom(), "1.0", TERTIARY_BOOL.FALSE, "SDMX", "AGENCIES", bean.getUri(), bean.getNameList(), bean.getDescriptionList(), AgencySchemeBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        try {
            if (bean.getAgenciesList() != null) {
                for (AgenciesType dcList : bean.getAgenciesList()) {
                    for (OrganisationType agencyType : dcList.getAgencyList()) {
                        this.items.add(new AgencyBeanImpl(agencyType, (AgencySchemeBean)this));
                    }
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
    }

    public static AgencySchemeBean createDefaultScheme() {
        AgencySchemeMutableBeanImpl mutable = new AgencySchemeMutableBeanImpl();
        mutable.setAgencyId("SDMX");
        mutable.setId("AGENCIES");
        mutable.setVersion("1.0");
        mutable.addName("en", "SDMX Agency Scheme");
        AgencyMutableBeanImpl agencyMutableBean = new AgencyMutableBeanImpl();
        agencyMutableBean.addName("en", "SDMX");
        agencyMutableBean.setId("SDMX");
        mutable.addItem(agencyMutableBean);
        return mutable.getImmutableInstance();
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            return super.deepEqualsInternal((AgencySchemeBean)bean);
        }
        return false;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getId() {
        return "AGENCIES";
    }

    @Override
    public boolean isDefaultScheme() {
        return this.getAgencyId().equals("SDMX");
    }

    @Override
    public MaintainableBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new AgencySchemeBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public AgencySchemeMutableBean getMutableInstance() {
        return new AgencySchemeMutableBeanImpl(this);
    }
}

