/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.AnnotationType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.sdmx.util.beans.ValidationUtil;
import org.sdmxsource.util.ObjectUtil;

public class AnnotationBeanImpl
extends SDMXBeanImpl
implements AnnotationBean {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private String type;
    private URI url;
    private List<TextTypeWrapper> text = new ArrayList<TextTypeWrapper>();

    public AnnotationBeanImpl(AnnotationMutableBean annotationMutable, SDMXBean parent) {
        super(annotationMutable, parent);
        this.id = annotationMutable.getId();
        this.title = annotationMutable.getTitle();
        this.type = annotationMutable.getType();
        if (annotationMutable.getText() != null) {
            for (TextTypeWrapperMutableBean mutable : annotationMutable.getText()) {
                if (!ObjectUtil.validString(mutable.getValue())) continue;
                this.text.add(new TextTypeWrapperImpl(mutable, (SDMXBean)this));
            }
        }
        this.setURL(annotationMutable.getUrl());
        try {
            this.validate();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.id = annotation.getId();
        this.text = TextTypeUtil.wrapTextTypeV21(annotation.getAnnotationTextList(), this);
        this.setURL(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.text = TextTypeUtil.wrapTextTypeV2(annotation.getAnnotationTextList(), this);
        this.setURL(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.text = TextTypeUtil.wrapTextTypeV1(annotation.getAnnotationTextList(), this);
        this.setURL(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Could not create Annotation as it did not validate");
        }
    }

    private void setURL(String serviceURLStr) {
        if (serviceURLStr == null) {
            this.url = null;
            return;
        }
        try {
            this.url = new URI(serviceURLStr);
        }
        catch (Throwable th) {
            throw new ValidationException("Could not create attribute 'annotationURL' with value '" + serviceURLStr + "'");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == SDMX_STRUCTURE_TYPE.ANNOTATION) {
            AnnotationBean annotation = (AnnotationBean)bean;
            if (!ObjectUtil.equivalent(this.id, annotation.getId())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.title, annotation.getTitle())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.type, annotation.getType())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.url, annotation.getURL())) {
                return false;
            }
            return super.equivalent(this.text, annotation.getText());
        }
        return false;
    }

    private void validate() {
        ValidationUtil.validateTextType(this.text, null);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getURL() {
        return this.url;
    }

    @Override
    public List<TextTypeWrapper> getText() {
        return new ArrayList<TextTypeWrapper>(this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Title:" + this.getTitle());
        sb.append("Type:" + this.getType());
        sb.append("URI:" + this.getURL());
        return sb.toString();
    }
}

