/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.RepresentationType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.RepresentationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.RepresentationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextFormatBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RepresentationBeanImpl
extends SdmxStructureBeanImpl
implements RepresentationBean {
    private static final long serialVersionUID = -3680385737436648801L;
    private CrossReferenceBean representationRef;
    private TextFormatBean textFormat;

    public RepresentationBeanImpl(RepresentationMutableBean bean, IdentifiableBean parent) {
        super(SDMX_STRUCTURE_TYPE.LOCAL_REPRESENTATION, (SdmxStructureBean)parent);
        if (bean.getTextFormat() != null) {
            this.textFormat = new TextFormatBeanImpl(bean.getTextFormat(), (SDMXBean)this);
        }
        if (bean.getRepresentation() != null) {
            this.representationRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getRepresentation());
        }
        this.validate();
    }

    public RepresentationBeanImpl(RepresentationType bean, IdentifiableBean parent) {
        super(SDMX_STRUCTURE_TYPE.LOCAL_REPRESENTATION, (SdmxStructureBean)parent);
        if (bean.getTextFormat() != null) {
            this.textFormat = new TextFormatBeanImpl(bean.getTextFormat(), (SDMXBean)this);
        }
        if (bean.getEnumeration() != null) {
            this.representationRef = RefUtil.createReference(this, bean.getEnumeration());
            if (bean.getEnumerationFormat() != null) {
                this.textFormat = new TextFormatBeanImpl(bean.getEnumerationFormat(), (SDMXBean)this);
            }
        }
        this.validate();
    }

    public RepresentationBeanImpl(TextFormatType textFormat, String codelistAgency, String codelistId, String codelistVersion, IdentifiableBean parent) {
        super(SDMX_STRUCTURE_TYPE.LOCAL_REPRESENTATION, (SdmxStructureBean)parent);
        if (textFormat != null) {
            this.textFormat = new TextFormatBeanImpl(textFormat, (SDMXBean)this);
        }
        if (ObjectUtil.validOneString(codelistAgency, codelistId, codelistVersion)) {
            if (!ObjectUtil.validString(codelistAgency)) {
                codelistAgency = this.getMaintainableParent().getAgencyId();
            }
            SDMX_STRUCTURE_TYPE structureType = SDMX_STRUCTURE_TYPE.CODE_LIST;
            if (parent.getMaintainableParent() instanceof CrossSectionalDataStructureBean && parent instanceof DimensionBean && ((DimensionBean)parent).isMeasureDimension()) {
                structureType = SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME;
            }
            this.representationRef = new CrossReferenceBeanImpl(this, codelistAgency, codelistId, codelistVersion, structureType);
        }
        this.validate();
    }

    protected RepresentationBeanImpl(String codelistId, IdentifiableBean parent) {
        super(SDMX_STRUCTURE_TYPE.LOCAL_REPRESENTATION, (SdmxStructureBean)parent);
        if (ObjectUtil.validString(codelistId)) {
            this.representationRef = new CrossReferenceBeanImpl(this, parent.getMaintainableParent().getAgencyId(), codelistId, null, SDMX_STRUCTURE_TYPE.CODE_LIST);
        }
        this.validate();
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            RepresentationBean that = (RepresentationBean)bean;
            if (!super.equivalent(this.representationRef, that.getRepresentationRef())) {
                return false;
            }
            return super.equivalent(this.textFormat, that.getTextFormat());
        }
        return false;
    }

    private void validate() {
        if (this.representationRef == null && this.textFormat == null) {
            throw new ValidationException("Representation must have a codelist reference or text format");
        }
    }

    @Override
    public TextFormatBean getTextFormat() {
        return this.textFormat;
    }

    @Override
    public CrossReferenceBean getRepresentationRef() {
        return this.representationRef;
    }
}

