/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.util.beans.SDMXBeanUtil;
import org.sdmxsource.util.reflect.ReflectUtil;

public abstract class SDMXBeanImpl
implements SDMXBean {
    private static final long serialVersionUID = 1L;
    protected SDMX_STRUCTURE_TYPE structureType;
    protected SDMXBean parent;
    transient Set<SDMXBean> composites;
    transient Set<IdentifiableBean> identifiableComposites;
    transient Set<CrossReferenceBean> crossReferences;

    protected SDMXBeanImpl(SDMX_STRUCTURE_TYPE structureType, SDMXBean parent) {
        this.structureType = structureType;
        this.parent = parent;
    }

    protected SDMXBeanImpl(SDMXBean bean) {
        if (bean == null) {
            throw new ValidationException(ExceptionCode.JAVA_REQUIRED_OBJECT_NULL, "bean in constructor");
        }
        this.structureType = bean.getStructureType();
        this.parent = bean.getParent();
    }

    public SDMXBeanImpl(MutableBean mutableBean, SDMXBean parent) {
        if (mutableBean == null) {
            throw new ValidationException(ExceptionCode.JAVA_REQUIRED_OBJECT_NULL, "bean in constructor");
        }
        this.structureType = mutableBean.getStructureType();
        this.parent = parent;
    }

    protected static TERTIARY_BOOL createTertiary(boolean isSet, boolean value) {
        return SDMXBeanUtil.createTertiary(isSet, value);
    }

    @Override
    public SDMX_STRUCTURE_TYPE getStructureType() {
        return this.structureType;
    }

    @Override
    public SDMXBean getParent() {
        return this.parent;
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        throw new UnsupportedException(new Object[]{""});
    }

    protected boolean equivalent(List<? extends SDMXBean> list1, List<? extends SDMXBean> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.size() == 0) {
            return true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            SDMXBean thatCurrentBean;
            SDMXBean thisCurrentBean = list2.get(i);
            if (thisCurrentBean.deepEquals(thatCurrentBean = list1.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equivalent(SDMXBean bean1, SDMXBean bean2) {
        if (bean1 == null) {
            return bean2 == null;
        }
        if (bean2 == null) {
            return bean1 == null;
        }
        return bean1.deepEquals(bean2);
    }

    protected boolean equivalent(CrossReferenceBean crossRef1, CrossReferenceBean crossRef2) {
        if (crossRef1 == null) {
            return crossRef2 == null;
        }
        if (crossRef2 == null) {
            return crossRef1 == null;
        }
        return crossRef2.getTargetUrn().equals(crossRef1.getTargetUrn());
    }

    @Override
    public <T> T getParent(Class<T> type, boolean includeThisType) {
        if (this.parent != null) {
            if (type.isAssignableFrom(this.parent.getClass())) {
                SDMXBean returnObj = this.parent;
                return (T)returnObj;
            }
            return this.parent.getParent(type, false);
        }
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public <T> Set<T> getComposites(Class<T> type) {
        HashSet<SDMXBean> returnSet = new HashSet<SDMXBean>();
        if (this.parent != null) {
            for (SDMXBean currentComposite : this.getComposites()) {
                if (!type.isAssignableFrom(currentComposite.getClass())) continue;
                returnSet.add(currentComposite);
            }
        }
        return returnSet;
    }

    @Override
    public Set<SDMXBean> getComposites() {
        this.generateSdmxBeanComposites(SdmxStructureBean.class.getMethods());
        return new HashSet<SDMXBean>(this.composites);
    }

    protected void generateSdmxBeanComposites(Method ... ignoreMethods) {
        if (this.composites == null) {
            ReflectUtil reflectUtil = new ReflectUtil();
            Set compositeSet = reflectUtil.getCompositeObjects(SDMXBean.class, this, ignoreMethods);
            HashSet<SDMXBean> mergeSet = new HashSet<SDMXBean>();
            for (SDMXBean currentComposite : compositeSet) {
                mergeSet.addAll(currentComposite.getComposites());
            }
            compositeSet.addAll(mergeSet);
            this.composites = compositeSet;
        }
    }

    @Override
    public Set<CrossReferenceBean> getCrossReferences() {
        if (this.crossReferences != null) {
            return new HashSet<CrossReferenceBean>(this.crossReferences);
        }
        try {
            ReflectUtil reflectCrossReference = new ReflectUtil();
            Set<CrossReferenceBean> returnSet = reflectCrossReference.getCompositeObjects(CrossReferenceBean.class, this, this.getClass().getMethod("getCrossReferences", null));
            if (this.getStructureType().isMaintainable()) {
                Set<SDMXBean> compositSet = this.getComposites();
                for (SDMXBean currentComposite : compositSet) {
                    returnSet.addAll(currentComposite.getCrossReferences());
                }
            }
            this.crossReferences = returnSet;
            return returnSet;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

