/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextTypeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextFormatMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.util.ObjectUtil;

public class TextFormatBeanImpl
extends SDMXBeanImpl
implements TextFormatBean {
    private static Logger LOG = Logger.getLogger(TextFormatBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private TEXT_TYPE textType;
    private TERTIARY_BOOL isSequence = TERTIARY_BOOL.UNSET;
    private TERTIARY_BOOL isMultiLingual = TERTIARY_BOOL.UNSET;
    private BigInteger minLength;
    private BigInteger maxLength;
    private BigDecimal startValue;
    private BigDecimal endValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private BigDecimal interval;
    private String timeInterval;
    private BigInteger decimals;
    private String pattern;
    private SdmxDate startTime;
    private SdmxDate endTime;

    public TextFormatBeanImpl(TextFormatMutableBean txtBean, SDMXBean parent) {
        super(txtBean, parent);
        this.textType = txtBean.getTextType();
        if (txtBean.getSequence() != null) {
            this.isSequence = txtBean.getSequence();
        }
        this.maxLength = txtBean.getMaxLength();
        this.minLength = txtBean.getMinLength();
        this.startValue = txtBean.getStartValue();
        this.endValue = txtBean.getEndValue();
        this.maxValue = txtBean.getMaxValue();
        this.minValue = txtBean.getMinValue();
        this.interval = txtBean.getInterval();
        this.timeInterval = txtBean.getTimeInterval();
        this.decimals = txtBean.getDecimals();
        this.pattern = txtBean.getPattern();
        this.validate();
    }

    public TextFormatBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.TextFormatType txtBean, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_FORMAT, parent);
        if (txtBean.getTextType() != null) {
            this.textType = TextTypeUtil.getTextType(txtBean.getTextType());
        }
        if (txtBean.isSetIsMultiLingual()) {
            this.isMultiLingual = TERTIARY_BOOL.parseBoolean(txtBean.getIsMultiLingual());
        }
        if (txtBean.isSetIsSequence()) {
            this.isSequence = TERTIARY_BOOL.parseBoolean(txtBean.getIsSequence());
        }
        if (txtBean.isSetMaxLength()) {
            this.maxLength = txtBean.getMaxLength();
        }
        if (txtBean.isSetMinLength()) {
            this.minLength = txtBean.getMinLength();
        }
        if (txtBean.isSetStartValue()) {
            this.startValue = txtBean.getStartValue();
        }
        if (txtBean.isSetEndValue()) {
            this.endValue = txtBean.getEndValue();
        }
        if (txtBean.isSetMaxValue()) {
            this.maxValue = txtBean.getMaxValue();
        }
        if (txtBean.isSetMinLength()) {
            this.minValue = txtBean.getMinValue();
        }
        if (txtBean.isSetInterval()) {
            this.interval = txtBean.getInterval();
        }
        if (txtBean.getTimeInterval() != null) {
            this.timeInterval = txtBean.getTimeInterval().toString();
        }
        if (txtBean.isSetDecimals()) {
            this.decimals = txtBean.getDecimals();
        }
        if (txtBean.isSetPattern()) {
            this.pattern = txtBean.getPattern();
        }
        if (txtBean.getEndTime() != null) {
            this.endTime = new SdmxDateImpl(txtBean.getEndTime().toString());
        }
        if (txtBean.getStartTime() != null) {
            this.startTime = new SdmxDateImpl(txtBean.getStartTime().toString());
        }
        this.validate();
    }

    public TextFormatBeanImpl(TextFormatType txtBean, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.TEXT_FORMAT, parent);
        if (txtBean.getTextType() != null) {
            TextTypeType.Enum textType = txtBean.getTextType();
            switch (textType.intValue()) {
                case 2: {
                    this.textType = TEXT_TYPE.BIG_INTEGER;
                    break;
                }
                case 9: {
                    this.textType = TEXT_TYPE.BOOLEAN;
                    break;
                }
                case 21: {
                    this.textType = TEXT_TYPE.COUNT;
                    break;
                }
                case 11: {
                    this.textType = TEXT_TYPE.DATE;
                    break;
                }
                case 10: {
                    this.textType = TEXT_TYPE.DATE_TIME;
                    break;
                }
                case 15: {
                    this.textType = TEXT_TYPE.DAY;
                    break;
                }
                case 6: {
                    this.textType = TEXT_TYPE.DECIMAL;
                    break;
                }
                case 8: {
                    this.textType = TEXT_TYPE.DOUBLE;
                    break;
                }
                case 18: {
                    this.textType = TEXT_TYPE.DURATION;
                    break;
                }
                case 23: {
                    this.textType = TEXT_TYPE.EXCLUSIVE_VALUE_RANGE;
                    break;
                }
                case 7: {
                    this.textType = TEXT_TYPE.FLOAT;
                    break;
                }
                case 22: {
                    this.textType = TEXT_TYPE.INCLUSIVE_VALUE_RANGE;
                    break;
                }
                case 24: {
                    this.textType = TEXT_TYPE.INCREMENTAL;
                    break;
                }
                case 4: {
                    this.textType = TEXT_TYPE.LONG;
                    break;
                }
                case 14: {
                    this.textType = TEXT_TYPE.MONTH;
                    break;
                }
                case 16: {
                    this.textType = TEXT_TYPE.MONTH_DAY;
                    break;
                }
                case 25: {
                    this.textType = TEXT_TYPE.OBSERVATIONAL_TIME_PERIOD;
                    break;
                }
                case 5: {
                    this.textType = TEXT_TYPE.SHORT;
                    break;
                }
                case 1: {
                    this.textType = TEXT_TYPE.STRING;
                    break;
                }
                case 12: {
                    this.textType = TEXT_TYPE.TIME;
                    break;
                }
                case 20: {
                    this.textType = TEXT_TYPE.TIMESPAN;
                    break;
                }
                case 19: {
                    this.textType = TEXT_TYPE.URI;
                    break;
                }
                case 13: {
                    this.textType = TEXT_TYPE.YEAR;
                    break;
                }
                case 17: {
                    this.textType = TEXT_TYPE.YEAR_MONTH;
                }
            }
        }
        if (txtBean.isSetIsSequence()) {
            this.isSequence = TERTIARY_BOOL.parseBoolean(txtBean.getIsSequence());
        }
        if (txtBean.isSetMaxLength()) {
            this.maxLength = txtBean.getMaxLength();
        }
        if (txtBean.isSetMinLength()) {
            this.minLength = txtBean.getMinLength();
        }
        if (txtBean.isSetStartValue()) {
            this.startValue = BigDecimal.valueOf(txtBean.getStartValue());
        }
        if (txtBean.isSetEndValue()) {
            this.endValue = BigDecimal.valueOf(txtBean.getEndValue());
        }
        if (txtBean.isSetInterval()) {
            this.interval = BigDecimal.valueOf(txtBean.getInterval());
        }
        if (txtBean.getTimeInterval() != null) {
            this.timeInterval = txtBean.getTimeInterval().toString();
        }
        if (txtBean.isSetDecimals()) {
            this.decimals = txtBean.getDecimals();
        }
        if (txtBean.isSetPattern()) {
            this.pattern = txtBean.getPattern();
        }
        this.validate();
    }

    private void validate() throws ValidationException {
        if (this.minLength != null) {
            if (this.minLength.intValue() == 0) {
                LOG.warn("Text format of 0 converted to 1");
                this.minLength = BigInteger.ONE;
            } else if (this.minLength.intValue() < 0) {
                throw new ValidationException("Invalid Text Format, min length must be a positive integer - got " + this.minLength.intValue());
            }
        }
        if (this.maxLength != null && this.maxLength.intValue() <= 0) {
            throw new ValidationException("Invalid Text Format, max length must be a positive integer - got " + this.maxLength.intValue());
        }
        if (this.minLength != null && this.maxLength != null && this.minLength.compareTo(this.maxLength) > 0) {
            throw new ValidationException("Invalid Text Format, min length can not be greater then max length");
        }
        if (this.minValue != null && this.maxValue != null && this.minValue.compareTo(this.maxValue) > 0) {
            throw new ValidationException("Invalid Text Format, min value can not be greater then max value");
        }
        if (this.decimals != null && this.decimals.intValue() <= 0) {
            throw new ValidationException("Invalid Text Format, decimals must be a positive integer - got " + this.decimals.intValue());
        }
        if (this.startTime != null && this.endTime != null && this.startTime.isLater(this.endTime)) {
            throw new ValidationException("Invalid Text Format, start time can not be after end time");
        }
        if (this.isSequence.isTrue()) {
            if (this.timeInterval == null && this.interval == null) {
                throw new ValidationException("Invalid Text Format, time interval or interval must be set if isSequence is set to true");
            }
            if (ObjectUtil.validString(this.timeInterval) && this.startTime == null) {
                throw new ValidationException("Invalid Text Format, start time must be set if time interval is set");
            }
            if (this.interval != null && this.startValue == null) {
                throw new ValidationException("Invalid Text Format, start value must be set if interval is set");
            }
        } else {
            if (ObjectUtil.validString(this.timeInterval)) {
                throw new ValidationException("Invalid Text Format, time interval can only be set if isSequence is set to true");
            }
            if (this.startTime != null) {
                throw new ValidationException("Invalid Text Format, start time can only be set if isSequence is set to true");
            }
            if (this.interval != null) {
                throw new ValidationException("Invalid Text Format, interval can only be set if isSequence is set to true");
            }
            if (this.startValue != null) {
                throw new ValidationException("Invalid Text Format, start value can only be set if isSequence is set to true");
            }
        }
        if (ObjectUtil.validString(this.timeInterval)) {
            Pattern timeIntervalPattern = Pattern.compile("P(([0-9]+Y)?([0-9]+M)?([0-9]+D)?)(T([0-9]+H)?([0-9]+M)?([0-9]+S)?)?");
            if (this.timeInterval.length() == 1 || !timeIntervalPattern.matcher(this.timeInterval).matches()) {
                throw new ValidationException("Invalid time interval, pattern must be PnYnMnDTnHnMnS, where n=positive integer, and each section is optional after each n (example P5Y)");
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            TextFormatBean that = (TextFormatBean)bean;
            if (!ObjectUtil.equivalent((Object)this.textType, (Object)that.getTextType())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.isSequence, (Object)that.isSequence())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.isMultiLingual, (Object)that.isSequence())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.minLength, that.getMinLength())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.maxLength, that.getMaxLength())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.minValue, that.getMinValue())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.maxValue, that.getMaxValue())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.startValue, that.getStartValue())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.endValue, that.getEndValue())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.interval, that.getInterval())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.timeInterval, that.getTimeInterval())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.decimals, that.getDecimals())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.pattern, that.getPattern())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.startTime, that.getStartTime())) {
                return false;
            }
            if (!ObjectUtil.equivalent(this.endTime, that.getEndTime())) {
                return false;
            }
        }
        return false;
    }

    @Override
    public TEXT_TYPE getTextType() {
        return this.textType;
    }

    @Override
    public SdmxDate getStartTime() {
        return this.startTime;
    }

    @Override
    public SdmxDate getEndTime() {
        return this.endTime;
    }

    @Override
    public TERTIARY_BOOL isSequence() {
        return this.isSequence;
    }

    @Override
    public BigInteger getMinLength() {
        return this.minLength;
    }

    @Override
    public BigInteger getMaxLength() {
        return this.maxLength;
    }

    @Override
    public BigDecimal getMinValue() {
        return this.minValue;
    }

    @Override
    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    @Override
    public BigDecimal getStartValue() {
        return this.startValue;
    }

    @Override
    public BigDecimal getEndValue() {
        return this.endValue;
    }

    @Override
    public BigDecimal getInterval() {
        return this.interval;
    }

    @Override
    public String getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public BigInteger getDecimals() {
        return this.decimals;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TERTIARY_BOOL getIsMultiLingual() {
        return this.isMultiLingual;
    }
}

