/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme;

import java.net.URL;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorisationType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategoryBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.categoryscheme.CategorisationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.categoryscheme.CategorisationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;

public class CategorisationBeanImpl
extends MaintainableBeanImpl
implements CategorisationBean {
    private static final long serialVersionUID = 1L;
    private CrossReferenceBean categoryReference;
    private CrossReferenceBean structureReference;

    private CategorisationBeanImpl(CategorisationBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public CategorisationBeanImpl(CategorisationMutableBean bean) {
        super(bean);
        try {
            if (bean.getCategoryReference() != null) {
                this.categoryReference = new CrossReferenceBeanImpl((SDMXBean)this, bean.getCategoryReference());
            }
            if (bean.getStructureReference() != null) {
                this.structureReference = new CrossReferenceBeanImpl((SDMXBean)this, bean.getStructureReference());
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public CategorisationBeanImpl(CategorisationType cs) {
        super(cs, SDMX_STRUCTURE_TYPE.CATEGORISATION);
        this.structureReference = RefUtil.createReference(this, cs.getSource());
        this.categoryReference = RefUtil.createReference(this, cs.getTarget());
    }

    public CategorisationBeanImpl(CategoryBean category, DataflowRefType df) {
        super(null, SDMX_STRUCTURE_TYPE.CATEGORISATION, null, null, null, null, category.getMaintainableParent().getAgencyId(), null, null, null, null, null, null);
        try {
            this.name = category.getNames();
            this.structureReference = df.getURN() != null ? new CrossReferenceBeanImpl((SDMXBean)this, df.getURN()) : new CrossReferenceBeanImpl(this, df.getAgencyID(), df.getDataflowID(), df.getVersion(), SDMX_STRUCTURE_TYPE.DATAFLOW);
            this.categoryReference = new CrossReferenceBeanImpl((SDMXBean)this, category.getUrn());
            this.generateId();
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public CategorisationBeanImpl(MaintainableBean referencedFrom, CategoryRefType currentRef) {
        super(null, SDMX_STRUCTURE_TYPE.CATEGORISATION, null, null, null, null, referencedFrom.getAgencyId(), null, null, null, null, null, null);
        try {
            this.name = referencedFrom.getNames();
            this.structureReference = new CrossReferenceBeanImpl((SDMXBean)this, referencedFrom.getUrn());
            this.categoryReference = RefUtil.createCategoryRef(this, currentRef);
            this.generateId();
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getStructureType()});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    private void generateId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.categoryReference.hashCode() + "_" + this.structureReference.hashCode());
        this.setId(sb.toString());
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            CategorisationBean that = (CategorisationBean)bean;
            if (!super.equivalent(this.categoryReference, that.getCategoryReference())) {
                return false;
            }
            if (!super.equivalent(this.structureReference, that.getStructureReference())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.structureReference == null) {
            throw new ValidationException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "StructureReference"});
        }
        if (this.categoryReference == null) {
            throw new ValidationException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, new Object[]{this.structureType, "CategoryReference"});
        }
        super.validateId(true);
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
    }

    @Override
    public CategorisationBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new CategorisationBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public CategorisationMutableBean getMutableInstance() {
        return new CategorisationMutableBeanImpl(this);
    }

    @Override
    public CrossReferenceBean getCategoryReference() {
        return this.categoryReference;
    }

    @Override
    public CrossReferenceBean getStructureReference() {
        return this.structureReference;
    }
}

