/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TimeDimensionType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ConceptReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MeasureDimensionType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionListBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ComponentBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.RepresentationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.RepresentationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextFormatMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class DimensionBeanImpl
extends ComponentBeanImpl
implements DimensionBean {
    private static Logger LOG = Logger.getLogger(DimensionBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private boolean measureDimension;
    private boolean timeDimension;
    private boolean freqDimension;
    private List<CrossReferenceBean> conceptRole = new ArrayList<CrossReferenceBean>();
    private int position;

    public DimensionBeanImpl(DimensionMutableBean bean, int position, DimensionListBean parent) {
        super(bean, parent);
        try {
            this.position = position;
            this.measureDimension = bean.isMeasureDimension();
            this.timeDimension = bean.isTimeDimension();
            if (bean.getConceptRole() != null) {
                for (StructureReferenceBean currentConceptRole : bean.getConceptRole()) {
                    this.conceptRole.add(new CrossReferenceBeanImpl((SDMXBean)this, currentConceptRole));
                }
            }
            this.validateDimension();
        }
        catch (Throwable th) {
            throw new ValidationException(th, "Error creating structure: " + this.toString());
        }
    }

    public DimensionBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.DimensionType dimension, DimensionListBean parent, int position) {
        super(dimension, SDMX_STRUCTURE_TYPE.DIMENSION, parent);
        this.position = dimension.isSetPosition() ? dimension.getPosition() : position;
        if (ObjectUtil.validCollection(dimension.getConceptRoleList())) {
            for (ConceptReferenceType conceptReference : dimension.getConceptRoleList()) {
                this.conceptRole.add(RefUtil.createReference(this, conceptReference));
            }
        }
        this.validateDimension();
    }

    public DimensionBeanImpl(MeasureDimensionType dimension, DimensionListBean parent, int position) {
        super(dimension, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION, parent);
        this.measureDimension = true;
        this.position = dimension.isSetPosition() ? dimension.getPosition() : position;
        if (ObjectUtil.validCollection(dimension.getConceptRoleList())) {
            for (ConceptReferenceType conceptReference : dimension.getConceptRoleList()) {
                this.conceptRole.add(RefUtil.createReference(this, conceptReference));
            }
        }
        this.validateDimension();
    }

    public DimensionBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.TimeDimensionType dimension, DimensionListBean parent, int position) {
        super(dimension, SDMX_STRUCTURE_TYPE.TIME_DIMENSION, parent);
        this.timeDimension = true;
        this.position = dimension.isSetPosition() ? dimension.getPosition() : position;
        if (ObjectUtil.validCollection(dimension.getConceptRoleList())) {
            for (ConceptReferenceType conceptReference : dimension.getConceptRoleList()) {
                this.conceptRole.add(RefUtil.createReference(this, conceptReference));
            }
        }
        this.validateDimension();
    }

    public DimensionBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType dimension, DimensionListBean parent, int position) {
        super(dimension, SDMX_STRUCTURE_TYPE.DIMENSION, dimension.getAnnotations(), dimension.getTextFormat(), dimension.getCodelistAgency(), dimension.getCodelist(), dimension.getCodelistVersion(), dimension.getConceptSchemeAgency(), dimension.getConceptSchemeRef(), dimension.getConceptVersion(), dimension.getConceptAgency(), dimension.getConceptRef(), parent);
        if (parent.getMaintainableParent() instanceof CrossSectionalDataStructureBean) {
            this.measureDimension = dimension.getIsMeasureDimension();
        }
        this.position = position;
        this.freqDimension = dimension.getIsFrequencyDimension();
        this.validateDimension();
    }

    public DimensionBeanImpl(TimeDimensionType dimension, DimensionListBean parent, int position) {
        super(dimension, SDMX_STRUCTURE_TYPE.TIME_DIMENSION, dimension.getAnnotations(), dimension.getTextFormat(), dimension.getCodelistAgency(), dimension.getCodelist(), dimension.getCodelistVersion(), dimension.getConceptSchemeAgency(), dimension.getConceptSchemeRef(), dimension.getConceptVersion(), dimension.getConceptAgency(), dimension.getConceptRef(), parent);
        this.timeDimension = true;
        this.position = position;
        this.validateDimension();
    }

    public DimensionBeanImpl(DimensionType dimension, DimensionListBean parent, int position) {
        super((XmlObject)dimension, SDMX_STRUCTURE_TYPE.DIMENSION, dimension.getAnnotations(), dimension.getCodelist(), dimension.getConcept(), (SdmxStructureBean)parent);
        this.measureDimension = false;
        this.position = position;
    }

    public DimensionBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.TimeDimensionType dimension, DimensionListBean parent, int position) {
        super((XmlObject)dimension, SDMX_STRUCTURE_TYPE.TIME_DIMENSION, dimension.getAnnotations(), dimension.getCodelist(), dimension.getConcept(), (SdmxStructureBean)parent);
        this.timeDimension = true;
        this.position = position;
        this.validateDimension();
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            DimensionBean that = (DimensionBean)bean;
            if (this.measureDimension != that.isMeasureDimension()) {
                return false;
            }
            if (this.timeDimension != that.isTimeDimension()) {
                return false;
            }
            if (this.getPosition() != that.getPosition()) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.conceptRole, that.getConceptRole())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validateDimension() {
        if (this.timeDimension) {
            this.setId("TIME_PERIOD");
            if (this.hasCodedRepresentation()) {
                throw new ValidationException("Time Dimension can not have a coded representation");
            }
            if (this.localRepresentation == null || this.localRepresentation.getTextFormat() == null) {
                RepresentationMutableBeanImpl rep = new RepresentationMutableBeanImpl();
                rep.setTextFormat(new TextFormatMutableBeanImpl());
                this.localRepresentation = new RepresentationBeanImpl(rep, (IdentifiableBean)this);
            } else if (this.localRepresentation.getTextFormat().getTextType() != null && !this.localRepresentation.getTextFormat().getTextType().isValidTimeDimensionTextType()) {
                LOG.warn("Invalid Text Format found on Time Dimension, removing Text Format : " + (Object)((Object)this.localRepresentation.getTextFormat().getTextType()));
                RepresentationMutableBeanImpl rep = new RepresentationMutableBeanImpl();
                rep.setTextFormat(new TextFormatMutableBeanImpl());
                this.localRepresentation = new RepresentationBeanImpl(rep, (IdentifiableBean)this);
            }
        } else if (this.getId().equals("TIME_PERIOD")) {
            throw new ValidationException("This dimension is NOT specified as the Time Dimension but is using the reserved id: TIME_PERIOD");
        }
        if (this.measureDimension) {
            if (this.getRepresentation() == null || this.getRepresentation().getRepresentationRef() == null) {
                throw new ValidationException("Measure Dimension missing representation");
            }
            if (!(this.getMaintainableParent() instanceof CrossSectionalDataStructureBean) && this.getRepresentation().getRepresentationRef().getTargetReference() != SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME) {
                throw new ValidationException("Measure Dimension representation must reference a concept scheme, currently it references a " + this.getRepresentation().getRepresentationRef().getTargetReference().getType());
            }
        }
        if (this.measureDimension && this.timeDimension) {
            throw new ValidationException("Dimension can not be both a Measure Dimension and a Time Dimension");
        }
    }

    @Override
    protected List<String> getParentIds(boolean includeDifferentTypes) {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add(this.getId());
        return returnList;
    }

    @Override
    public boolean isMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public boolean isFrequencyDimension() {
        if (this.freqDimension) {
            return true;
        }
        return this.getId().equals("FREQ");
    }

    @Override
    public boolean isTimeDimension() {
        return this.timeDimension;
    }

    @Override
    public List<CrossReferenceBean> getConceptRole() {
        return new ArrayList<CrossReferenceBean>(this.conceptRole);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(DimensionBean o) {
        if (o.getPosition() == this.getPosition() && !o.equals(this)) {
            throw new ValidationException("Two dimensions (" + this.getId() + " & " + o.getId() + ") can not share the same dimension position : " + this.getPosition());
        }
        return o.getPosition() > this.getPosition() ? -1 : 1;
    }
}

