/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportStructureType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataStructureDefinitionMutbaleBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataTargetMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.ReportStructureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataTargetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.ReportStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.MetadataStructureDefinitionMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataStructureDefinitionBeanImpl
extends MaintainableBeanImpl
implements MetadataStructureDefinitionBean {
    private static Logger LOG = Logger.getLogger(MetadataStructureDefinitionBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private List<ReportStructureBean> reportStructures = new ArrayList<ReportStructureBean>();
    private List<MetadataTargetBean> metadataTarget = new ArrayList<MetadataTargetBean>();

    private MetadataStructureDefinitionBeanImpl(MetadataStructureDefinitionBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug("Stub MetadataStructureDefinitionBean Built");
    }

    public MetadataStructureDefinitionBeanImpl(MetadataStructureDefinitionMutbaleBean bean) {
        super(bean);
        LOG.debug("Building MetadataStructureDefinitionBean from Mutable Bean");
        try {
            if (bean.getReportStructures() != null) {
                for (ReportStructureMutableBean reportStructureMutableBean : bean.getReportStructures()) {
                    this.reportStructures.add(new ReportStructureBeanImpl((MetadataStructureDefinitionBean)this, reportStructureMutableBean));
                }
            }
            if (bean.getMetadataTargets() != null) {
                for (MetadataTargetMutableBean metadataTargetMutableBean : bean.getMetadataTargets()) {
                    this.metadataTarget.add(new MetadataTargetBeanImpl(this, metadataTargetMutableBean));
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MetadataStructureDefinitionBean Built " + this.getUrn());
        }
    }

    public MetadataStructureDefinitionBeanImpl(MetadataStructureType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.MSD);
        LOG.debug("Building MetadataStructureDefinitionBean from 2.1 SDMX");
        try {
            if (bean.getMetadataStructureComponents() != null) {
                if (bean.getMetadataStructureComponents().getMetadataTargetList() != null) {
                    for (MetadataTargetType currentMetadataTarget : bean.getMetadataStructureComponents().getMetadataTargetList()) {
                        this.metadataTarget.add(new MetadataTargetBeanImpl(currentMetadataTarget, this));
                    }
                }
                if (bean.getMetadataStructureComponents().getReportStructureList() != null) {
                    for (ReportStructureType currentRs : bean.getMetadataStructureComponents().getReportStructureList()) {
                        this.reportStructures.add(new ReportStructureBeanImpl((MetadataStructureDefinitionBean)this, currentRs));
                    }
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MetadataStructureDefinitionBean Built " + this.getUrn());
        }
    }

    public MetadataStructureDefinitionBeanImpl(MetadataStructureDefinitionType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.MSD, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), MetadataStructureDefinitionBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), MetadataStructureDefinitionBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug("Building MetadataStructureDefinitionBean from 2.0 SDMX");
        try {
            if (bean.getReportStructureList() != null) {
                for (org.sdmx.resources.sdmxml.schemas.v20.structure.ReportStructureType currentRs : bean.getReportStructureList()) {
                    this.reportStructures.add(new ReportStructureBeanImpl((MetadataStructureDefinitionBean)this, currentRs));
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MetadataStructureDefinitionBean Built " + this.getUrn());
        }
    }

    private void validate() throws ValidationException {
        if (!this.isExternalReference.isTrue()) {
            if (!ObjectUtil.validCollection(this.metadataTarget)) {
                throw new ValidationException("Metadata Structure Definition requires at least one Metadata Target");
            }
            if (!ObjectUtil.validCollection(this.reportStructures)) {
                throw new ValidationException("Metadata Structure Definition requires at least one Report Structure");
            }
        }
        HashSet<String> metadataTargetIds = new HashSet<String>();
        for (MetadataTargetBean currentTarget : this.metadataTarget) {
            metadataTargetIds.add(currentTarget.getId());
        }
        for (ReportStructureBean currentReportStructure : this.reportStructures) {
            for (String currentTarget : currentReportStructure.getTargetMetadatas()) {
                if (metadataTargetIds.contains(currentTarget)) continue;
                throw new ValidationException("Report Structure references undefined metadata target '" + currentTarget + "'");
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            MetadataStructureDefinitionBean that = (MetadataStructureDefinitionBean)bean;
            if (!super.equivalent(this.reportStructures, that.getReportStructures())) {
                return false;
            }
            if (!super.equivalent(this.metadataTarget, that.getMetadataTargets())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    @Override
    public MetadataStructureDefinitionBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new MetadataStructureDefinitionBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public MetadataStructureDefinitionMutbaleBean getMutableInstance() {
        return new MetadataStructureDefinitionMutableBeanImpl(this);
    }

    @Override
    public List<MetadataTargetBean> getMetadataTargets() {
        return new ArrayList<MetadataTargetBean>(this.metadataTarget);
    }

    @Override
    public List<ReportStructureBean> getReportStructures() {
        return new ArrayList<ReportStructureBean>(this.reportStructures);
    }
}

