/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableObjectTargetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataTargetType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ConstraintContentTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.DataSetTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.IdentifiableTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.KeyDescriptorValuesTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataTargetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportPeriodTargetBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.IdentifiableTargetMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataTargetMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.ConstraintContentTargetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.DataSetTargetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.IdentifiableTargetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.KeyDescriptorValuesTargetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.ReportPeriodTargetBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataTargetBeanImpl
extends IdentifiableBeanImpl
implements MetadataTargetBean {
    private static final long serialVersionUID = 8862316239443734564L;
    private ConstraintContentTargetBean constraintContentTargetBean;
    private DataSetTargetBean dataSetTargetBean;
    private KeyDescriptorValuesTargetBean keyDescriptorValuesTargetBean;
    private ReportPeriodTargetBean reportPeriodTargetBean;
    private List<IdentifiableTargetBean> identifiableTargetBean = new ArrayList<IdentifiableTargetBean>();

    public MetadataTargetBeanImpl(IdentifiableBean parent, MetadataTargetMutableBean bean) {
        super(bean, (SdmxStructureBean)parent);
        if (bean.getConstraintContentTargetBean() != null) {
            this.constraintContentTargetBean = new ConstraintContentTargetBeanImpl(this, bean.getConstraintContentTargetBean());
        }
        if (bean.getKeyDescriptorValuesTargetBean() != null) {
            this.keyDescriptorValuesTargetBean = new KeyDescriptorValuesTargetBeanImpl(this, bean.getKeyDescriptorValuesTargetBean());
        }
        if (bean.getDataSetTargetBean() != null) {
            this.dataSetTargetBean = new DataSetTargetBeanImpl(bean.getDataSetTargetBean(), (MetadataTargetBean)this);
        }
        if (bean.getReportPeriodTargetBean() != null) {
            this.reportPeriodTargetBean = new ReportPeriodTargetBeanImpl(this, bean.getReportPeriodTargetBean());
        }
        if (bean.getIdentifiableTargetBean() != null) {
            for (IdentifiableTargetMutableBean currentBean : bean.getIdentifiableTargetBean()) {
                this.identifiableTargetBean.add(new IdentifiableTargetBeanImpl(currentBean, (MetadataTargetBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    protected MetadataTargetBeanImpl(MetadataTargetType bean, MetadataStructureDefinitionBean parent) {
        super(bean, SDMX_STRUCTURE_TYPE.METADATA_TARGET, (SdmxStructureBean)parent);
        if (ObjectUtil.validCollection(bean.getKeyDescriptorValuesTargetList())) {
            if (bean.getKeyDescriptorValuesTargetList().size() > 1) {
                throw new ValidationException("Metadata Target can not have more then one KeyDescriptorValuesTarget");
            }
            this.keyDescriptorValuesTargetBean = new KeyDescriptorValuesTargetBeanImpl(bean.getKeyDescriptorValuesTargetList().get(0), this);
        }
        if (ObjectUtil.validCollection(bean.getDataSetTargetList())) {
            if (bean.getDataSetTargetList().size() > 1) {
                throw new ValidationException("Metadata Target can not have more then one DataSetTarget");
            }
            this.dataSetTargetBean = new DataSetTargetBeanImpl(bean.getDataSetTargetList().get(0), (MetadataTargetBean)this);
        }
        if (ObjectUtil.validCollection(bean.getReportPeriodTargetList())) {
            if (bean.getReportPeriodTargetList().size() > 1) {
                throw new ValidationException("Metadata Target can not have more then one ReportPeriodTarget");
            }
            this.reportPeriodTargetBean = new ReportPeriodTargetBeanImpl(bean.getReportPeriodTargetList().get(0), this);
        }
        if (ObjectUtil.validCollection(bean.getConstraintContentTargetList())) {
            if (bean.getDataSetTargetList().size() > 1) {
                throw new ValidationException("Metadata Target can not have more then one ConstraintContentTarget");
            }
            this.constraintContentTargetBean = new ConstraintContentTargetBeanImpl(bean.getConstraintContentTargetList().get(0), this);
        }
        if (bean.getIdentifiableObjectTargetList() != null) {
            for (IdentifiableObjectTargetType currentTarget : bean.getIdentifiableObjectTargetList()) {
                this.identifiableTargetBean.add(new IdentifiableTargetBeanImpl(currentTarget, (MetadataTargetBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    private void validate() throws ValidationException {
        if (this.keyDescriptorValuesTargetBean == null && this.dataSetTargetBean == null && this.reportPeriodTargetBean == null && this.constraintContentTargetBean == null && !ObjectUtil.validCollection(this.identifiableTargetBean)) {
            throw new ValidationException("Metadata Target must provide at least one target (key descriptor values, dataset, constraint content, report period, or identifiable object)");
        }
        for (IdentifiableTargetBean currentTarget : this.identifiableTargetBean) {
            String currentTargetId = currentTarget.getId();
            if (this.constraintContentTargetBean != null && currentTargetId.equals(this.constraintContentTargetBean.getId())) {
                throw new ValidationException("IdentifiableTarget Id can not be the same as the ConstraintContentTarget Id: " + this.constraintContentTargetBean.getId());
            }
            if (this.dataSetTargetBean != null && currentTargetId.equals(this.dataSetTargetBean.getId())) {
                throw new ValidationException("IdentifiableTarget Id can not be the same as the DataSetTarget Id: " + this.dataSetTargetBean.getId());
            }
            if (this.keyDescriptorValuesTargetBean != null && currentTargetId.equals(this.keyDescriptorValuesTargetBean.getId())) {
                throw new ValidationException("IdentifiableTarget Id can not be the same as the KeyDescriptorValuesTarget Id: " + this.keyDescriptorValuesTargetBean.getId());
            }
            if (this.reportPeriodTargetBean == null || !currentTargetId.equals(this.reportPeriodTargetBean.getId())) continue;
            throw new ValidationException("IdentifiableTarget Id can not be the same as the ReportPeriodTargetBean Id: " + this.reportPeriodTargetBean.getId());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            MetadataTargetBean that = (MetadataTargetBean)bean;
            if (!super.equivalent(this.constraintContentTargetBean, that.getConstraintContentTargetBean())) {
                return false;
            }
            if (!super.equivalent(this.dataSetTargetBean, that.getDataSetTargetBean())) {
                return false;
            }
            if (!super.equivalent(this.keyDescriptorValuesTargetBean, that.getKeyDescriptorValuesTargetBean())) {
                return false;
            }
            if (!super.equivalent(this.reportPeriodTargetBean, that.getReportPeriodTargetBean())) {
                return false;
            }
            if (!super.equivalent(this.identifiableTargetBean, that.getIdentifiableTargetBean())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    @Override
    public ConstraintContentTargetBean getConstraintContentTargetBean() {
        return this.constraintContentTargetBean;
    }

    @Override
    public DataSetTargetBean getDataSetTargetBean() {
        return this.dataSetTargetBean;
    }

    @Override
    public KeyDescriptorValuesTargetBean getKeyDescriptorValuesTargetBean() {
        return this.keyDescriptorValuesTargetBean;
    }

    @Override
    public ReportPeriodTargetBean getReportPeriodTargetBean() {
        return this.reportPeriodTargetBean;
    }

    @Override
    public List<IdentifiableTargetBean> getIdentifiableTargetBean() {
        return new ArrayList<IdentifiableTargetBean>(this.identifiableTargetBean);
    }
}

